export type CodeRangeKey = 'sourceOffsets' | 'generatedOffsets';
export interface Mapping<T = any> {
    source?: string;
    sourceOffsets: number[];
    generatedOffsets: number[];
    lengths: number[];
    data: T;
}
export declare class SourceMap<Data = any> {
    readonly mappings: Mapping<Data>[];
    private sourceCodeOffsetsMemo;
    private generatedCodeOffsetsMemo;
    constructor(mappings: Mapping<Data>[]);
    getSourceOffset(generatedOffset: number): readonly [number, Mapping<Data>] | undefined;
    getGeneratedOffset(sourceOffset: number): readonly [number, Mapping<Data>] | undefined;
    getSourceOffsets(generatedOffset: number): Generator<readonly [number, Mapping<Data>], void, unknown>;
    getGeneratedOffsets(sourceOffset: number): Generator<readonly [number, Mapping<Data>], void, unknown>;
    findMatching(offset: number, fromRange: CodeRangeKey, toRange: CodeRangeKey): Generator<readonly [number, Mapping<Data>], void, unknown>;
    private getMemoBasedOnRange;
    private createMemo;
}
