/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.semanticTokens;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.CancellationUtil;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4e.operations.semanticTokens.SemanticTokensDataStreamProcessor;
import org.eclipse.lsp4e.operations.semanticTokens.StyleRangeHolder;
import org.eclipse.lsp4e.operations.semanticTokens.TokenTypeMapper;
import org.eclipse.lsp4e.operations.semanticTokens.VersionedSemanticTokens;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class SemanticHighlightReconcilerStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ITextPresentationListener,
ITextViewerLifecycle {
    private final boolean disabled;
    private ITextViewer viewer;
    private IDocument document;
    private StyleRangeHolder styleRangeHolder;
    private SemanticTokensDataStreamProcessor semanticTokensDataStreamProcessor;
    private boolean isInstalled;
    private volatile long documentTimestampAtLastAppliedTextPresentation;
    private volatile long timestamp = 0L;
    private CompletableFuture<Optional<VersionedSemanticTokens>> semanticTokensFullFuture;

    public SemanticHighlightReconcilerStrategy() {
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        this.disabled = store.getBoolean("semanticHighlightReconciler.disabled");
        this.isInstalled = false;
    }

    public void install(ITextViewer textViewer) {
        if (this.disabled || this.isInstalled) {
            return;
        }
        this.viewer = textViewer;
        this.styleRangeHolder = new StyleRangeHolder();
        this.semanticTokensDataStreamProcessor = new SemanticTokensDataStreamProcessor(new TokenTypeMapper(textViewer), this.offsetMapper());
        ITextViewer iTextViewer = this.viewer;
        if (iTextViewer instanceof TextViewer) {
            TextViewer textViewerImpl = (TextViewer)iTextViewer;
            textViewerImpl.addTextPresentationListener((ITextPresentationListener)this);
        }
        this.viewer.addTextListener((ITextListener)this.styleRangeHolder);
        this.isInstalled = true;
    }

    public void uninstall() {
        if (this.disabled || !this.isInstalled) {
            return;
        }
        this.isInstalled = false;
        this.cancelSemanticTokensFull();
        this.semanticTokensDataStreamProcessor = null;
        ITextViewer iTextViewer = this.viewer;
        if (iTextViewer instanceof TextViewer) {
            TextViewer textViewerImpl = (TextViewer)iTextViewer;
            textViewerImpl.removeTextPresentationListener((ITextPresentationListener)this);
        }
        this.viewer.removeTextListener((ITextListener)this.styleRangeHolder);
        this.viewer = null;
        this.styleRangeHolder = null;
    }

    private @NonNull Function<Position, Integer> offsetMapper() {
        return p -> {
            try {
                return LSPEclipseUtils.toOffset(p, this.document);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private SemanticTokensParams getSemanticTokensParams() {
        URI uri = LSPEclipseUtils.toUri(this.document);
        if (uri != null) {
            SemanticTokensParams semanticTokensParams = new SemanticTokensParams();
            semanticTokensParams.setTextDocument(LSPEclipseUtils.toTextDocumentIdentifier(uri));
            return semanticTokensParams;
        }
        return null;
    }

    private void saveStyle(Pair<SemanticTokens, SemanticTokensLegend> pair) {
        SemanticTokens semanticTokens = pair.getFirst();
        SemanticTokensLegend semanticTokensLegend = pair.getSecond();
        if (!this.isInstalled || semanticTokens == null || semanticTokensLegend == null) {
            return;
        }
        List dataStream = semanticTokens.getData();
        if (!dataStream.isEmpty()) {
            List<StyleRange> styleRanges = this.semanticTokensDataStreamProcessor.getStyleRanges(dataStream, semanticTokensLegend);
            this.styleRangeHolder.saveStyles(styleRanges);
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    private boolean hasSemanticTokensFull(ServerCapabilities serverCapabilities) {
        return serverCapabilities.getSemanticTokensProvider() != null && LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)serverCapabilities.getSemanticTokensProvider().getFull());
    }

    public @Nullable SemanticTokensLegend getSemanticTokensLegend(LanguageServerWrapper wrapper) {
        SemanticTokensWithRegistrationOptions semanticTokensProvider;
        ServerCapabilities serverCapabilities = wrapper.getServerCapabilities();
        if (serverCapabilities != null && (semanticTokensProvider = serverCapabilities.getSemanticTokensProvider()) != null) {
            return semanticTokensProvider.getLegend();
        }
        return null;
    }

    private boolean outdatedTextPresentation(long documentTimestamp) {
        return this.documentTimestampAtLastAppliedTextPresentation == 0L || this.documentTimestampAtLastAppliedTextPresentation == documentTimestamp;
    }

    private void invalidateTextPresentation(Long documentTimestamp) {
        if (!this.isInstalled) {
            return;
        }
        StyledText textWidget = this.viewer.getTextWidget();
        textWidget.getDisplay().asyncExec(() -> {
            ITextViewer theViewer;
            if (!textWidget.isDisposed() && this.outdatedTextPresentation(documentTimestamp) && (theViewer = this.viewer) != null) {
                theViewer.invalidateTextPresentation();
            }
        });
    }

    private void cancelSemanticTokensFull() {
        if (this.semanticTokensFullFuture != null) {
            this.semanticTokensFullFuture.cancel(true);
        }
    }

    private void fullReconcile() {
        block5: {
            if (this.disabled || !this.isInstalled) {
                return;
            }
            IDocument theDocument = this.document;
            this.cancelSemanticTokensFull();
            if (theDocument != null) {
                long modificationStamp = DocumentUtil.getDocumentModificationStamp(theDocument);
                LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(theDocument).withFilter(this::hasSemanticTokensFull);
                try {
                    this.semanticTokensFullFuture = executor.computeFirst((w, ls) -> ls.getTextDocumentService().semanticTokensFull(this.getSemanticTokensParams()).thenApply(semanticTokens -> new VersionedSemanticTokens(modificationStamp, Pair.of(semanticTokens, this.getSemanticTokensLegend((LanguageServerWrapper)w)), theDocument)));
                    this.semanticTokensFullFuture.get().ifPresent(versionedSemanticTokens -> versionedSemanticTokens.apply(this::saveStyle, this::invalidateTextPresentation));
                }
                catch (InterruptedException e) {
                    LanguageServerPlugin.logError(e);
                    Thread.currentThread().interrupt();
                }
                catch (CancellationException | ExecutionException | ResponseErrorException e) {
                    if (CancellationUtil.isRequestCancelledException(e)) break block5;
                    LanguageServerPlugin.logError(e);
                }
            }
        }
    }

    public void initialReconcile() {
        this.fullReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.fullReconcileOnce();
    }

    public void reconcile(IRegion partition) {
        this.fullReconcileOnce();
    }

    private void fullReconcileOnce() {
        long ts = DocumentUtil.getDocumentModificationStamp(this.document);
        if (ts != this.timestamp) {
            this.fullReconcile();
            this.timestamp = ts;
        }
    }

    public void applyTextPresentation(TextPresentation textPresentation) {
        this.documentTimestampAtLastAppliedTextPresentation = DocumentUtil.getDocumentModificationStamp(this.document);
        IRegion extent = textPresentation.getExtent();
        if (extent != null) {
            textPresentation.replaceStyleRanges(this.styleRangeHolder.overlappingRanges(extent));
        }
    }
}

