/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.io.File;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.Activator;

public class SelectionUtils {
    private SelectionUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private static IFile getSelectedIFile() {
        IEditorInput input;
        IEditorInput iEditorInput;
        try {
            ISelection selection;
            ISelection iSelection = selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (iSelection instanceof IStructuredSelection) {
                void structuredSelection;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
                return (IFile)Adapters.adapt((Object)structuredSelection.getFirstElement(), IFile.class);
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e));
        }
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && (iEditorInput = (input = editor.getEditorInput())) instanceof IFileEditorInput) {
            void file;
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            IFileEditorInput cfr_ignored_1 = (IFileEditorInput)iEditorInput;
            return file.getFile();
        }
        return null;
    }

    public static File getSelectedFile(Predicate<File> condition) {
        File file;
        IEditorPart editor;
        IFile iFile = SelectionUtils.getSelectedIFile();
        if (iFile != null) {
            File file2 = iFile.getRawLocation().makeAbsolute().toFile();
            if (condition == null || condition.test(file2)) {
                return file2;
            }
        }
        if ((editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && (file = SelectionUtils.getFile(editor.getEditorInput(), condition)) != null) {
            return file;
        }
        return null;
    }

    public static File getSelectedProject() {
        IFile iFile = SelectionUtils.getSelectedIFile();
        if (iFile != null) {
            return iFile.getProject().getLocation().toFile();
        }
        File file = SelectionUtils.getSelectedFile(null);
        if (file != null) {
            return file.getParentFile();
        }
        return null;
    }

    public static String pathOrEmpty(File file) {
        return file != null ? file.getAbsolutePath() : "";
    }

    /*
     * WARNING - void declaration
     */
    public static File getFile(ISelection selection, Predicate<File> condition) {
        IWorkbenchPart part;
        IWorkbenchPart iWorkbenchPart;
        IResource resource;
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection) {
            void structuredSelection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            Object firstElement = structuredSelection.getFirstElement();
            resource = (IResource)Adapters.adapt((Object)firstElement, IResource.class);
            if (resource != null) {
                File file = resource.getLocation().toFile();
                if (condition == null || condition.test(file)) {
                    return file;
                }
            }
        }
        if (selection instanceof TextSelection && (iWorkbenchPart = (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart())) instanceof ITextEditor) {
            void editor;
            resource = (ITextEditor)iWorkbenchPart;
            ITextEditor cfr_ignored_1 = (ITextEditor)iWorkbenchPart;
            return SelectionUtils.getFile(editor.getEditorInput(), condition);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static File getFile(IEditorInput editorInput, Predicate<File> condition) {
        IEditorInput iEditorInput;
        Object file;
        IEditorInput iEditorInput2 = editorInput;
        if (iEditorInput2 instanceof FileEditorInput) {
            void input;
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput2;
            FileEditorInput cfr_ignored_0 = (FileEditorInput)iEditorInput2;
            file = input.getFile().getLocation().toFile();
            if (file != null && (condition == null || condition.test((File)file))) {
                return file;
            }
        }
        if ((iEditorInput = editorInput) instanceof IURIEditorInput) {
            void input;
            file = (IURIEditorInput)iEditorInput;
            IURIEditorInput cfr_ignored_1 = (IURIEditorInput)iEditorInput;
            File file2 = new File(input.getURI());
            if (condition == null || condition.test(file2)) {
                return file2;
            }
        }
        return null;
    }
}

