/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.tabs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.actions.AbstractTerminalAction;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionClearAll;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCopy;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionPaste;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.view.ui.actions.AbstractAction;
import org.eclipse.tm.terminal.view.ui.actions.NewTerminalViewAction;
import org.eclipse.tm.terminal.view.ui.actions.TabScrollLockAction;
import org.eclipse.tm.terminal.view.ui.actions.ToggleCommandFieldAction;
import org.eclipse.tm.terminal.view.ui.interfaces.ITerminalsView;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderManager;
import org.eclipse.ui.IActionBars;

public class TabFolderToolbarHandler
extends PlatformObject {
    private final ITerminalsView parentView;
    private IToolBarManager toolbarManager;
    private ToolbarSelectionChangedListener selectionChangedListener;
    private final List<AbstractTerminalAction> toolbarActions = new ArrayList<AbstractTerminalAction>();

    public TabFolderToolbarHandler(ITerminalsView parentView) {
        Assert.isNotNull((Object)parentView);
        this.parentView = parentView;
    }

    protected final ITerminalsView getParentView() {
        return this.parentView;
    }

    protected final CTabFolder getTabFolder() {
        return (CTabFolder)this.getParentView().getAdapter(CTabFolder.class);
    }

    public ITerminalViewControl getActiveTerminalViewControl() {
        CTabItem activeTabItem;
        ITerminalViewControl terminal = null;
        TabFolderManager manager = (TabFolderManager)((Object)this.getParentView().getAdapter(TabFolderManager.class));
        if (manager != null && (activeTabItem = manager.getActiveTabItem()) != null && !activeTabItem.isDisposed()) {
            terminal = (ITerminalViewControl)activeTabItem.getData();
        }
        return terminal;
    }

    public void dispose() {
        if (this.selectionChangedListener != null) {
            this.getParentView().getViewSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
            this.selectionChangedListener = null;
        }
        this.toolbarActions.clear();
    }

    public void initialize() {
        if (this.toolbarManager != null) {
            return;
        }
        this.selectionChangedListener = this.doCreateSelectionChangedListener();
        Assert.isNotNull((Object)this.selectionChangedListener);
        this.getParentView().getViewSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.selectionChangedListener);
        IActionBars bars = this.getParentView().getViewSite().getActionBars();
        this.toolbarManager = bars.getToolBarManager();
        this.doCreateToolbarActions();
        this.doFillToolbar(this.toolbarManager);
        this.updateToolbarItems(false);
    }

    protected ToolbarSelectionChangedListener doCreateSelectionChangedListener() {
        return new ToolbarSelectionChangedListener();
    }

    protected final void add(AbstractTerminalAction action) {
        Assert.isNotNull((Object)action);
        this.toolbarActions.add(action);
    }

    protected final void remove(AbstractTerminalAction action) {
        Assert.isNotNull((Object)action);
        this.toolbarActions.remove(action);
    }

    protected void doCreateToolbarActions() {
        this.add((AbstractTerminalAction)new TerminalActionPaste(){

            protected ITerminalViewControl getTarget() {
                return TabFolderToolbarHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add((AbstractTerminalAction)new TerminalActionCopy(){

            protected ITerminalViewControl getTarget() {
                return TabFolderToolbarHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add(new TabScrollLockAction(){

            protected ITerminalViewControl getTarget() {
                return TabFolderToolbarHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add((AbstractTerminalAction)new TerminalActionClearAll(){

            protected ITerminalViewControl getTarget() {
                return TabFolderToolbarHandler.this.getActiveTerminalViewControl();
            }

            public void updateAction(boolean aboutToShow) {
                super.updateAction(aboutToShow);
                if (this.getTarget() != null && this.getTarget().getState() != TerminalState.CONNECTED) {
                    this.setEnabled(false);
                }
            }
        });
        this.add(new ToggleCommandFieldAction(this.getParentView()){

            protected ITerminalViewControl getTarget() {
                return TabFolderToolbarHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add(new NewTerminalViewAction(this.getParentView()){

            protected ITerminalViewControl getTarget() {
                return TabFolderToolbarHandler.this.getActiveTerminalViewControl();
            }
        });
    }

    protected void doFillToolbar(IToolBarManager manager) {
        Assert.isNotNull((Object)manager);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("anchor"));
        NewTerminalViewAction newTerminalAction = null;
        for (AbstractTerminalAction action : this.toolbarActions) {
            if (action instanceof TabScrollLockAction || action instanceof AbstractAction && ((AbstractAction)action).isSeparator()) {
                manager.insertAfter("anchor", (IContributionItem)new Separator());
            }
            if (action instanceof NewTerminalViewAction) {
                newTerminalAction = (NewTerminalViewAction)action;
                continue;
            }
            manager.insertAfter("anchor", (IAction)action);
        }
        if (newTerminalAction != null) {
            manager.add(newTerminalAction);
        }
    }

    protected void updateToolbarItems(boolean enabled) {
        ITerminalViewControl control = this.getActiveTerminalViewControl();
        for (AbstractTerminalAction action : this.toolbarActions) {
            if (control == null && !(action instanceof NewTerminalViewAction)) {
                action.setEnabled(false);
                continue;
            }
            action.updateAction(enabled);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IToolBarManager.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.toolbarManager);
        }
        for (AbstractTerminalAction action : this.toolbarActions) {
            if (!adapter.isAssignableFrom(action.getClass())) continue;
            return adapter.cast(action);
        }
        Object adapted = this.getParentView().getAdapter(adapter);
        if (adapted != null) {
            return (T)adapted;
        }
        return (T)super.getAdapter(adapter);
    }

    protected class ToolbarSelectionChangedListener
    implements ISelectionChangedListener {
        protected ToolbarSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean enable;
            boolean bl = enable = event != null;
            if (enable && event.getSource() instanceof TabFolderManager) {
                enable = event.getSelection() instanceof StructuredSelection && !event.getSelection().isEmpty() && (((StructuredSelection)event.getSelection()).getFirstElement() instanceof CTabItem || ((StructuredSelection)event.getSelection()).getFirstElement() instanceof String);
            }
            TabFolderToolbarHandler.this.updateToolbarItems(enable);
        }
    }
}

