/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiResources;
import org.eclipse.epp.internal.mpc.ui.wizards.FeatureSelectionWizardPage;
import org.eclipse.epp.internal.mpc.ui.wizards.IWizardButtonLabelProvider;
import org.eclipse.epp.internal.mpc.ui.wizards.IWizardPageAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class AbstractMarketplaceWizardDialog
extends WizardDialog {
    private Button backButton;
    private Button nextButton;
    private Button cancelButton;
    private Button finishButton;
    private final PageListener pageListener = new PageListener();

    public AbstractMarketplaceWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        this.addPageChangingListener(this.pageListener);
        this.addPageChangedListener(this.pageListener);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        switch (id) {
            case 15: {
                this.nextButton = button;
                break;
            }
            case 14: {
                this.backButton = button;
                break;
            }
            case 1: {
                this.cancelButton = button;
                break;
            }
            case 16: {
                this.finishButton = button;
            }
        }
        return button;
    }

    protected void backPressed() {
        IWizardPage fromPage = this.getCurrentPage();
        this.pageListener.setBackward();
        try {
            super.backPressed();
        }
        finally {
            this.pageListener.reset();
        }
        if (fromPage instanceof FeatureSelectionWizardPage && ((FeatureSelectionWizardPage)fromPage).isInRemediationMode()) {
            ((FeatureSelectionWizardPage)fromPage).flipToDefaultComposite();
        }
    }

    protected void nextPressed() {
        this.pageListener.setForward();
        try {
            super.nextPressed();
        }
        finally {
            this.pageListener.reset();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.backButton != null || this.nextButton != null) {
            AccessibleAdapter adapter = new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    Button button = (Button)((Accessible)e.getSource()).getControl();
                    String text = button.getText();
                    e.result = text.replace('<', ' ').replace('>', ' ');
                }
            };
            if (this.backButton != null) {
                this.backButton.getAccessible().addAccessibleListener((AccessibleListener)adapter);
            }
            if (this.nextButton != null) {
                this.nextButton.getAccessible().addAccessibleListener((AccessibleListener)adapter);
            }
        }
    }

    public void updateButtons() {
        super.updateButtons();
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage != null) {
            String finishButtonLabel;
            String cancelButtonLabel;
            String backButtonLabel;
            String nextButtonLabel;
            Composite buttonBar = null;
            boolean buttonsChanged = false;
            if (this.nextButton != null && !(nextButtonLabel = this.getNextButtonLabel(currentPage)).equals(this.nextButton.getText())) {
                this.nextButton.setText(nextButtonLabel);
                this.setButtonLayoutData(this.nextButton);
                buttonsChanged = true;
                buttonBar = this.nextButton.getParent();
            }
            if (this.backButton != null && !(backButtonLabel = this.getBackButtonLabel(currentPage)).equals(this.backButton.getText())) {
                this.backButton.setText(backButtonLabel);
                this.setButtonLayoutData(this.backButton);
                buttonsChanged = true;
                buttonBar = this.backButton.getParent();
            }
            if (this.cancelButton != null && !(cancelButtonLabel = this.getCancelButtonLabel(currentPage)).equals(this.cancelButton.getText())) {
                this.cancelButton.setText(cancelButtonLabel);
                this.setButtonLayoutData(this.cancelButton);
                buttonsChanged = true;
                buttonBar = this.cancelButton.getParent();
            }
            if (this.finishButton != null && !(finishButtonLabel = this.getFinishButtonLabel(currentPage)).equals(this.finishButton.getText())) {
                this.finishButton.setText(finishButtonLabel);
                this.setButtonLayoutData(this.finishButton);
                buttonsChanged = true;
                buttonBar = this.finishButton.getParent();
            }
            if (buttonsChanged && buttonBar != null) {
                buttonBar.layout(true);
            }
        }
    }

    public String getNextButtonLabel(IWizardPage page) {
        IWizardButtonLabelProvider labelProvider;
        String nextButtonLabel;
        if (page instanceof IWizardButtonLabelProvider && (nextButtonLabel = (labelProvider = (IWizardButtonLabelProvider)page).getNextButtonLabel()) != null) {
            return nextButtonLabel;
        }
        return IDialogConstants.NEXT_LABEL;
    }

    public String getBackButtonLabel(IWizardPage page) {
        IWizardButtonLabelProvider labelProvider;
        String backButtonLabel;
        if (page instanceof IWizardButtonLabelProvider && (backButtonLabel = (labelProvider = (IWizardButtonLabelProvider)page).getBackButtonLabel()) != null) {
            return backButtonLabel;
        }
        return IDialogConstants.BACK_LABEL;
    }

    public String getFinishButtonLabel(IWizardPage page) {
        return IDialogConstants.FINISH_LABEL;
    }

    public String getCancelButtonLabel(IWizardPage page) {
        return IDialogConstants.CANCEL_LABEL;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        Class<?> dialogClass = ((Object)((Object)this)).getClass();
        return AbstractMarketplaceWizardDialog.getDialogBoundsSettings(dialogClass, this.getParentShell() != null, true);
    }

    protected static IDialogSettings getDialogBoundsSettings(Class<? extends AbstractMarketplaceWizardDialog> dialogClass, boolean relative, boolean create) {
        String sectionName = String.valueOf(dialogClass.getName()) + "_dialogBounds." + (relative ? "relative" : "absolute");
        IDialogSettings settings = MarketplaceClientUiResources.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null && create) {
            section = settings.addNewSection(sectionName);
            IDialogSettings companionSettings = AbstractMarketplaceWizardDialog.getDialogBoundsSettings(dialogClass, !relative, false);
            if (companionSettings != null) {
                AbstractMarketplaceWizardDialog.copyInitialSize(companionSettings, settings);
            }
        }
        return section;
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    static void copyInitialSize(IDialogSettings sourceSettings, IDialogSettings targetSettings) {
        AbstractMarketplaceWizardDialog.copySettings(sourceSettings, targetSettings, "DIALOG_WIDTH");
        AbstractMarketplaceWizardDialog.copySettings(sourceSettings, targetSettings, "DIALOG_HEIGHT");
        AbstractMarketplaceWizardDialog.copySettings(sourceSettings, targetSettings, "DIALOG_FONT_NAME");
    }

    static void copyInitialLocation(IDialogSettings sourceSettings, IDialogSettings targetSettings) {
        AbstractMarketplaceWizardDialog.copySettings(sourceSettings, targetSettings, "DIALOG_X_ORIGIN");
        AbstractMarketplaceWizardDialog.copySettings(sourceSettings, targetSettings, "DIALOG_Y_ORIGIN");
    }

    static void setInitialLocation(int x, int y, IDialogSettings targetSettings) {
        targetSettings.put("DIALOG_X_ORIGIN", x);
        targetSettings.put("DIALOG_Y_ORIGIN", y);
    }

    static void copySettings(IDialogSettings sourceSettings, IDialogSettings targetSettings, String key) {
        String value = sourceSettings.get(key);
        if (value != null) {
            targetSettings.put(key, value);
        }
    }

    private static final class PageListener
    implements IPageChangingListener,
    IPageChangedListener {
        private Boolean forward;

        private PageListener() {
        }

        public void pageChanged(PageChangedEvent event) {
            if (this.forward != null) {
                boolean isForward = this.forward;
                this.reset();
                Object selectedPage = event.getSelectedPage();
                if (selectedPage instanceof IWizardPageAction) {
                    ((IWizardPageAction)selectedPage).enter(isForward);
                }
            }
        }

        public void handlePageChanging(PageChangingEvent event) {
            Object currentPage = event.getCurrentPage();
            if (event.doit && this.forward != null && currentPage instanceof IWizardPageAction) {
                event.doit = ((IWizardPageAction)currentPage).exit(this.forward);
                if (!event.doit) {
                    this.forward = null;
                }
            }
        }

        public void setForward() {
            this.forward = true;
        }

        public void setBackward() {
            this.forward = false;
        }

        public void reset() {
            this.forward = null;
        }
    }
}

