/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;

public class SubSystemHelpers {
    public static ISubSystem getParentSubSystem(ISystemFilterPoolReference poolReference) {
        return (ISubSystem)poolReference.getProvider();
    }

    public static ISubSystemConfiguration getParentSubSystemConfiguration(ISystemFilterPool pool) {
        return (ISubSystemConfiguration)pool.getProvider();
    }

    public static ISubSystemConfiguration getParentSubSystemConfiguration(ISystemFilter filter) {
        return (ISubSystemConfiguration)filter.getProvider();
    }

    public static ISubSystemConfiguration getParentSubSystemConfiguration(ISystemFilterContainer container) {
        if (container instanceof ISystemFilterPool) {
            return SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilterPool)container);
        }
        return SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilter)container);
    }

    public static ISubSystemConfiguration getParentSubSystemConfiguration(ISystemFilterPoolReference poolRef) {
        ISystemFilterPool pool = poolRef.getReferencedFilterPool();
        if (pool != null) {
            return SubSystemHelpers.getParentSubSystemConfiguration(pool);
        }
        return null;
    }

    public static ISubSystemConfiguration getParentSubSystemConfiguration(ISystemFilterReference filterRef) {
        ISystemFilter filter = filterRef.getReferencedFilter();
        if (filter != null) {
            return SubSystemHelpers.getParentSubSystemConfiguration(filter);
        }
        return null;
    }

    public static ISystemFilterPoolManager getParentSystemFilterPoolManager(ISystemFilterPool pool) {
        return pool.getSystemFilterPoolManager();
    }

    public static ISystemProfile getParentSystemProfile(ISystemFilterPool pool) {
        return SubSystemHelpers.getParentSubSystemConfiguration(pool).getSystemProfile(pool);
    }
}

