/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class IndentFoldingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IProjectionListener {
    private IDocument document;
    private ProjectionViewer viewer;
    private ProjectionAnnotationModel projectionAnnotationModel;
    private final String lineStartsWithKeyword;
    private boolean hasExternalFoldingAnnotations = false;

    public IndentFoldingStrategy() {
        this(null);
    }

    public IndentFoldingStrategy(String lineStartsWithKeyword) {
        this.lineStartsWithKeyword = lineStartsWithKeyword;
    }

    public void setViewer(ProjectionViewer viewer) {
        if (this.viewer != null) {
            this.viewer.removeProjectionListener((IProjectionListener)this);
        }
        this.viewer = viewer;
        this.viewer.addProjectionListener((IProjectionListener)this);
        this.projectionAnnotationModel = this.viewer.getProjectionAnnotationModel();
    }

    public void uninstall() {
        this.setDocument(null);
        if (this.viewer != null) {
            this.viewer.removeProjectionListener((IProjectionListener)this);
            this.viewer = null;
        }
        this.projectionDisabled();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void projectionDisabled() {
        this.projectionAnnotationModel = null;
    }

    public void projectionEnabled() {
        if (this.viewer != null) {
            this.projectionAnnotationModel = this.viewer.getProjectionAnnotationModel();
            if (this.projectionAnnotationModel != null) {
                this.projectionAnnotationModel.addAnnotationModelListener(model -> {
                    this.hasExternalFoldingAnnotations = this.containsExternalFoldingAnnotations();
                    if (this.hasExternalFoldingAnnotations) {
                        this.removeCurrentFoldingAnnotations();
                    } else {
                        this.initialReconcile();
                    }
                });
            }
        }
    }

    private boolean containsExternalFoldingAnnotations() {
        Iterator<Annotation> iter = this.getAnnotationIterator(null);
        boolean hasExternalFoldingAnnotation = false;
        if (iter != null) {
            while (iter.hasNext()) {
                Annotation anno = iter.next();
                if (anno instanceof FoldingAnnotation) continue;
                hasExternalFoldingAnnotation = true;
                break;
            }
        }
        return hasExternalFoldingAnnotation;
    }

    private void removeCurrentFoldingAnnotations() {
        ArrayList modifications = new ArrayList();
        List<Object> deletions = new ArrayList();
        HashMap additions = new HashMap();
        Iterator<Annotation> iter = this.getAnnotationIterator(null);
        deletions = this.getAllAnnotationsForDeletion(iter);
        this.projectionAnnotationModel.modifyAnnotations(deletions.toArray(new Annotation[1]), additions, modifications.toArray(new Annotation[0]));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (this.projectionAnnotationModel != null && !this.hasExternalFoldingAnnotations) {
            ArrayList<Annotation> modifications = new ArrayList<Annotation>();
            ArrayList<FoldingAnnotation> deletions = new ArrayList<FoldingAnnotation>();
            ArrayList<FoldingAnnotation> existing = new ArrayList<FoldingAnnotation>();
            HashMap<Annotation, Position> additions = new HashMap<Annotation, Position>();
            this.markInvalidAnnotationsForDeletion(dirtyRegion, deletions, existing);
            ArrayList<LineIndent> previousRegions = new ArrayList<LineIndent>();
            int tabSize = 1;
            int minimumRangeSize = 1;
            try {
                int endLine = this.document.getNumberOfLines() - 1;
                previousRegions.add(new LineIndent(endLine + 1, -1));
                int lastLineWhichIsNotEmpty = 0;
                int lineEmptyCount = 0;
                Integer lastLineForKeyword = null;
                int line = endLine;
                line = endLine;
                while (line >= 0) {
                    int lineOffset = this.document.getLineOffset(line);
                    String delim = this.document.getLineDelimiter(line);
                    int lineLength = this.document.getLineLength(line) - (delim != null ? delim.length() : 0);
                    String lineContent = this.document.get(lineOffset, lineLength);
                    LineState state = this.getLineState(lineContent, lastLineForKeyword);
                    switch (state) {
                        case StartWithKeyWord: {
                            lineEmptyCount = 0;
                            lastLineWhichIsNotEmpty = line;
                            if (lastLineForKeyword != null) break;
                            lastLineForKeyword = line;
                            break;
                        }
                        case EmptyLine: {
                            ++lineEmptyCount;
                            break;
                        }
                        default: {
                            this.addAnnotationForKeyword(modifications, deletions, existing, additions, line + 1 + lineEmptyCount, lastLineForKeyword);
                            lastLineForKeyword = null;
                            lineEmptyCount = 0;
                            lastLineWhichIsNotEmpty = line;
                            int indent = IndentFoldingStrategy.computeIndentLevel(lineContent, tabSize);
                            if (indent == -1) break;
                            LineIndent previous = (LineIndent)previousRegions.get(previousRegions.size() - 1);
                            if (previous.indent > indent) {
                                do {
                                    previousRegions.remove(previousRegions.size() - 1);
                                    previous = (LineIndent)previousRegions.get(previousRegions.size() - 1);
                                } while (previous.indent > indent);
                                int endLineNumber = previous.line - 1;
                                if (endLineNumber - line >= minimumRangeSize) {
                                    this.updateAnnotation(modifications, deletions, existing, additions, line, endLineNumber);
                                }
                            }
                            if (previous.indent == indent) {
                                previous.line = line;
                                break;
                            }
                            previousRegions.add(new LineIndent(line, indent));
                        }
                    }
                    --line;
                }
                this.addAnnotationForKeyword(modifications, deletions, existing, additions, lastLineWhichIsNotEmpty, lastLineForKeyword);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (this.projectionAnnotationModel != null) {
                if (!existing.isEmpty()) {
                    deletions.addAll(existing);
                }
                this.projectionAnnotationModel.modifyAnnotations(deletions.toArray(new Annotation[1]), additions, modifications.toArray(new Annotation[0]));
            }
        }
    }

    private void addAnnotationForKeyword(List<Annotation> modifications, List<FoldingAnnotation> deletions, List<FoldingAnnotation> existing, Map<Annotation, Position> additions, int startLine, Integer lastLineForKeyword) throws BadLocationException {
        if (lastLineForKeyword != null) {
            this.updateAnnotation(modifications, deletions, existing, additions, startLine, lastLineForKeyword);
        }
    }

    private LineState getLineState(String lineContent, Integer lastLineForKeyword) {
        if (this.lineStartsWithKeyword == null) {
            return LineState.DontStartWithKeyWord;
        }
        if (lineContent != null && lineContent.trim().startsWith(this.lineStartsWithKeyword)) {
            return LineState.StartWithKeyWord;
        }
        if (lastLineForKeyword != null && (lineContent == null || lineContent.trim().isEmpty())) {
            return LineState.EmptyLine;
        }
        return LineState.DontStartWithKeyWord;
    }

    private static int computeIndentLevel(String line, int tabSize) {
        int i = 0;
        int indent = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch == ' ') {
                ++indent;
            } else {
                if (ch != '\t') break;
                indent = indent - indent % tabSize + tabSize;
            }
            ++i;
        }
        if (i == line.length()) {
            return -1;
        }
        return indent;
    }

    private Iterator<Annotation> getAnnotationIterator(DirtyRegion dirtyRegion) {
        Iterator annoIter = null;
        if (this.projectionAnnotationModel != null) {
            annoIter = this.projectionAnnotationModel.getAnnotationIterator(0, this.document.getLength(), false, false);
        }
        return annoIter;
    }

    private void updateAnnotation(List<Annotation> modifications, List<FoldingAnnotation> deletions, List<FoldingAnnotation> existing, Map<Annotation, Position> additions, int line, Integer endLineNumber) throws BadLocationException {
        int startOffset = this.document.getLineOffset(line);
        int endOffset = this.document.getLineOffset(endLineNumber.intValue()) + this.document.getLineLength(endLineNumber.intValue());
        Position newPos = new Position(startOffset, endOffset - startOffset);
        if (!existing.isEmpty()) {
            FoldingAnnotation existingAnnotation = existing.remove(existing.size() - 1);
            this.updateAnnotations((Annotation)existingAnnotation, newPos, modifications, deletions);
        } else {
            additions.put((Annotation)new FoldingAnnotation(false), newPos);
        }
    }

    protected void updateAnnotations(Annotation existingAnnotation, Position newPos, List<Annotation> modifications, List<FoldingAnnotation> deletions) {
        if (existingAnnotation instanceof FoldingAnnotation) {
            FoldingAnnotation foldingAnnotation = (FoldingAnnotation)existingAnnotation;
            if (newPos != null && newPos.length > 0 && this.projectionAnnotationModel != null) {
                Position oldPos = this.projectionAnnotationModel.getPosition((Annotation)foldingAnnotation);
                if (!newPos.equals((Object)oldPos)) {
                    oldPos.setOffset(newPos.offset);
                    oldPos.setLength(newPos.length);
                    modifications.add((Annotation)foldingAnnotation);
                }
            } else {
                deletions.add(foldingAnnotation);
            }
        }
    }

    protected void markInvalidAnnotationsForDeletion(DirtyRegion dirtyRegion, List<FoldingAnnotation> deletions, List<FoldingAnnotation> existing) {
        Iterator<Annotation> iter = this.getAnnotationIterator(dirtyRegion);
        if (iter != null) {
            while (iter.hasNext()) {
                Annotation anno = iter.next();
                if (!(anno instanceof FoldingAnnotation)) continue;
                FoldingAnnotation folding = (FoldingAnnotation)anno;
                Position pos = this.projectionAnnotationModel.getPosition(anno);
                if (pos.length == 0) {
                    deletions.add(folding);
                    continue;
                }
                existing.add(folding);
            }
        }
    }

    protected List<FoldingAnnotation> getAllAnnotationsForDeletion(Iterator<Annotation> iter) {
        ArrayList<FoldingAnnotation> deletions = new ArrayList<FoldingAnnotation>();
        if (iter != null) {
            while (iter.hasNext()) {
                Annotation anno = iter.next();
                if (!(anno instanceof FoldingAnnotation)) continue;
                deletions.add((FoldingAnnotation)anno);
            }
        }
        return deletions;
    }

    public void reconcile(IRegion partition) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.reconcile(new DirtyRegion(0, this.document.getLength(), "__insert", this.document.get()), null);
    }

    protected class FoldingAnnotation
    extends ProjectionAnnotation {
        private boolean visible;

        public FoldingAnnotation(boolean isCollapsed) {
            super(isCollapsed);
            this.visible = false;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && (metrics = gc.getFontMetrics()) != null && rectangle.height / metrics.getHeight() <= 1) {
                this.visible = false;
                return;
            }
            this.visible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.visible) {
                super.markCollapsed();
            }
        }
    }

    private static class LineIndent {
        public int line;
        public final int indent;

        public LineIndent(int line, int indent) {
            this.line = line;
            this.indent = indent;
        }
    }

    private static enum LineState {
        StartWithKeyWord,
        DontStartWithKeyWord,
        EmptyLine;

    }
}

