/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.server.SecuredThread;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;
import org.eclipse.rse.services.clientserver.SystemOperationMonitor;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class CreateFileThread
extends SecuredThread
implements ICancellableHandler {
    protected DataElement _subject;
    protected DataElement _status;
    protected UniversalFileSystemMiner _miner;
    protected String _queryType;
    protected boolean _isCancelled = false;
    protected boolean _isDone = false;
    protected SystemOperationMonitor systemOperationMonitor = new SystemOperationMonitor();
    public static final String CLASSNAME = "CreateFileThread";

    public CreateFileThread(DataElement theElement, String queryType, UniversalFileSystemMiner miner, DataStore dataStore, DataElement status) {
        super(dataStore);
        this._subject = theElement;
        this._miner = miner;
        this._status = status;
        this._queryType = queryType;
    }

    public void cancel() {
        this._isCancelled = true;
        if (this.systemOperationMonitor != null) {
            this.systemOperationMonitor.setCancelled(true);
        }
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean isDone() {
        return this._isDone;
    }

    public void run() {
        super.run();
        try {
            this.handleCreateFile();
        }
        catch (SystemMessageException e) {
            this._status.setAttribute(4, "failed");
            this._miner.statusDone(this._status);
        }
        this._isDone = true;
    }

    private DataElement handleCreateFile() throws SystemMessageException {
        boolean wasFilter = this._queryType.equals("universal.FilterObject");
        if (this._queryType.equals("universal.VirtualFileObject")) {
            return this.handleCreateVirtualFile(this._subject, this._status, this._queryType);
        }
        File filename = null;
        if (this._queryType.equals("universal.FilterObject")) {
            if (this._subject.getName().indexOf("#virtual#/") > 0) {
                this._subject.setAttribute(0, "universal.VirtualFileObject");
                return this.handleCreateVirtualFile(this._subject, this._status, this._queryType);
            }
            filename = new File(this._subject.getValue());
            this._subject.setAttribute(0, "universal.FileObject");
            this._subject.setAttribute(4, this._miner.setProperties(filename));
        } else if (this._queryType.equals("universal.FileObject")) {
            filename = new File(String.valueOf(this._subject.getAttribute(3)) + File.separatorChar + this._subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleCreateFile", null, this._dataStore);
        }
        if (filename != null) {
            if (filename.exists()) {
                this._status.setAttribute(4, "failed with exist");
            } else {
                String[] stringArray = new String[4];
                stringArray[0] = "CREATE-FILE";
                stringArray[1] = filename.getAbsolutePath();
                String[] auditData = stringArray;
                UniversalServerUtilities.logAudit(auditData, this._dataStore);
                try {
                    boolean done = filename.createNewFile();
                    if (ArchiveHandlerManager.getInstance().isArchive(filename)) {
                        ArchiveHandlerManager.getInstance().createEmptyArchive(filename);
                        this._subject.setAttribute(0, "universal.ArchiveFileObject");
                    } else if (done) {
                        this._subject.setAttribute(0, "universal.FileObject");
                    }
                    this._subject.setAttribute(4, this._miner.setProperties(filename));
                    if (done) {
                        this._status.setAttribute(4, "success");
                        if (wasFilter) {
                            String fullName = this._subject.getValue();
                            String name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
                            String path = fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
                            this._subject.setAttribute(2, name);
                            this._subject.setAttribute(3, path);
                        }
                    } else {
                        this._status.setAttribute(4, "failed");
                    }
                }
                catch (Exception e) {
                    UniversalServerUtilities.logError(CLASSNAME, "handleCreateFile failed", e, this._dataStore);
                    this._status.setAttribute(4, "failed");
                }
            }
        }
        this._dataStore.refresh(this._subject);
        return this._miner.statusDone(this._status);
    }

    public DataElement handleCreateVirtualFile(DataElement subject, DataElement status, String type) throws SystemMessageException {
        AbsoluteVirtualPath vpath = null;
        vpath = type.equals("universal.FilterObject") ? this._miner.getAbsoluteVirtualPath(subject.getValue()) : this._miner.getAbsoluteVirtualPath(subject);
        ISystemArchiveHandler handler = this._miner.getArchiveHandlerFor(vpath.getContainingArchiveString());
        if (handler == null) {
            status.setAttribute(4, "failed");
            return this._miner.statusDone(status);
        }
        handler.getVirtualFile(vpath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor);
        String[] stringArray = new String[4];
        stringArray[0] = "MODIFY-ARCHIVE";
        stringArray[1] = handler.getArchive().getAbsolutePath();
        String[] auditData = stringArray;
        UniversalServerUtilities.logAudit(auditData, this._dataStore);
        handler.createFile(vpath.getVirtualPart(), (ISystemOperationMonitor)this.systemOperationMonitor);
        status.setAttribute(4, "success");
        if (type.equals("universal.FilterObject")) {
            String fullName = subject.getValue();
            String name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
            String path = fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
            subject.setAttribute(2, name);
            subject.setAttribute(3, path);
            subject.setAttribute(0, "universal.VirtualFileObject");
        }
        this._dataStore.refresh(subject);
        return this._miner.statusDone(status);
    }
}

