/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IFileServiceCodePageConverter;

public class DefaultFileServiceCodePageConverter
implements IFileServiceCodePageConverter {
    public byte[] convertClientStringToRemoteBytes(String remotePath, String clientString, String remoteEncoding, IFileService fs) {
        try {
            return clientString.getBytes(remoteEncoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void convertFileFromRemoteEncoding(String remotePath, File file, String remoteEncoding, String localEncoding, IFileService fs) {
        FileInputStream inputStream = null;
        FileOutputStream outStream = null;
        try {
            try {
                Charset rmtCharset = Charset.forName(remoteEncoding);
                CharsetDecoder rmtDecoder = rmtCharset.newDecoder();
                inputStream = new FileInputStream(file);
                int fileLength = (int)file.length();
                BufferedInputStream bufInputStream = new BufferedInputStream(inputStream, fileLength);
                if (fileLength > 0) {
                    int MAX_READ = 10000;
                    if (fileLength <= MAX_READ) {
                        byte[] buffer = new byte[fileLength];
                        bufInputStream.read(buffer, 0, fileLength);
                        bufInputStream.close();
                        inputStream.close();
                        outStream = new FileOutputStream(file);
                        this.convertBuffer(buffer, rmtDecoder, fileLength, localEncoding, outStream);
                    } else {
                        int inOffset = 0;
                        File altFile = new File(String.valueOf(file.getAbsolutePath()) + "~");
                        outStream = new FileOutputStream(altFile);
                        while (inOffset < fileLength) {
                            int readSize = MAX_READ;
                            if (inOffset + MAX_READ > fileLength) {
                                readSize = fileLength - inOffset;
                            }
                            byte[] buffer = new byte[readSize];
                            inputStream.read(buffer, 0, readSize);
                            inOffset += readSize;
                            this.convertBuffer(buffer, rmtDecoder, readSize, localEncoding, outStream);
                        }
                        inputStream.close();
                        outStream.close();
                        if (!altFile.renameTo(file) && file.exists()) {
                            file.delete();
                            altFile.renameTo(file);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void convertBuffer(byte[] buffer, CharsetDecoder rmtDecoder, int readSize, String localEncoding, FileOutputStream outStream) throws Exception {
        ByteBuffer rmtBuf = ByteBuffer.wrap(buffer, 0, readSize);
        CharBuffer decodedBuf = null;
        decodedBuf = rmtDecoder.decode(rmtBuf);
        Charset charset = Charset.forName(localEncoding);
        CharsetEncoder encoder = charset.newEncoder();
        byte[] localBuffer = null;
        ByteBuffer lclBuf = encoder.encode(decodedBuf);
        localBuffer = lclBuf.array();
        int writeSize = lclBuf.limit();
        outStream.write(localBuffer, 0, writeSize);
    }

    public boolean isServerEncodingSupported(String remoteEncoding, IFileService fs) {
        return true;
    }

    public int getPriority(String remoteEString, IFileService fs) {
        return 1000;
    }
}

