/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.decorators.IProblemDecoratable;
import org.eclipse.jgit.annotations.NonNull;

public class StagingFolderEntry
implements IAdaptable,
IProblemDecoratable {
    private final IPath repoLocation;
    private final IPath repoRelativePath;
    private final String label;
    private final IContainer container;
    private StagingFolderEntry parent;
    private Object[] children;

    public StagingFolderEntry(IPath repoLocation, IPath repoRelativePath, String label) {
        this.repoLocation = repoLocation;
        this.repoRelativePath = repoRelativePath;
        this.label = label;
        this.container = ResourceUtil.getContainerForLocation((IPath)this.getLocation(), (boolean)false);
    }

    public IContainer getContainer() {
        return this.container;
    }

    @Override
    public int getProblemSeverity() {
        if (this.container == null) {
            return -1;
        }
        try {
            return this.container.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            return -1;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IResource.class || adapter == IContainer.class) {
            return adapter.cast(this.getContainer());
        }
        if (adapter == IPath.class) {
            return adapter.cast(this.getLocation());
        }
        return null;
    }

    public IPath getPath() {
        return this.repoRelativePath;
    }

    @NonNull
    public IPath getLocation() {
        return this.repoLocation.append(this.repoRelativePath);
    }

    public String getLabel() {
        return this.label;
    }

    public StagingFolderEntry getParent() {
        return this.parent;
    }

    public void setParent(StagingFolderEntry parent) {
        this.parent = parent;
    }

    public Object[] getChildren() {
        return this.children;
    }

    public void setChildren(Object[] children) {
        this.children = children;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StagingFolderEntry) {
            return ((StagingFolderEntry)obj).getLocation().equals((Object)this.getLocation());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    public String toString() {
        return "StagingFolderEntry[" + this.repoRelativePath + "]";
    }
}

