/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codelens;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.codelens.LSPCodeMining;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;

public class CodeLensProvider
extends AbstractCodeMiningProvider {
    private CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(@NonNull IDocument document) {
        URI docURI = LSPEclipseUtils.toUri(document);
        if (docURI != null) {
            CodeLensParams param = new CodeLensParams(LSPEclipseUtils.toTextDocumentIdentifier(docURI));
            LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(sc -> sc.getCodeLensProvider() != null);
            return executor.collectAll((w, ls) -> ls.getTextDocumentService().codeLens(param).thenApply(codeLenses -> LanguageServers.streamSafely(codeLenses).map(codeLens -> this.toCodeMining(document, (LanguageServerWrapper)w, (CodeLens)codeLens)).filter(Objects::nonNull))).thenApply(result -> result.stream().flatMap(s -> s).collect(Collectors.toList()));
        }
        return null;
    }

    private LSPCodeMining toCodeMining(IDocument document, LanguageServerWrapper languageServerWrapper, CodeLens codeLens) {
        if (codeLens == null) {
            return null;
        }
        try {
            return new LSPCodeMining(codeLens, document, languageServerWrapper, this);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
    }

    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        IDocument document = viewer.getDocument();
        return document != null ? this.provideCodeMinings(document) : null;
    }
}

