/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.grammar.BasicScopeAttributes;
import org.eclipse.tm4e.core.internal.grammar.Grammar;
import org.eclipse.tm4e.core.internal.grammar.ScopeStack;
import org.eclipse.tm4e.core.internal.grammar.tokenattrs.EncodedTokenAttributes;
import org.eclipse.tm4e.core.internal.theme.StyleAttributes;

public final class AttributedScopeStack {
    private static final Splitter BY_SPACE_SPLITTER = Splitter.on((char)' ');
    private final @Nullable AttributedScopeStack parent;
    private final ScopeStack scopePath;
    final int tokenAttributes;

    public static AttributedScopeStack createRoot(String scopeName, int tokenAttributes) {
        return new AttributedScopeStack(null, new ScopeStack(null, scopeName), tokenAttributes);
    }

    public static AttributedScopeStack createRootAndLookUpScopeName(String scopeName, int encodedTokenAttributes, Grammar grammar) {
        BasicScopeAttributes rawRootMetadata = grammar.getMetadataForScope(scopeName);
        ScopeStack scopePath = new ScopeStack(null, scopeName);
        StyleAttributes rootStyle = grammar.themeProvider.themeMatch(scopePath);
        int resolvedTokenAttributes = AttributedScopeStack.mergeAttributes(encodedTokenAttributes, rawRootMetadata, rootStyle);
        return new AttributedScopeStack(null, scopePath, resolvedTokenAttributes);
    }

    public String scopeName() {
        return this.scopePath.scopeName;
    }

    public AttributedScopeStack(@Nullable AttributedScopeStack parent, ScopeStack scopePath, int tokenAttributes) {
        this.parent = parent;
        this.scopePath = scopePath;
        this.tokenAttributes = tokenAttributes;
    }

    public boolean equals(AttributedScopeStack other) {
        return AttributedScopeStack._equals(this, other);
    }

    private static boolean _equals(@Nullable AttributedScopeStack a, @Nullable AttributedScopeStack b) {
        while (a != b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (!Objects.equals(a.scopeName(), b.scopeName()) || a.tokenAttributes != b.tokenAttributes) {
                return false;
            }
            a = a.parent;
            b = b.parent;
        }
        return true;
    }

    public static int mergeAttributes(int existingTokenAttributes, BasicScopeAttributes basicScopeAttributes, @Nullable StyleAttributes styleAttributes) {
        int fontStyle = -1;
        int foreground = 0;
        int background = 0;
        if (styleAttributes != null) {
            fontStyle = styleAttributes.fontStyle;
            foreground = styleAttributes.foregroundId;
            background = styleAttributes.backgroundId;
        }
        return EncodedTokenAttributes.set(existingTokenAttributes, basicScopeAttributes.languageId, basicScopeAttributes.tokenType, null, fontStyle, foreground, background);
    }

    AttributedScopeStack pushAttributed(@Nullable String scopePath, Grammar grammar) {
        if (scopePath == null) {
            return this;
        }
        if (scopePath.indexOf(32) == -1) {
            return this._pushAttributed(this, scopePath, grammar);
        }
        Iterable scopes = BY_SPACE_SPLITTER.split((CharSequence)scopePath);
        AttributedScopeStack result = this;
        for (String scope : scopes) {
            result = this._pushAttributed(result, scope, grammar);
        }
        return result;
    }

    private AttributedScopeStack _pushAttributed(AttributedScopeStack target, String scopeName, Grammar grammar) {
        BasicScopeAttributes rawMetadata = grammar.getMetadataForScope(scopeName);
        ScopeStack newPath = target.scopePath.push(scopeName);
        StyleAttributes scopeThemeMatchResult = grammar.themeProvider.themeMatch(newPath);
        int metadata = AttributedScopeStack.mergeAttributes(target.tokenAttributes, rawMetadata, scopeThemeMatchResult);
        return new AttributedScopeStack(target, newPath, metadata);
    }

    List<String> getScopeNames() {
        return this.scopePath.getSegments();
    }
}

