/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.theme.css.CSSConditionFactory;
import org.eclipse.tm4e.core.internal.theme.css.CSSDocumentHandler;
import org.eclipse.tm4e.core.internal.theme.css.CSSSelectorFactory;
import org.eclipse.tm4e.core.internal.theme.css.CSSStyle;
import org.eclipse.tm4e.core.internal.theme.css.ExtendedSelector;
import org.eclipse.tm4e.core.internal.theme.css.sac.SACParserFactory;
import org.eclipse.tm4e.core.theme.IStyle;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class CSSParser {
    private final CSSDocumentHandler handler = new CSSDocumentHandler();

    public CSSParser(InputStream source) throws Exception {
        this(CSSParser.toSource(source));
    }

    private static InputSource toSource(InputStream source) {
        InputSource in = new InputSource();
        in.setByteStream(source);
        return in;
    }

    public CSSParser(InputSource source) throws Exception {
        this(source, new SACParserFactory().makeParser());
    }

    public CSSParser(String source) throws Exception {
        this(new InputSource((Reader)new StringReader(source)));
    }

    public CSSParser(InputSource source, Parser parser) throws CSSException, IOException {
        parser.setDocumentHandler((DocumentHandler)this.handler);
        parser.setConditionFactory(CSSConditionFactory.INSTANCE);
        parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        parser.parseStyleSheet(source);
    }

    public @Nullable IStyle getBestStyle(String ... names) {
        int bestSpecificity = 0;
        IStyle bestStyle = null;
        for (IStyle style : this.handler.getList()) {
            SelectorList list = ((CSSStyle)style).getSelectorList();
            int i = 0;
            while (i < list.getLength()) {
                Selector selector = list.item(i);
                if (selector instanceof ExtendedSelector var9_9 && (nbMatch = s.nbMatch(names)) > 0 && nbMatch == s.nbClass() && (bestStyle == null || nbMatch >= bestSpecificity)) {
                    bestStyle = style;
                    bestSpecificity = nbMatch;
                }
                ++i;
            }
        }
        return bestStyle;
    }

    public List<IStyle> getStyles() {
        return this.handler.getList();
    }
}

