/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.util.Arrays;

class SegTokenPair {
    public char[] charArray;
    public int from;
    public int to;
    public double weight;

    public SegTokenPair(char[] idArray, int from, int to, double weight) {
        this.charArray = idArray;
        this.from = from;
        this.to = to;
        this.weight = weight;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (int i = 0; i < this.charArray.length; ++i) {
            result = 31 * result + this.charArray[i];
        }
        result = 31 * result + this.from;
        result = 31 * result + this.to;
        long temp = Double.doubleToLongBits(this.weight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegTokenPair other = (SegTokenPair)obj;
        if (!Arrays.equals(this.charArray, other.charArray)) {
            return false;
        }
        if (this.from != other.from) {
            return false;
        }
        if (this.to != other.to) {
            return false;
        }
        return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }
}

