/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient.win32;

import java.util.Map;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.auth.KerberosSchemeFactory;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.win.WindowsNTLMSchemeFactory;
import org.apache.hc.client5.http.impl.win.WindowsNegotiateSchemeFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientCustomizer;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SynchronizedCredentialsProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class WinClientBuilderCustomizer
implements HttpClientCustomizer {
    public static final String ID = "org.eclipse.epp.mpc.core.transport.http.win32";
    public static final String SERVICE_PRINCIPAL_NAME_ATTRIBUTE = "servicePrincipal";
    public static final String SERVICE_PRINCIPAL_NAME_PROPERTY = "org.eclipse.epp.mpc.core.transport.http.win32.servicePrincipal";
    private static Boolean winAuthAvailable;
    private String servicePrincipalName;

    public static boolean isWinAuthAvailable() {
        if (winAuthAvailable == null) {
            try {
                winAuthAvailable = true;
            }
            catch (Exception ignore) {
                winAuthAvailable = false;
            }
        }
        return winAuthAvailable;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public HttpClientBuilder customizeBuilder(HttpClientBuilder builder) {
        if (!WinClientBuilderCustomizer.isWinAuthAvailable()) {
            return builder;
        }
        HttpClientBuilder winBuilder = builder == null ? HttpClientBuilder.create() : builder;
        Registry<AuthSchemeFactory> authSchemeRegistry = this.createAuthSchemeRegistry();
        return winBuilder.setDefaultAuthSchemeRegistry(authSchemeRegistry);
    }

    private Registry<AuthSchemeFactory> createAuthSchemeRegistry() {
        Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).register("NTLM", (Object)new WindowsNTLMSchemeFactory(this.servicePrincipalName)).register("Negotiate", (Object)new WindowsNegotiateSchemeFactory(this.servicePrincipalName)).register("Kerberos", (Object)KerberosSchemeFactory.DEFAULT).build();
        return authSchemeRegistry;
    }

    public CredentialsStore customizeCredentialsProvider(CredentialsStore credentialsProvider) {
        if (credentialsProvider == null || !WinClientBuilderCustomizer.isWinAuthAvailable()) {
            return credentialsProvider;
        }
        SynchronizedCredentialsProvider winCredentialsStore = new SynchronizedCredentialsProvider(credentialsProvider);
        return winCredentialsStore;
    }

    public synchronized void activate(BundleContext context, Map<?, ?> properties) {
        this.servicePrincipalName = this.getServicePrincipalName(properties);
    }

    private String getServicePrincipalName(Map<?, ?> properties) {
        Object servicePrincipalValue = properties.get(SERVICE_PRINCIPAL_NAME_ATTRIBUTE);
        if (servicePrincipalValue != null) {
            return servicePrincipalValue.toString();
        }
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            return bundle.getBundleContext().getProperty(SERVICE_PRINCIPAL_NAME_PROPERTY);
        }
        return System.getProperty(SERVICE_PRINCIPAL_NAME_PROPERTY);
    }
}

