/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;

public class GitFlowConfig {
    public static final String MASTER_KEY = "master";
    public static final String DEVELOP_KEY = "develop";
    public static final String HOTFIX_KEY = "hotfix";
    public static final String RELEASE_KEY = "release";
    public static final String FEATURE_KEY = "feature";
    public static final String VERSION_TAG_KEY = "versiontag";
    public static final String USER_SECTION = "user";
    public static final String BRANCH_SECTION = "branch";
    public static final String PREFIX_SECTION = "prefix";
    public static final String GITFLOW_SECTION = "gitflow";
    public static final String REMOTE_KEY = "remote";
    public static final String MERGE_KEY = "merge";
    public static final String FEATURE_START_FETCH_KEY = "fetch";
    public static final String FEATURE_START_SUBSECTION = "feature.start";
    private StoredConfig config;

    public GitFlowConfig(@NonNull Repository repository) {
        this(repository.getConfig());
    }

    public GitFlowConfig(@NonNull StoredConfig config) {
        this.config = config;
    }

    public boolean isInitialized() {
        Set sections = this.config.getSections();
        return sections.contains(GITFLOW_SECTION);
    }

    public String getUser() {
        String userName = this.config.getString(USER_SECTION, null, "name");
        String email = this.config.getString(USER_SECTION, null, "email");
        return String.format("%s <%s>", userName, email);
    }

    public String getFeaturePrefix() {
        return this.getPrefix(FEATURE_KEY, "feature/");
    }

    public String getReleasePrefix() {
        return this.getPrefix(RELEASE_KEY, "release/");
    }

    public String getHotfixPrefix() {
        return this.getPrefix(HOTFIX_KEY, "hotfix/");
    }

    public String getVersionTagPrefix() {
        return this.getPrefix(VERSION_TAG_KEY, "");
    }

    public String getDevelop() {
        return this.getBranch(DEVELOP_KEY, DEVELOP_KEY);
    }

    public String getDevelopFull() {
        return "refs/heads/" + this.getDevelop();
    }

    public String getMaster() {
        return this.getBranch(MASTER_KEY, MASTER_KEY);
    }

    public String getPrefix(String prefixName, String defaultPrefix) {
        String result = this.config.getString(GITFLOW_SECTION, PREFIX_SECTION, prefixName);
        return result == null ? defaultPrefix : result;
    }

    public String getBranch(String branch, String defaultBranch) {
        String result = this.config.getString(GITFLOW_SECTION, BRANCH_SECTION, branch);
        return result == null ? defaultBranch : result;
    }

    public void setPrefix(String prefixName, String value) {
        this.config.setString(GITFLOW_SECTION, PREFIX_SECTION, prefixName, value);
    }

    public void setBranch(String branchName, String value) {
        this.config.setString(GITFLOW_SECTION, BRANCH_SECTION, branchName, value);
    }

    public String getFullFeatureBranchName(String featureName) {
        return "refs/heads/" + this.getFeatureBranchName(featureName);
    }

    public String getFeatureBranchName(String featureName) {
        return String.valueOf(this.getFeaturePrefix()) + featureName;
    }

    public String getHotfixBranchName(String hotfixName) {
        return String.valueOf(this.getHotfixPrefix()) + hotfixName;
    }

    public String getFullHotfixBranchName(String hotfixName) {
        return "refs/heads/" + this.getHotfixBranchName(hotfixName);
    }

    public String getFullReleaseBranchName(String releaseName) {
        return "refs/heads/" + this.getReleaseBranchName(releaseName);
    }

    public String getReleaseBranchName(String releaseName) {
        return String.valueOf(this.getReleasePrefix()) + releaseName;
    }

    public RemoteConfig getDefaultRemoteConfig() {
        RemoteConfig result;
        try {
            result = new RemoteConfig((Config)this.config, "origin");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public boolean hasDefaultRemote() {
        return !this.getDefaultRemoteConfig().getURIs().isEmpty();
    }

    public void setRemote(String featureName, String value) throws IOException {
        this.setBranchValue(featureName, value, REMOTE_KEY);
    }

    public void setUpstreamBranchName(String featureName, String value) throws IOException {
        this.setBranchValue(featureName, value, MERGE_KEY);
    }

    public String getUpstreamBranchName(String featureName) {
        return this.config.getString(BRANCH_SECTION, this.getFeatureBranchName(featureName), MERGE_KEY);
    }

    private void setBranchValue(String featureName, String value, String mergeKey) throws IOException {
        this.config.setString(BRANCH_SECTION, featureName, mergeKey, value);
        this.config.save();
    }

    public String getRemoteName(String featureName) {
        return this.config.getString(BRANCH_SECTION, this.getFeatureBranchName(featureName), REMOTE_KEY);
    }

    public void setFetchOnFeatureStart(boolean isFetchOnFeatureStart) throws IOException {
        this.config.setBoolean(GITFLOW_SECTION, FEATURE_START_SUBSECTION, FEATURE_START_FETCH_KEY, isFetchOnFeatureStart);
        this.config.save();
    }

    public boolean isFetchOnFeatureStart() {
        return this.config.getBoolean(GITFLOW_SECTION, FEATURE_START_SUBSECTION, FEATURE_START_FETCH_KEY, false);
    }
}

