/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;
import org.eclipse.wtp.releng.tools.component.ui.internal.WorkspaceFileLocation;
import org.eclipse.wtp.releng.tools.component.ui.internal.editor.APIPage;
import org.eclipse.wtp.releng.tools.component.ui.internal.editor.ComponentPage;

public class ComponentXMLEditor
extends FormEditor {
    private IFile file;
    private ComponentXML compXML;
    private boolean dirty = false;

    public void addPages() {
        try {
            ComponentManager manager = ComponentManager.getManager();
            this.addPage((IFormPage)new ComponentPage(this, "org.eclipse.wtp.releng.tools.component.ui.internal.editor.ComponentPage", manager.getMessage("PAGE_COMPONENT")));
            this.addPage((IFormPage)new APIPage(this, "org.eclipse.wtp.releng.tools.component.ui.internal.editor.APIPage", manager.getMessage("PAGE_API")));
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ComponentManager manager = ComponentManager.getManager();
        if (input instanceof FileEditorInput) {
            this.file = ((FileEditorInput)input).getFile();
            this.compXML = new ComponentXML();
            this.compXML.setLocation((ILocation)new WorkspaceFileLocation(this.file));
            try {
                this.compXML.load();
            }
            catch (Throwable throwable) {
                throw new PartInitException(manager.getMessage("ERROR_MSG_FAIL_TO_LOAD_COMPONENT", new String[]{this.file.getFullPath().toString()}));
            }
        } else {
            throw new PartInitException(manager.getMessage("ERROR_MSG_INVALID_COMPONENT_XML"));
        }
    }

    public ComponentXML getComponentXML() {
        return this.compXML;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            String content = this.compXML.toString();
            this.file.setContents((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), true, true, (IProgressMonitor)new NullProgressMonitor());
            this.setDirty(false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

