/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;

public class XSInteger
extends XSDecimal {
    private int _value;

    public XSInteger() {
        this(0);
    }

    public XSInteger(int x) {
        super(x);
        this._value = x;
    }

    public String string_type() {
        return "xs:integer";
    }

    public String type_name() {
        return "integer";
    }

    public String string_value() {
        return "" + this._value;
    }

    public boolean zero() {
        return this._value == 0;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        try {
            Integer i = new Integer(aat.string_value());
            rs.add(new XSInteger(i));
            return rs;
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    public int int_value() {
        return this._value;
    }

    public void set_int(int x) {
        this._value = x;
        this.set_double(x);
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        AnyType at = this.get_single_arg(arg);
        if (!(at instanceof XSInteger)) {
            DynamicError.throw_type_error();
        }
        XSInteger val = (XSInteger)at;
        return ResultSequenceFactory.create_new(new XSInteger(this.int_value() + val.int_value()));
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        XSInteger val = (XSInteger)XSInteger.get_single_type(arg, XSInteger.class);
        return ResultSequenceFactory.create_new(new XSInteger(this.int_value() - val.int_value()));
    }

    public ResultSequence times(ResultSequence arg) throws DynamicError {
        XSInteger val = (XSInteger)XSInteger.get_single_type(arg, XSInteger.class);
        return ResultSequenceFactory.create_new(new XSInteger(this.int_value() * val.int_value()));
    }

    public ResultSequence mod(ResultSequence arg) throws DynamicError {
        XSInteger val = (XSInteger)XSInteger.get_single_type(arg, XSInteger.class);
        return ResultSequenceFactory.create_new(new XSInteger(this.int_value() % val.int_value()));
    }

    public ResultSequence unary_minus() {
        return ResultSequenceFactory.create_new(new XSInteger(-1 * this.int_value()));
    }

    public NumericType abs() {
        return new XSInteger(Math.abs(this.int_value()));
    }
}

