/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnNormalizeSpace
extends Function {
    private static Collection _expected_args = null;

    public FnNormalizeSpace() {
        super(new QName("normalize-space"), 1);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnNormalizeSpace.normalize_space(args);
    }

    public static ResultSequence normalize_space(Collection args) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnNormalizeSpace.expected_args());
        ResultSequence arg1 = (ResultSequence)cargs.iterator().next();
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg1.empty()) {
            rs.add(new XSString(""));
            return rs;
        }
        String str = ((XSString)arg1.first()).value();
        rs.add(new XSString(FnNormalizeSpace.normalize(str)));
        return rs;
    }

    public static String normalize(String str) {
        StringBuffer sb = new StringBuffer();
        int state = 0;
        int i = 0;
        while (i < str.length()) {
            char x = str.charAt(i);
            boolean white = FnNormalizeSpace.is_whitespace(x);
            switch (state) {
                case 0: {
                    if (white) break;
                    sb.append(x);
                    state = 1;
                    break;
                }
                case 1: {
                    if (white) {
                        state = 3;
                        sb.append(' ');
                        break;
                    }
                    sb.append(x);
                    break;
                }
                case 3: {
                    if (white) break;
                    state = 1;
                    sb.append(x);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ++i;
        }
        String result = sb.toString();
        int len = result.length();
        if (len == 0) {
            return result;
        }
        if (result.charAt(len - 1) == ' ') {
            return result.substring(0, len - 1);
        }
        return result;
    }

    public static boolean is_whitespace(char x) {
        switch (x) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSString(), 3));
        }
        return _expected_args;
    }
}

