/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DocumentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ElementTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ItemType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.KindTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SequenceType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;

public class SeqType {
    public static final int OCC_NONE = 0;
    public static final int OCC_STAR = 1;
    public static final int OCC_PLUS = 2;
    public static final int OCC_QMARK = 3;
    private AnyType _type;
    private int _occ;
    private Class _type_class;

    public SeqType(AnyType t, int occ) {
        this._type = t;
        this._occ = occ;
        this._type_class = t != null ? t.getClass() : null;
    }

    public SeqType(int occ) {
        this(null, occ);
        this._type_class = NodeType.class;
    }

    public SeqType(SequenceType st, StaticContext sc) {
        this._type = null;
        this._type_class = null;
        switch (st.occurrence()) {
            case 0: {
                this._occ = 0;
                return;
            }
            case 1: {
                this._occ = 0;
                break;
            }
            case 2: {
                this._occ = 3;
                break;
            }
            case 3: {
                this._occ = 1;
                break;
            }
            case 4: {
                this._occ = 2;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        ItemType item = st.item_type();
        KindTest ktest = null;
        switch (item.type()) {
            case 0: {
                this._type_class = AnyType.class;
                return;
            }
            case 1: {
                AnyAtomicType aat = sc.make_atomic(item.qname());
                assert (aat != null);
                this._type = aat;
                this._type_class = this._type.getClass();
                return;
            }
            case 2: {
                ktest = item.kind_test();
            }
        }
        if (ktest == null) {
            return;
        }
        if (ktest instanceof DocumentTest) {
            this._type_class = DocType.class;
        } else if (ktest instanceof ElementTest) {
            this._type_class = ElementType.class;
        } else assert (false);
    }

    public SeqType(AnyType t) {
        this(t, 0);
    }

    public int occurence() {
        return this._occ;
    }

    public AnyType type() {
        return this._type;
    }

    public ResultSequence match(ResultSequence args) throws DynamicError {
        int arg_count = 0;
        ListIterator i = args.iterator();
        while (i.hasNext()) {
            AnyType arg = (AnyType)i.next();
            if (!this._type_class.isInstance(arg)) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            ++arg_count;
        }
        switch (this.occurence()) {
            case 0: {
                if (arg_count == true) break;
                throw new DynamicError(TypeError.invalid_type(null));
            }
            case 2: {
                if (arg_count != 0) break;
                throw new DynamicError(TypeError.invalid_type(null));
            }
            case 1: {
                break;
            }
            case 3: {
                if (arg_count <= true) break;
                throw new DynamicError(TypeError.invalid_type(null));
            }
            default: {
                assert (false);
                break;
            }
        }
        return args;
    }
}

