/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSModel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.xpath2.processor.DOMLoaderException;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.JFlexCupParser;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.StaticNameResolver;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.XercesLoader;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.function.FnFunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.function.XSCtrLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.function.XDTCtrLibrary;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class AbstractPsychoPathTest
extends TestCase {
    protected Document domDoc = null;
    protected Bundle bundle = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.bundle = Platform.getBundle((String)"org.eclipse.wst.xml.xpath2.processor.tests");
    }

    protected void loadDOMDocument(URL fileURL) throws IOException, DOMLoaderException {
        InputStream is = fileURL.openStream();
        XercesLoader domloader = new XercesLoader();
        domloader.set_validating(false);
        this.domDoc = domloader.load(is);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.domDoc = null;
    }

    protected XSModel getGrammar() {
        ElementPSVI rootPSVI = (ElementPSVI)this.domDoc.getDocumentElement();
        XSModel schema = rootPSVI.getSchemaInformation();
        return schema;
    }

    protected DynamicContext setupDynamicContext(XSModel schema) {
        DefaultDynamicContext dc = new DefaultDynamicContext(schema, this.domDoc);
        dc.add_namespace("xsd", "http://www.w3.org/2001/XMLSchema");
        dc.add_namespace("xdt", "http://www.w3.org/2004/10/xpath-datatypes");
        dc.add_function_library((FunctionLibrary)new FnFunctionLibrary());
        dc.add_function_library((FunctionLibrary)new XSCtrLibrary());
        dc.add_function_library((FunctionLibrary)new XDTCtrLibrary());
        return dc;
    }

    protected XPath compileXPath(DynamicContext dc, String xpath) throws XPathParserException, StaticError {
        JFlexCupParser xpp = new JFlexCupParser();
        XPath path = xpp.parse(xpath);
        StaticNameResolver name_check = new StaticNameResolver((StaticContext)dc);
        name_check.check((XPathNode)path);
        return path;
    }
}

