/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.provisional;

import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.provisional.UIDecorator;

public class ManagedUIDecorator
extends UIDecorator {
    private static final String[] serverStateUnmanaged = new String[]{"", Messages.viewStatusStarting4, Messages.viewStatusStarted2, Messages.viewStatusStopping4, Messages.viewStatusStopped2};
    private static final String[] startingText = new String[]{Messages.viewStatusStarting1, Messages.viewStatusStarting2, Messages.viewStatusStarting3};
    private static final String[] stoppingText = new String[]{Messages.viewStatusStopping1, Messages.viewStatusStopping2, Messages.viewStatusStopping3};
    private static Image[] startingImages;
    private static Image[] stoppingImages;

    public void init() {
        this.loadImages();
    }

    public void loadImages() {
        startingImages = new Image[]{ImageResource.getImage("stateStarting1"), ImageResource.getImage("stateStarting2"), ImageResource.getImage("stateStarting3")};
        stoppingImages = new Image[]{ImageResource.getImage("stateStopping1"), ImageResource.getImage("stateStopping2"), ImageResource.getImage("stateStopping2")};
    }

    public String getStateLabel(int state, String mode, int count) {
        if (state == 0) {
            return "";
        }
        if (state == 1) {
            return startingText[count];
        }
        if (state == 3) {
            return stoppingText[count];
        }
        if (state == 2) {
            if ("debug".equals(mode)) {
                return Messages.viewStatusStartedDebug;
            }
            if ("profile".equals(mode)) {
                return Messages.viewStatusStartedProfile;
            }
            return Messages.viewStatusStarted;
        }
        if (state == 4) {
            return Messages.viewStatusStopped;
        }
        return serverStateUnmanaged[state];
    }

    public Image getStateImage(int state, String mode, int count) {
        this.init();
        if (state == 0) {
            return null;
        }
        if (state == 1) {
            return startingImages[count];
        }
        if (state == 3) {
            return stoppingImages[count];
        }
        if (state == 4) {
            return ImageResource.getImage("stateStopped");
        }
        if ("debug".equals(mode)) {
            return ImageResource.getImage("stateStartedDebug");
        }
        if ("profile".equals(mode)) {
            return ImageResource.getImage("stateStartedProfile");
        }
        return ImageResource.getImage("stateStarted");
    }

    public String getModuleName() {
        return "module";
    }

    public boolean canRestart() {
        return true;
    }
}

