/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class SwitchTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public SwitchTest(String name) {
        super(name);
    }

    public static Test suite() {
        return SwitchTest.buildAllCompliancesTestSuite(SwitchTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static void main(String args[]) {\n    foo();\n  }\n  public static void foo() {\n    try {\n      switch(0) {\n      case 0 :\n      case 1 - (1 << 31) :\n      case (1 << 30) :\n      }\n    } catch (OutOfMemoryError e) {\n    }\n  }\n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  int k;\n  public void foo() {\n    int c;\n    switch (k) {\n      default :\n        c = 2;\n        break;\n      case 2 :\n        c = 3;\n        break;\n    }\n  }\n}\n"});
    }

    public void test003() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  int i = 0;\n  void foo() {\n    switch (i) {\n      case 1 :\n        {\n          int j;\n          break;\n        }\n    }\n  }\n}\n"});
    }

    public void test004() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static int foo() {\n    int i = 0, j;\n    switch (i) {\n      default :\n        int k = 2;\n        j = k;\n    }\n    if (j != -2) {\n      return 1;\n    }\n    return 0;\n  }\n}\n"});
    }

    public void test005() {
        this.runConformTest(new String[]{"p/BugJavaCase.java", "package p;\nclass BugJavaCase {\n  public static final int BC_ZERO_ARG = 1;\n  public void test01(int i) {\n    switch (i) {\n      case BC_ZERO_ARG :\n        System.out.println(\"i = \" + i);\n        break;\n    }\n  }\n}\n"});
    }

    public void test006() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static void main(String args[]) {\n    foo(); \n  } \n \n  public static void foo() { \n    char x = 5;\n    final short b = 5;\n    int a;\n    \n    switch (x) {\n      case b:        // compile time error\n        a = 0;\n        break; \n      default:\n        a=1;\n    }\n    \n  }\n}\n"});
    }

    public void test007() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nclass X {\n  void v() {\n    switch (1) {\n      case (int) (1.0 / 0.0) :\n        break;\n      case (int) (2.0 / 0.0) :\n        break;\n    }\n  }\n}"}, "----------\n1. ERROR in p\\X.java (at line 5)\n\tcase (int) (1.0 / 0.0) :\n\t^^^^^^^^^^^^^^^^^^^^^^\nDuplicate case\n----------\n2. ERROR in p\\X.java (at line 7)\n\tcase (int) (2.0 / 0.0) :\n\t^^^^^^^^^^^^^^^^^^^^^^\nDuplicate case\n----------\n");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tswitch(args.length){\n\t\t}\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String argv[]) {\n        switch (81391861) {\n        case (81391861) :\n        \tSystem.out.println(\"SUCCESS\");\n            break;\n        default:\n        \tSystem.out.println(\"FAILED\");\n        }\n    }\n}\n"}, "SUCCESS");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tvoid foo(){\n\t\tswitch(this){\n\t\t\tcase 0 : \n\t\t\t\tZork z;\n\t\t}\n\t}\n\t\n\tvoid bar(){\n\t\tswitch(x){\n\t\t\tcase 0 : \n\t\t\t\tZork z;\n\t\t}\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tswitch(this){\n\t       ^^^^\nCannot switch on a value of type X. Only int values or enum constants are permitted\n----------\n2. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 11)\n\tswitch(x){\n\t       ^\nx cannot be resolved\n----------\n4. ERROR in X.java (at line 13)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test011() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String args[]) {\n\t\tswitch (args.length) {\n\t\t\tcase 1 :\n\t\t\t\tSystem.out.println();\n\t\t\tcase 3 :\n\t\t\t\tbreak;\n\t\t\tdefault :\n\t\t}\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.SwitchTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

