/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTest;

public class JavadocTestForClass
extends JavadocTest {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        return JavadocTestForClass.buildAllCompliancesTestSuite(JavadocTestForClass.javadocTestClass());
    }

    public JavadocTestForClass(String name) {
        super(name);
    }

    public static Class javadocTestClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTestForClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "error");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", "error");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.rawTypeReference", "ignore");
        return options;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "\t/**\n\t * Valid class javadoc\n\t * @author ffr\n\t */\npublic class X {\n\tpublic void foo() {\n\t}\n}\n"});
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * Invalid class javadoc\n\t * @param x Invalid tag\n\t */\npublic class X {\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @param x Invalid tag\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * Invalid class javadoc\n\t * @throws NullPointerException Invalid tag\n\t */\npublic class X {\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @throws NullPointerException Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * Invalid class javadoc\n\t * @exception NullPointerException Invalid tag\n\t */\npublic class X {\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @exception NullPointerException Invalid tag\n\t   ^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * Invalid class javadoc\n\t * @return Invalid tag\n\t */\npublic class X {\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @return Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * Invalid class javadoc\n\t * @exception NullPointerException Invalid tag\n\t * @throws NullPointerException Invalid tag\n\t * @return Invalid tag\n\t * @param x Invalid tag\n\t */\npublic class X {\n\tpublic void foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t* @exception NullPointerException Invalid tag\n\t   ^^^^^^^^^\nJavadoc: Unexpected tag\n----------\n2. ERROR in X.java (at line 4)\n\t* @throws NullPointerException Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n3. ERROR in X.java (at line 5)\n\t* @return Invalid tag\n\t   ^^^^^^\nJavadoc: Unexpected tag\n----------\n4. ERROR in X.java (at line 6)\n\t* @param x Invalid tag\n\t   ^^^^^\nJavadoc: Unexpected tag\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "\t/**\n\t * Valid class javadoc\n\t * @author ffr\n\t */\npublic class X {\n\tpublic void foo() {}\n\t/**\n\t * Invalid javadoc comment\n\t */\n}\n"});
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void foo() {}\n\t/**\n\t * Invalid javadoc comment\n\t */\n}\n"});
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t/**\n\t * Invalid javadoc comment\n\t */\n}\n"});
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * Invalid string references \n\t *\n\t * @see \"\n\t * @see \"unterminated string\n\t * @see \"invalid string\"\"\n\t * @see \"invalid\" no text allowed after the string\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see \"\n\t       ^\nJavadoc: Invalid reference\n----------\n2. ERROR in X.java (at line 5)\n\t* @see \"unterminated string\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: Invalid reference\n----------\n3. ERROR in X.java (at line 6)\n\t* @see \"invalid string\"\"\n\t                       ^\nJavadoc: Unexpected text\n----------\n4. ERROR in X.java (at line 7)\n\t* @see \"invalid\" no text allowed after the string\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n");
    }

    public void test011() {
        this.runConformTest(new String[]{"X.java", "\t/**\n\t * Valid string references \n\t *\n\t * @see \"Valid normal string\"\n\t * @see \"Valid \\\"string containing\\\" \\\"double-quote\\\"\"\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * Invalid URL link references \n\t *\n\t * @see <a href=\n\t * @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see <a href=\n\t       ^^^^^^^^\nJavadoc: Malformed link reference\n----------\n2. ERROR in X.java (at line 5)\n\t* @see <a href=\"invalid\">invalid</a> no text allowed after the href\n\t                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: Unexpected text\n----------\n");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "\t/**\n\t * Valid URL link references \n\t *\n\t * @see <a href=\"http://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/javadoc.html\">Valid URL link reference</a>\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test020() {
        this.runConformReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Valid local classes references \n\t *\n\t * @see Visibility Valid ref: local class \n\t * @see Visibility.VcPublic Valid ref: visible inner class of local class \n\t * @see Visibility.AvcPublic Valid ref: visible inherited inner class of local class \n\t * @see test.Visibility Valid ref: local class \n\t * @see test.Visibility.VcPublic Valid ref: visible inner class of local class \n\t * @see test.Visibility.AvcPublic Valid ref: visible inherited inner class of local class \n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test021() {
        this.runNegativeReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Invalid local classes references \n\t *\n\t * @see Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t * @see Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t * @see test.Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t * @see test.Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t * @see Unknown Invalid ref: unknown class \n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 5)\n\t* @see Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n2. ERROR in test\\X.java (at line 6)\n\t* @see Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.AvcPrivate is not visible\n----------\n3. ERROR in test\\X.java (at line 7)\n\t* @see test.Visibility.VcPrivate Invalid ref: non visible inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.Visibility.VcPrivate is not visible\n----------\n4. ERROR in test\\X.java (at line 8)\n\t* @see test.Visibility.AvcPrivate Invalid ref: non visible inherited inner class of local class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.Visibility.AvcPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 9)\n\t* @see Unknown Invalid ref: unknown class \n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n");
    }

    public void test022() {
        this.runConformReferenceTest(new String[]{"test/X.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Valid external classes references \n\t *\n\t * @see VisibilityPublic Valid ref: visible class through import => no warning on import\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test023() {
        this.runNegativeReferenceTest(new String[]{"test/X.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Invalid external classes references \n\t *\n\t * @see VisibilityPackage Invalid ref: non visible class \n\t * @see VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see VisibilityPackage Invalid ref: non visible class \n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPublic.VpPrivate Invalid ref: non visible inner class in visible class \n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n");
    }

    public void test024() {
        this.runConformReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Valid external classes references \n\t *\n\t * @see test.copy.VisibilityPublic Valid ref: visible class through import => no warning on import\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test030() {
        this.runConformReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Valid local class field references\n\t *\n\t * @see #x Valid ref: accessible field\n\t * @see Visibility#vf_public Valid ref: visible field\n\t * @see Visibility.VcPublic#vf_public Valid ref: visible field in visible inner class\n\t */\npublic class X {\n\tint x;\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test031() {
        this.runNegativeReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Invalid local class field references\n\t *\n\t * @see #x Invalid ref: non existent field\n\t * @see Visibility#unknown Invalid ref: non existent field\n\t * @see Visibility#vf_private Invalid ref: non visible field\n\t * @see Visibility.VcPrivate#unknown Invalid ref: non visible inner class (non existent field)\n\t * @see Visibility.VcPublic#unknown Invalid ref: non existent field in visible inner class\n\t * @see Visibility.VcPublic#vf_private Invalid ref: non visible field in visible inner class\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 5)\n\t* @see #x Invalid ref: non existent field\n\t        ^\nJavadoc: x cannot be resolved or is not a field\n----------\n2. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#unknown Invalid ref: non existent field\n\t                  ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n3. ERROR in test\\X.java (at line 7)\n\t* @see Visibility#vf_private Invalid ref: non visible field\n\t                  ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n4. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.VcPrivate#unknown Invalid ref: non visible inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 9)\n\t* @see Visibility.VcPublic#unknown Invalid ref: non existent field in visible inner class\n\t                           ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n6. ERROR in test\\X.java (at line 10)\n\t* @see Visibility.VcPublic#vf_private Invalid ref: non visible field in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n");
    }

    public void test032() {
        this.runConformReferenceTest(new String[]{"test/X.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Valid other package visible class fields references\n\t *\n\t * @see VisibilityPublic#vf_public Valid ref to not visible field of other package class\n\t * @see VisibilityPublic.VpPublic#vf_public Valid ref to not visible field of other package public inner class\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test033() {
        this.runNegativeReferenceTest(new String[]{"test/X.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Invalid other package non visible class fields references\n\t *\n\t * @see VisibilityPackage#unknown Invalid ref to non existent field of other package non visible class\n\t * @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t * @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t * @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t * @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t * @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see VisibilityPackage#unknown Invalid ref to non existent field of other package non visible class\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see VisibilityPublic#unknown Invalid ref to non existent field of other package class\n\t                        ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n3. ERROR in test\\X.java (at line 8)\n\t* @see VisibilityPublic#vf_private Invalid ref to not visible field of other package class\n\t                        ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n4. ERROR in test\\X.java (at line 9)\n\t* @see VisibilityPublic.VpPrivate#unknown Invalid ref to a non visible other package private inner class (non existent field)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPublic.VpPrivate is not visible\n----------\n5. ERROR in test\\X.java (at line 10)\n\t* @see VisibilityPublic.VpPublic#unknown Invalid ref to non existent field of other package public inner class\n\t                                 ^^^^^^^\nJavadoc: unknown cannot be resolved or is not a field\n----------\n6. ERROR in test\\X.java (at line 11)\n\t* @see VisibilityPublic.VpPublic#vf_private Invalid ref to not visible field of other package public inner class\n\t                                 ^^^^^^^^^^\nJavadoc: The field vf_private is not visible\n----------\n");
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "import java.util.Vector;\n\t/**\n\t * Valid local methods references with array\n\t * \n\t * @see #smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) Valid local method reference\n\t * @see #smr_foo(char[], int[][], String[][][], Vector[][][][]) Valid local method reference\n\t * @see #smr_foo(char[],int[][],java.lang.String[][][],java.util.Vector[][][][]) Valid local method reference\n\t */  \npublic class X {\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) {\n\t}\n}\n"});
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Vector;\n\t/**\n\t * Invalid local methods references with array (non applicable arrays)\n\t * \n\t * @see #smr_foo(char[] , int[][], String[][][], Vector[][][]) Invalid ref: invalid arguments declaration\n\t */  \npublic class X {\n\tpublic void smr_foo(char[] array, int[][] matrix, String[][][] dim, Vector[][][][] extra) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t* @see #smr_foo(char[] , int[][], String[][][], Vector[][][]) Invalid ref: invalid arguments declaration\n\t        ^^^^^^^\nJavadoc: The method smr_foo(char[], int[][], String[][][], Vector[][][][]) in the type X is not applicable for the arguments (char[], int[][], String[][][], Vector[][][])\n----------\n");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "import java.util.Vector;\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see #smr_foo() Valid local method reference\n\t * @see #smr_foo(boolean a1,int a2,byte a3,short a4,char a5,long a6,float a7,double a8) Valid local method reference\n\t * @see #smr_foo(java.lang.String, java.lang.String, int) Valid local method reference   \n\t * @see #smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \npublic class X {\n\tpublic void s_foo() {\n\t}\n\n\t// Empty methods definition for reference\n\tpublic void smr_foo() {\n\t}\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"});
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #unknown() Invalid ref: undefined local method reference\n\t */  \npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see #unknown() Invalid ref: undefined local method reference\n\t        ^^^^^^^\nJavadoc: The method unknown() is undefined for the type X\n----------\n");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "\t/**\n\t * Invalid local methods references\n\t * \n\t * @see #smr_foo(float, long, char, short, byte, int, boolean) Invalid ref: local method not applicable\n\t * @see #smr_foo(String, String, int, String) Invalid ref: local method not applicable\n\t * @see #smr_foo(boolean) Invalid ref: local method not applicable\n\t * @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t */  \npublic class X {\n\t// Empty methods definition for reference\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t* @see #smr_foo(float, long, char, short, byte, int, boolean) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (float, long, char, short, byte, int, boolean)\n----------\n2. ERROR in X.java (at line 5)\n\t* @see #smr_foo(String, String, int, String) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(String, String, int) in the type X is not applicable for the arguments (String, String, int, String)\n----------\n3. ERROR in X.java (at line 6)\n\t* @see #smr_foo(boolean) Invalid ref: local method not applicable\n\t        ^^^^^^^\nJavadoc: The method smr_foo(boolean, int, byte, short, char, long, float, double) in the type X is not applicable for the arguments (boolean)\n----------\n4. ERROR in X.java (at line 7)\n\t* @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t                ^^^^^^^^^\nJavadoc: Hashtable cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 7)\n\t* @see #smr_foo(Hashtable a, Vector b, boolean c) Invalid reference: unresolved argument type\n\t                             ^^^^^^\nJavadoc: Vector cannot be resolved to a type\n----------\n");
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "import java.util.Vector;\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see X#smr_foo() Valid local method reference\n\t * @see X#smr_foo(boolean,int,byte,short,char,long,float,double) Valid local method reference\n\t * @see X#smr_foo(String x, java.lang.String y, int z) Valid local method reference   \n\t * @see X#smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \npublic class X {\n\tpublic void smr_foo() {\n\t}\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"});
    }

    public void test046() {
        this.runConformTest(new String[]{"test/deep/qualified/name/p/X.java", "package test.deep.qualified.name.p;\nimport java.util.Vector;\n\t/**\n\t * Valid local methods references\n\t * \n\t * @see test.deep.qualified.name.p.X#smr_foo() Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(boolean,int,byte,short,char,long,float,double) Valid local method reference\n\t * @see test.deep.qualified.name.p.X#smr_foo(String x, java.lang.String y, int z) Valid local method reference   \n\t * @see test.deep.qualified.name.p.X#smr_foo(java.util.Hashtable a, Vector b, boolean c) Valid local method reference\n\t */  \npublic class X {\n\tpublic void smr_foo() {\n\t}\n\tpublic void smr_foo(boolean b, int i, byte y, short s, char c, long l, float f, double d) {\n\t}\n\tpublic void smr_foo(String str1, java.lang.String str2, int i) {\n\t}\n\tpublic void smr_foo(java.util.Hashtable h, java.util.Vector v, boolean b) {\n\t}\n}\n"});
    }

    public void test047() {
        this.runConformReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Valid package class methods references\n\t * \n\t * @see Visibility#vm_public() Valid ref: visible method\n\t * @see Visibility.VcPublic#vm_public() Valid ref: visible method in visible inner class\n\t * @see test.Visibility#vm_public() Valid ref: visible method\n\t * @see test.Visibility.VcPublic#vm_public() Valid ref: visible method in visible inner class\n\t */  \npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test048() {
        this.runNegativeReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Invalid package class methods references (non-existence)\n\t * \n\t * @see Visibility#unknown() Invalid ref: non-existent method\n\t * @see Visibility.VcPublic#unknown() Invalid ref: non existent method in visible inner class\n\t * @see Unknown#vm_public() Invalid ref: non-existent class\n\t * @see Visibility.Unknown#vm_public() Invalid ref: non existent inner class\n\t */  \npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 5)\n\t* @see Visibility#unknown() Invalid ref: non-existent method\n\t                  ^^^^^^^\nJavadoc: The method unknown() is undefined for the type Visibility\n----------\n2. ERROR in test\\X.java (at line 6)\n\t* @see Visibility.VcPublic#unknown() Invalid ref: non existent method in visible inner class\n\t                           ^^^^^^^\nJavadoc: The method unknown() is undefined for the type Visibility.VcPublic\n----------\n3. ERROR in test\\X.java (at line 7)\n\t* @see Unknown#vm_public() Invalid ref: non-existent class\n\t       ^^^^^^^\nJavadoc: Unknown cannot be resolved to a type\n----------\n4. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.Unknown#vm_public() Invalid ref: non existent inner class\n\t       ^^^^^^^^^^^^^^^^^^\nJavadoc: Visibility.Unknown cannot be resolved to a type\n----------\n");
    }

    public void test049() {
        this.runNegativeReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Invalid package class methods references (non-visible)\n\t * \n\t * @see Visibility#vm_private() Invalid ref: non-visible method\n\t * @see Visibility.VcPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t * @see Visibility.VcPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t */  \npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 5)\n\t* @see Visibility#vm_private() Invalid ref: non-visible method\n\t                  ^^^^^^^^^^\nJavadoc: The method vm_private() from the type Visibility is not visible\n----------\n2. ERROR in test\\X.java (at line 6)\n\t* @see Visibility.VcPrivate#unknown() Invalid ref: non visible inner class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type Visibility.VcPrivate is not visible\n----------\n3. ERROR in test\\X.java (at line 7)\n\t* @see Visibility.VcPublic#vm_private() Invalid ref: non visible method in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The method vm_private() from the type Visibility.VcPublic is not visible\n----------\n");
    }

    public void test050() {
        this.runNegativeReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Invalid package class methods references (non-applicable)\n\t * \n\t * @see Visibility#vm_private(int) Invalid ref: non-applicable method\n\t * @see Visibility#vm_public(String) Invalid ref: non-applicable method\n\t * @see Visibility.VcPublic#vm_private(Integer, byte) Invalid ref: non applicable method in visible inner class\n\t * @see Visibility.VcPublic#vm_public(Double z, Boolean x) Invalid ref: non applicable method in visible inner class\n\t */  \npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 5)\n\t* @see Visibility#vm_private(int) Invalid ref: non-applicable method\n\t                  ^^^^^^^^^^\nJavadoc: The method vm_private() in the type Visibility is not applicable for the arguments (int)\n----------\n2. ERROR in test\\X.java (at line 6)\n\t* @see Visibility#vm_public(String) Invalid ref: non-applicable method\n\t                  ^^^^^^^^^\nJavadoc: The method vm_public() in the type Visibility is not applicable for the arguments (String)\n----------\n3. ERROR in test\\X.java (at line 7)\n\t* @see Visibility.VcPublic#vm_private(Integer, byte) Invalid ref: non applicable method in visible inner class\n\t                           ^^^^^^^^^^\nJavadoc: The method vm_private() in the type Visibility.VcPublic is not applicable for the arguments (Integer, byte)\n----------\n4. ERROR in test\\X.java (at line 8)\n\t* @see Visibility.VcPublic#vm_public(Double z, Boolean x) Invalid ref: non applicable method in visible inner class\n\t                           ^^^^^^^^^\nJavadoc: The method vm_public() in the type Visibility.VcPublic is not applicable for the arguments (Double, Boolean)\n----------\n");
    }

    public void test051() {
        this.runNegativeReferenceTest(new String[]{"test/X.java", "package test;\nimport test.copy.*;\n\t/**\n\t * Invalid other package non visible class methods references (non existent/visible arguments)\n\t * \n\t * @see VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t * @see test.copy.VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t */  \npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\t* @see VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^\nJavadoc: The type VisibilityPackage is not visible\n----------\n2. ERROR in test\\X.java (at line 7)\n\t* @see test.copy.VisibilityPackage#unknown() Invalid ref: non visible class (non existent method)\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: The type test.copy.VisibilityPackage is not visible\n----------\n");
    }

    public void test052() {
        this.runConformReferenceTest(new String[]{"test/X.java", "package test;\nimport test.copy.VisibilityPublic;\n\t/**\n\t * Valid other package visible class methods references \n\t * \n\t * @see VisibilityPublic#vm_public() Valid ref to not visible method of other package class\n\t * @see VisibilityPublic.VpPublic#vm_public() Valid ref to visible method of other package public inner class\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"});
    }

    public void test053() {
        this.runConformReferenceTest(new String[]{"test/X.java", "package test;\n\t/**\n\t * Valid other package visible class methods references \n\t * \n\t * @see test.copy.VisibilityPublic#vm_public() Valid ref to not visible method of other package class\n\t * @see test.copy.VisibilityPublic.VpPublic#vm_public() Valid ref to visible method of other package public inner class\n\t */\npublic class X {\n\tpublic void s_foo() {\n\t}\n}\n"});
    }
}

