/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class Compliance_1_3
extends AbstractRegressionTest {
    boolean docSupport = false;
    static /* synthetic */ Class class$0;

    public Compliance_1_3(String name) {
        super(name);
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        if (this.docSupport) {
            options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "enabled");
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "error");
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTags", "enabled");
        }
        return options;
    }

    public static Test suite() {
        return Compliance_1_3.buildUniqueComplianceTestSuite(Compliance_1_3.testClass(), "1.3");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.Compliance_1_3");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.docSupport = false;
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.js", "\tvoid foo() { \n\t\twhile (false);\t\n\t\twhile (false) println(\"unreachable\");\t\n\t\tdo ; while (false);\t\n\t\tdo println(\"unreachable\"); while (false);\t\n\t\tfor (;false;);\t\n\t\tfor (;false;) println(\"unreachable\");\t\n\t\tif (false);\t\n\t\tif (false) println(\"unreachable\");\t\t\n\t}\t\n\tfunction println(s){}\t\n \n"}, "----------\n1. ERROR in p1\\X.js (at line 3)\n\twhile (false) System.out.println(\"unreachable\");\t\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n2. ERROR in p1\\X.js (at line 7)\n\tfor (;false;) System.out.println(\"unreachable\");\t\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test037() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "TODO:");
        this.runNegativeTest(new String[]{"X.js", "function X() {\n}\n// TODO: something"}, "----------\n1. WARNING in p\\X.js (at line 4)\n\t// TODO: something\n\t   ^^^^^^^^^^^^^^^\nTODO: something\n----------\n", null, true, customOptions);
    }

    public void test038() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "TODO:");
        this.runNegativeTest(new String[]{"X.js", "// TODO: something"}, "----------\n1. WARNING in X.js (at line 1)\n\t// TODO: something\n\t   ^^^^^^^^^^^^^^^\nTODO: something\n----------\n", null, true, customOptions);
    }

    public void test072() {
        this.runNegativeTest(new String[]{"X.js", "    function main( args) {\n        try {\n            f();\n        } catch(e) {\n            println(\"SUCCESS\");\n        }\n    }\n    function f() {\n       function ff ()\n      //      {\n                    if (true) throw null;\n            }\n      //  };\n    }\n  function println(s){}"}, "----------\n1. ERROR in X.js (at line 12)\n\tif (true) throw null;\n\t                ^^^^\nCannot throw null as an exception\n----------\n");
    }

    public void test074() {
        this.runNegativeTest(new String[]{"X.js", "    function main(args) {\t\n    \tvar nonInlinedString = \"[Local]\";\t\n    \tvar i = 2;\t\n\t\tswitch(i){\t\n\t\t\tcase 1:\t\n\t\t\t\tvar displayString = nonInlinedString;\n\t\t\t\tvar inlinedString = \"a\";\t\n//\t\t\t\tclass Local {\t\n\t\t\t\t\tfunction toString() {\t\n\t\t\t\t\t\treturn inlinedString + displayString;\t\n\t\t\t\t\t}\t\n//\t\t\t\t}\t\n\t\t\tcase 2:\t\n//\t\t\t\tprint(new Local());\t\n//\t\t\t\tprint(\"-\");\t\n\t\t}\t\n    }\t\n\tfunction println(s){}\n"}, "----------\n1. ERROR in X.js (at line 14)\n\tSystem.out.print(new Local());\t\n\t                 ^^^^^^^^^^^\nThe local variable displayString may not have been initialized\n----------\n2. ERROR in X.js (at line 16)\n\tSystem.out.println(new Local(){\t\n\t\t\t\t\tpublic String toString() {\t\n\t\t\t\t\t\treturn super.toString()+\": anonymous\";\t\n\t\t\t\t\t}\t\n\t\t\t\t});\t\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe local variable displayString may not have been initialized\n----------\n");
    }

    public void test084() {
        this.runNegativeTest(new String[]{"X.js", "\tvoid foo() {\n\t\tObject enum = null;\n\t}\n\n"}, "----------\n1. WARNING in X.js (at line 2)\n\tObject enum = null;\n\t       ^^^^\n'enum' should not be used as an identifier, since it is a reserved keyword from source level 5.0 on\n----------\n");
    }

    public void test100() {
        this.runNegativeTest(new String[]{"X.js", "    var \\ud800\\udc05\\ud800\\udc04\\ud800\\udc03\\ud800\\udc02\\ud800\\udc01\\ud800\\udc00;\n    function foo() {\n        var \\ud800\\udc05\\ud800\\udc04\\ud800\\udc03\\ud800\\udc02\\ud800\\udc01\\ud800\\udc00;\n    }\n\n"}, "----------\n1. ERROR in X.js (at line 1)\n\tint \\ud800\\udc05\\ud800\\udc04\\ud800\\udc03\\ud800\\udc02\\ud800\\udc01\\ud800\\udc00;\n\t    ^^^^^^\nInvalid unicode\n----------\n2. ERROR in X.js (at line 3)\n\tint \\ud800\\udc05\\ud800\\udc04\\ud800\\udc03\\ud800\\udc02\\ud800\\udc01\\ud800\\udc00;\n\t    ^^^^^^\nInvalid unicode\n----------\n");
    }
}

