/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.parser.AbstractSelectionTest;

public class SelectionTest
extends AbstractSelectionTest {
    static final String RESOLVE_LOCAL_NAME = "function foo(){\nvar var1 = new Object();\nvar var2 = 1;\nvar1.toString();\nvar2++;\nif (var2 == 3) {\n\tvar var3 = var1;\n\tvar3.hashCode();\n} else {\n\tvar var3 = new Object();\n\tvar3.toString();\n}\nvar var4 = 1;\n\n}\n";
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.parser.SelectionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SelectionTest.buildAllCompliancesTestSuite(clazz);
    }

    public SelectionTest(String testName) {
        super(testName);
    }

    public void test00() {
        String str = "\tvar i=foo(); \t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "=";
        String selectionEndBehind = "foo";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:foo()>";
        String completionIdentifier = "foo";
        String expectedUnitDisplayString = "var i = <SelectOnMessageSend:foo()>;\n";
        String expectedReplacedSource = "foo()";
        String testName = "<select message send>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test01() {
        String str = "\tvar i=bb.foo(); \t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "bb.";
        String selectionEndBehind = "foo";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:bb.foo()>";
        String completionIdentifier = "foo";
        String expectedUnitDisplayString = "var i = <SelectOnMessageSend:bb.foo()>;\n";
        String expectedReplacedSource = "bb.foo()";
        String testName = "<select message send>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test05() {
        String str = "\tfunction foo(){\t\t\t\t\t\t\t\t\t\n\t\tSystem.out.println(\"hello\");\t\t\t\n";
        String selectionStartBehind = "System.out.";
        String selectionEndBehind = "println";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:System.out.println(\"hello\")>";
        String completionIdentifier = "println";
        String expectedUnitDisplayString = "function foo() {\n  <SelectOnMessageSend:System.out.println(\"hello\")>;\n}\n";
        String expectedReplacedSource = "System.out.println(\"hello\")";
        String testName = "<select message send>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test05b() {
        String str = "\t\tSystem.out.println(\"hello\");\t\t\t\n";
        String selectionStartBehind = "System.out.";
        String selectionEndBehind = "println";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:System.out.println(\"hello\")>";
        String completionIdentifier = "println";
        String expectedUnitDisplayString = "<SelectOnMessageSend:System.out.println(\"hello\")>;\n";
        String expectedReplacedSource = "System.out.println(\"hello\")";
        String testName = "<select message send>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test06() {
        String str = "\tfunction foo(){\t\t\t\t\t\t\t\t\t\n\t\tSystem.out.println(\"hello\");\t\t\t\n";
        String selectionStartBehind = "System.out.";
        String selectionEndBehind = "println";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:System.out.println(\"hello\")>";
        String completionIdentifier = "println";
        String expectedUnitDisplayString = "function foo() {\n  <SelectOnMessageSend:System.out.println(\"hello\")>;\n}\n";
        String expectedReplacedSource = "System.out.println(\"hello\")";
        String testName = "<select message send with recovery before>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test07() {
        String str = "\tfunction foo(){\t\t\t\t\t\t\t\t\t\n\t\tthis.bar(\"hello\");\t\t\t\t\t\n\tfunction bar( s){\t\t\t\t\t\t\t\n\t\treturn s.length();\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "this.";
        String selectionEndBehind = "this.bar";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:this.bar(\"hello\")>";
        String completionIdentifier = "bar";
        String expectedUnitDisplayString = "function foo() {\n  <SelectOnMessageSend:this.bar(\"hello\")>;\n}\nfunction bar(s) {\n}\n";
        String expectedReplacedSource = "this.bar(\"hello\")";
        String testName = "<select message send with sibling method>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test08() {
        String str = "\tvar num = 0;\t\t\t\t\t\t\t\t\n\tfunction foo(){\t\t\t\t\t\t\t\t\t\n\t\tvar j = this.num;\t\t\t\t\t\t\n";
        String selectionStartBehind = "this.";
        String selectionEndBehind = "this.num";
        String expectedCompletionNodeToString = "<SelectionOnFieldReference:this.num>";
        String completionIdentifier = "num";
        String expectedUnitDisplayString = "var num;\nfunction foo() {\n  var j = <SelectionOnFieldReference:this.num>;\n}\n";
        String expectedReplacedSource = "this.num";
        String testName = "<select field reference>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test09() {
        String str = "\tvar num \t\t\t\t\t\t\t\t\t\n\tfunction foo(){\t\t\t\t\t\t\t\t\t\n\t\tvar j = this.num;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "this.";
        String selectionEndBehind = "this.num";
        String expectedCompletionNodeToString = "<SelectionOnFieldReference:this.num>";
        String completionIdentifier = "num";
        String expectedUnitDisplayString = "var num;\nfunction foo() {\n  var j = <SelectionOnFieldReference:this.num>;\n}\n";
        String expectedReplacedSource = "this.num";
        String testName = "<select field reference with syntax errors>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test10() {
        String str = "\tvar x; \t\t\t\t\t\t\t\t\t\n\tfunction foo(){\t\t\t\t\t\t\t\t\n\t\tvar j = this.x.foo();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "this.";
        String selectionEndBehind = "this.x";
        String expectedCompletionNodeToString = "<SelectionOnFieldReference:this.x>";
        String completionIdentifier = "x";
        String expectedUnitDisplayString = "var x;\nfunction foo() {\n  var j = <SelectionOnFieldReference:this.x>.foo();\n}\n";
        String expectedReplacedSource = "this.x";
        String testName = "<select field reference inside message receiver>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test11() {
        String str = "\tfunction X(i){}\t\t\t\t\t\t\t\t\n\tfunction foo(){\t\t\t\t\t\t\t\t\n\t\tvar j = 0;\t\t\t\t\t\t\t\n\t\tvar x = new X(j);\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "new ";
        String selectionEndBehind = "new X";
        String expectedCompletionNodeToString = "<SelectOnAllocationExpression:new X(j)>";
        String completionIdentifier = "X";
        String expectedUnitDisplayString = "function X(i) {\n  }\nfunction foo() {\n  var j;\n  var x = <SelectOnAllocationExpression:new X(j)>;\n}\n";
        String expectedReplacedSource = "new X(j)";
        String testName = "<select allocation>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test13() {
        String str = "\tfunction foo(){\t\t\t\t\t\t\t\t\n\t\tjava.lang.System.out.println();\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "java.lang.";
        String selectionEndBehind = "java.lang.System";
        String expectedCompletionNodeToString = "<SelectOnName:java.lang.System>";
        String completionIdentifier = "System";
        String expectedUnitDisplayString = "function foo() {\n    <SelectOnName:java.lang.System>;\n}\n";
        String expectedReplacedSource = "java.lang.System.out";
        String testName = "<select qualified name receiver>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test14() {
        String str = "\tint foo(){\t\t\t\t\t\t\t\t\n\t\tvar sys = java.lang.System;\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "java.lang.";
        String selectionEndBehind = "java.lang.System";
        String expectedCompletionNodeToString = "<SelectOnName:java.lang.System>";
        String completionIdentifier = "System";
        String expectedUnitDisplayString = "function foo() {\n  var sys = <SelectOnName:java.lang.System>;\n}\n";
        String expectedReplacedSource = "java.lang.System";
        String testName = "<select qualified name>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test17() {
        String str = "function foo(){\t\t\t\t\t\t\t\t\n\t\tSystem \t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "\n\t\t";
        String selectionEndBehind = "\n\t\tSystem";
        String expectedCompletionNodeToString = "<SelectOnName:System>";
        String completionIdentifier = "System";
        String expectedUnitDisplayString = "function foo() {\n  <SelectOnName:System>;\n}\n";
        String expectedReplacedSource = "System";
        String testName = "<select name>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test23() {
        String str = "public class X {\t\t \t\t\t\t\t\n\tint foo(){\t\t\t\t\t\t\t\t\n\t\tString[] p = new String[]{\"Left\"};\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "new ";
        String selectionEndBehind = "new String";
        String expectedCompletionNodeToString = "<SelectOnType:String>";
        String completionIdentifier = "String";
        String expectedUnitDisplayString = "public class X {\n  public X() {\n  }\n  int foo() {\n    String[] p = <SelectOnType:String>;\n  }\n}\n";
        String expectedReplacedSource = "String";
        String testName = "<select array initializer type>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test32() {
        String str = "function containsPhrase(){\t\t\t\t\t\t\t\n\t\t\t\tvar currentChar = \"hello\".toLowerCase()\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "\"hello\".";
        String selectionEndBehind = "\"hello\".toLowerCase";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:\"hello\".toLowerCase()>";
        String completionIdentifier = "toLowerCase";
        String expectedUnitDisplayString = "function containsPhrase() {\n  var currentChar = <SelectOnMessageSend:\"hello\".toLowerCase()>;\n}\n";
        String expectedReplacedSource = "\"hello\".toLowerCase()";
        String testName = "<1FWT4AJ: ITPCOM:WIN98 - SelectionParser produces duplicate type declaration>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test34() {
        String str = "function foo() {\t\t\t\t\t\t\n  var array = new Object();\t\t\n\t\treturn array.length;\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String selectionStartBehind = "\n\t\treturn ";
        String selectionEndBehind = "array.length";
        String expectedCompletionNodeToString = "<NONE>";
        String completionIdentifier = "<NONE>";
        String expectedUnitDisplayString = "function foo() {\n  var array;\n  return array.length;\n}\n";
        String expectedReplacedSource = "<NONE>";
        String testName = "<1GB99S3: ITPJUI:WINNT - SH: NPE in editor while getting hover help>";
        int selectionStart = str.indexOf(selectionStartBehind) + selectionStartBehind.length();
        int selectionEnd = str.indexOf(selectionEndBehind) + selectionEndBehind.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test41() {
        String str = "function foo(){                   \n    var vari;              \n}\t\t\t\t\t\t\t\t \n";
        String selection = "vari";
        String expectedCompletionNodeToString = "<SelectionOnLocalName:vari>;";
        String completionIdentifier = "vari";
        String expectedUnitDisplayString = "function foo() {\n  <SelectionOnLocalName:vari>;\n}\n";
        String expectedReplacedSource = "vari";
        String testName = "<select local name>";
        int selectionStart = str.indexOf(selection);
        int selectionEnd = str.indexOf(selection) + selection.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test42() {
        String str = " function foo(vari){          \n}\t\t\t\t\t\t\t\t \n";
        String selection = "vari";
        String expectedCompletionNodeToString = "<SelectionOnArgumentName:vari>";
        String completionIdentifier = "vari";
        String expectedUnitDisplayString = "function foo(<SelectionOnArgumentName:vari>) {\n}\n";
        String expectedReplacedSource = "vari";
        String testName = "<select argument name>";
        int selectionStart = str.indexOf(selection);
        int selectionEnd = str.indexOf(selection) + selection.length() - 1;
        this.checkDietParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test49() {
        String str = "var x = new X();\n\t\t\t\t\t\t\t\t \n";
        String selection = "X";
        String expectedCompletionNodeToString = "<SelectOnAllocationExpression:new X()>";
        String completionIdentifier = "X";
        String expectedUnitDisplayString = "var x = <SelectOnAllocationExpression:new X()>\n\n";
        String expectedReplacedSource = "new X()";
        String testName = "<select anonymous type>";
        int selectionStart = str.lastIndexOf(selection);
        int selectionEnd = str.lastIndexOf(selection) + selection.length() - 1;
        this.checkDietParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test55() {
        String str = "function foo() {\n    new Test.Sub();\n}\t\t\t\t\t\t\t\t \n";
        String selection = "Sub";
        String expectedCompletionNodeToString = "<SelectOnAllocationExpression:new Test.Sub()>";
        String completionIdentifier = "Sub";
        String expectedUnitDisplayString = "function foo() {\n    <SelectOnAllocationExpression:new Test.Sub()>;\n}\n";
        String expectedReplacedSource = "new Test.Sub()";
        String testName = "<select>";
        int selectionStart = str.indexOf(selection);
        int selectionEnd = str.indexOf(selection) + selection.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test56() {
        String str = RESOLVE_LOCAL_NAME;
        String startString = "var1.toString();";
        String selection = "var1";
        String expectedCompletionNodeToString = "<SelectOnName:var1>";
        String completionIdentifier = "var1";
        String expectedUnitDisplayString = "function foo() {\n  var var1;\n  var var2;\n  <SelectOnName:var1>;\n  {\n    var var3;\n  }\n  {\n    var var3;\n  }\n  var var4;\n}\n";
        String expectedReplacedSource = "var1";
        String testName = "<select>";
        int selectionStart = str.indexOf(startString);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test57() {
        String str = "YAHOO.widget.Slider = function (sElementId, sGroup, oThumb, sType) {\nif (sElementId) {\n}\n};\n";
        String startString = "sElementId)";
        String selection = "sElementId";
        String expectedCompletionNodeToString = "<SelectOnName:sElementId>";
        String completionIdentifier = "sElementId";
        String expectedUnitDisplayString = "YAHOO.widget.Slider = function (sElementId, sGroup, oThumb, sType) {\n  if (<SelectOnName:sElementId>)\n      {\n      }\n};\n";
        String expectedReplacedSource = "sElementId";
        String testName = "<select>";
        int selectionStart = str.indexOf(startString);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkMethodParse(str.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }
}

