/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.util.Locale;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.parser.TestSourceElementRequestor;
import org.eclipse.wst.jsdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.IProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class DietRecoveryTest
extends AbstractCompilerTest {
    public static boolean optimizeStringLiterals = false;
    public static long sourceLevel = 0x2F0000L;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.parser.DietRecoveryTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return DietRecoveryTest.buildAllCompliancesTestSuite(clazz);
    }

    public DietRecoveryTest(String testName) {
        super(testName);
    }

    public void checkParse(char[] source, String expectedDietUnitToString, String expectedDietPlusBodyUnitToString, String expectedDietPlusBodyPlusStatementsRecoveryUnitToString, String expectedFullUnitToString, String expectedCompletionDietUnitToString, String testName) {
        int i;
        CompilationResult compilationResult;
        CompilationUnit sourceUnit;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)(sourceUnit = new CompilationUnit(source, testName, null)), compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0));
        String computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        DietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setMethodsFullRecovery(false);
        parser.setStatementsRecovery(false);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        DietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = computedUnit.types.length;
            while (--i >= 0) {
                computedUnit.types[i].parseMethod(parser, computedUnit);
            }
        }
        if (!expectedDietPlusBodyUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        DietRecoveryTest.assertEquals("Invalid unit diet+body structure" + testName, expectedDietPlusBodyUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setMethodsFullRecovery(true);
        parser.setStatementsRecovery(true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        DietRecoveryTest.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = computedUnit.types.length;
            while (--i >= 0) {
                computedUnit.types[i].parseMethod(parser, computedUnit);
            }
        }
        if (!expectedDietPlusBodyPlusStatementsRecoveryUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        DietRecoveryTest.assertEquals("Invalid unit diet+body structure with statements recovery" + testName, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        DietRecoveryTest.assertEquals("Invalid unit full structure" + testName, expectedFullUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        DietRecoveryTest.assertEquals("Invalid source element diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new SourceElementParser((ISourceElementRequestor)new TestSourceElementRequestor(), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(this.getCompilerOptions()), false, true);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        DietRecoveryTest.assertEquals("Invalid source element full structure" + testName, expectedFullUnitToString, computedUnitToString);
        CompilerOptions options = new CompilerOptions(this.getCompilerOptions());
        CompletionParser parser2 = new CompletionParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), options, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())));
        CompilationUnit sourceUnit2 = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult2 = new CompilationResult((ICompilationUnit)sourceUnit2, 0, 0, 0);
        CompilationUnitDeclaration computedUnit2 = parser2.dietParse((ICompilationUnit)sourceUnit2, compilationResult2, Integer.MAX_VALUE);
        String computedUnitToString2 = computedUnit2.toString();
        if (!expectedCompletionDietUnitToString.equals(computedUnitToString2)) {
            System.out.println(Util.displayString(computedUnitToString2));
        }
        DietRecoveryTest.assertEquals("Invalid completion diet structure" + testName, expectedCompletionDietUnitToString, computedUnitToString2);
    }

    public void test01() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\tpublic int[] i = { 0, 1 };\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String testName = "<promote local vars into fields>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test02() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tclass L {\t\t\t\t\t\t\t\t\n\t\t\tvoid baz(){}\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\tpublic int[] i = { 0, 1 };\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class L {\n      L() {\n        super();\n      }\n      void baz() {\n      }\n    }\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String testName = "<filter out local type>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test03() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\tpublic int[] i = { 0, 1 };\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String testName = "<should find last method>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test04() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n X x;\t\t\t\t\t\t\t\t\t\t\n Object a, b = null;\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\tpublic int[] i = { 0, 1 };\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  X x;\n  Object a;\n  Object b = null;\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  X x;\n  Object a;\n  Object b = null;\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  X x;\n  Object a;\n  Object b;\n  public int h;\n  public int[] i;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String testName = "<five fields>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test05() {
        String s = "public class X {\t\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n \tvoid baz(){}\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new baz() {\n    };\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = "public class X {\n  {\n  }\n  public X() {\n  }\n  void foo() {\n  }\n  void baz() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<diet was successful>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test06() {
        String s = "import java.lang.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n \tvoid baz(){}\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "import java.lang.*;\npublic class X {\n  {\n  }\n  public X() {\n  }\n  void foo() {\n  }\n  void baz() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "import java.lang.*;\npublic class X {\n  {\n  }\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n  void baz() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<will not miss nested method>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test07() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n int x;\t\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n int y;\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  {\n  }\n  int x;\n  int y;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  {\n  }\n  int x;\n  int y;\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<attaching orphans>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test08() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n class Y {\t\t\t\t\t\t\t\t\t\n\t  void foo() {\t\t\t\t\t\t\t\t\n\t   System.out.println();\t\t\t\t\t\n   }\t\t\t\t\t\t\t\t\t\t\t\n public int h;\t\t\t\t\t\t\t\t\n public int[] i = {0, 1};\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    public int h;\n    public int[] i = {0, 1};\n    Y() {\n    }\n    void foo() {\n    }\n    void bar() {\n    }\n    void baz() {\n    }\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    public int h;\n    public int[] i = {0, 1};\n    Y() {\n      super();\n    }\n    void foo() {\n      System.out.println();\n    }\n    void bar() {\n    }\n    void baz() {\n    }\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  class Y {\n    public int h;\n    public int[] i;\n    Y() {\n    }\n    void foo() {\n    }\n    void bar() {\n    }\n    void baz() {\n    }\n  }\n  public X() {\n  }\n}\n";
        String testName = "<attaching to member type>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test09() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n class Y {\t\t\t\t\t\t\t\t\t\n\t  void foo() {\t\t\t\t\t\t\t\t\n\t   System.out.println();\t\t\t\t\t\n   }\t\t\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n public int h;\t\t\t\t\t\t\t\t\n public int[] i = {0, 1};\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    Y() {\n    }\n    void foo() {\n    }\n  }\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    Y() {\n      super();\n    }\n    void foo() {\n      System.out.println();\n    }\n  }\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n    super();\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  class Y {\n    Y() {\n    }\n    void foo() {\n    }\n  }\n  public int h;\n  public int[] i;\n  public X() {\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String testName = "<attaching to enclosing type>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test10() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n class Y \t\t\t\t\t\t\t\t\t\n\t  void foo() {\t\t\t\t\t\t\t\t\n\t   System.out.println();\t\t\t\t\t\n   }\t\t\t\t\t\t\t\t\t\t\t\n public int h;\t\t\t\t\t\t\t\t\n public int[] i = {0, 1};\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    public int h;\n    public int[] i = {0, 1};\n    Y() {\n    }\n    void foo() {\n    }\n    void bar() {\n    }\n    void baz() {\n    }\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    public int h;\n    public int[] i = {0, 1};\n    Y() {\n      super();\n    }\n    void foo() {\n      System.out.println();\n    }\n    void bar() {\n    }\n    void baz() {\n    }\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  class Y {\n    public int h;\n    public int[] i;\n    Y() {\n    }\n    void foo() {\n    }\n    void bar() {\n    }\n    void baz() {\n    }\n  }\n  public X() {\n  }\n}\n";
        String testName = "<missing brace + array initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test11() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n  int x;\t\t\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n int y;\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  {\n  }\n  int y;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  {\n  }\n  int y;\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n  void bar() {\n    int x;\n  }\n  void baz() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<attaching orphans with missing brackets>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test12() {
        String s = "public class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n public int x;\t\t\t\t\t\t\t\t\n\tvoid baz(){\t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n int y;\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  {\n  }\n  public int x;\n  int y;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  {\n  }\n  public int x;\n  int y;\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n  void bar() {\n  }\n  void baz() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<attaching orphans with missing brackets 2>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test13() {
        String s = "public class X extends {\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<invalid type header>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test14() {
        String s = "public class X extends Thread {\t\t\t\t\n\tvoid foo() \t\t\t\t\t\t\t\t\t\n\tvoid bar() \t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X extends Thread {\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X extends Thread {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<method header missing opening brace>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test15() {
        String s = "public class X extends Thread {\t\t\t\t\n\tvoid foo() throws\t\t\t\t\t\t\t\n\tvoid bar() \t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X extends Thread {\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X extends Thread {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X extends Thread {\n  public X() {\n    super();\n  }\n  void foo() {\n    ;\n  }\n  void bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<method header missing thrown exceptions>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test16() {
        String s = "public class X implements \t\t\t\t\t\t\n\tvoid foo() \t\t\t\t\t\t\t\t\t\n\tvoid bar() \t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<type header missing superinterfaces>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test17() {
        String s = "public class X implements Y,\t\t\t\t\t\n\tvoid foo() \t\t\t\t\t\t\t\t\t\n\tvoid bar() \t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X implements Y {\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X implements Y {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<type header missing superinterfaces 2>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test18() {
        String s = "public class X implements \t\t\t\t\t\t\n class Y { \t\t\t\t\t\t\t\t\t\n\t void bar() \t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    Y() {\n    }\n    void bar() {\n    }\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    Y() {\n      super();\n    }\n    void bar() {\n    }\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<member type behind incomplete enclosing type>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test19() {
        String s = "public class X \t\t \t\t\t\t\t\t\n class Y { \t\t\t\t\t\t\t\t\t\n\t void bar() \t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    Y() {\n    }\n    void bar() {\n    }\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    Y() {\n      super();\n    }\n    void bar() {\n    }\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<member type when missing opening brace>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test20() {
        String s = "public class X \t\t \t\t\t\t\t\t\n fieldX;\t\t\t\t\t\t\t\t\t\t\n class Y { \t\t\t\t\t\t\t\t\t\n\t void bar() \t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    Y() {\n    }\n    void bar() {\n    }\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    Y() {\n      super();\n    }\n    void bar() {\n    }\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<no field behind missing brace>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test21() {
        String s = "public class X \t\t \t\t\t\t\t\t\n fieldX;\t\t\t\t\t\t\t\t\t\t\n class Y  \t\t\t\t\t\t\t\t\t\n }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    Y() {\n    }\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    Y() {\n      super();\n    }\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find Y as member type>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test22() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tclass L extends {\t\t\t\t\t\t\n\t\t\tpublic int l;\t\t\t\t\t\t\n\t\t\tvoid baz(){}\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class L {\n      public int l;\n      L() {\n        super();\n      }\n      void baz() {\n      }\n    }\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should filter out incomplete local type>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test23() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tclass L extends {\t\t\t\t\t\t\n\t\t\tpublic int l;\t\t\t\t\t\t\n\t\t\tvoid baz() throws {}\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class L {\n      public int l;\n      L() {\n        super();\n      }\n      void baz() {\n      }\n    }\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should filter out incomplete local type/method>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test24() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tnew X(){\t\t\t\t\t\t\t\t\n\t\t\tvoid baz() {}\t\t\t\t\t\t\n\t\t}.baz();\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new X() {\n  void baz() {\n  }\n}.baz();\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should filter out incomplete anonymous type/method>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test25() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tnew X(){\t\t\t\t\t\t\t\t\n\t\t\tvoid baz() {}\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tpublic int h;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tvoid bar(){\t\t\t\t\t\t\t\t\n\t\tvoid truc(){\t\t\t\t\t\t\t\n}\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    new X() {\n      public int h;\n      void baz() {\n      }\n      void bar() {\n      }\n      void truc() {\n      }\n    };\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should filter out incomplete anonymous type>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test26() {
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tnew X(){\t\t\t\t\t\t\t\t\n\t\t\tvoid baz() \t\t\t\t\t\t\t\n\t    }\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\t\t\n}\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should filter out incomplete anonymous method>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test27() {
        String s = "package a;\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\nimport java.util.*;\t\t\t\t\n\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\n\t\tSystem.out.println();\t\t\n\t\t\t\t\t\t\t\t\t\n\t\tclass L extends {\t\t\t\n\t\t\tpublic int l;\t\t\t\n\t\t\tvoid baz(){}\t\t\t\n\t\t}\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\n\t\tint h;\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n    class L {\n      public int l;\n      L() {\n        super();\n      }\n      void baz() {\n      }\n    }\n    int h;\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should filter incomplete local type L and variable h>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test28() {
        String s = "public class X {\t\t \t\n  int x;\t\t\t \t\t\n\t\t\t\t\t\t\t\n  int foo(){ }\t\t\t\t\n\t\t\t\t\t\t\t\n  class Y  {\t\t\t\t\n    int y;\t\t\t\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    int y;\n    Y() {\n    }\n  }\n  int x;\n  public X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    int y;\n    Y() {\n      super();\n    }\n  }\n  int x;\n  public X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find <y> as a field in Y>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test29() {
        String s = "public class X {\t\t \t\n  int x;\t\t\t \t\t\n\t\t\t\t\t\t\t\n  int foo(){ }\t\t\t\t\n\t\t\t\t\t\t\t\n  class Y  {\t\t\t\t\n}\t\t\t\t\t\t\t\n  int y;\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    Y() {\n    }\n  }\n  int x;\n  int y;\n  public X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    Y() {\n      super();\n    }\n  }\n  int x;\n  int y;\n  public X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find <y> as a field in X>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test30() {
        String s = "public class X {\t\t \t\n  int x;\t\t\t \t\t\n\t\t\t\t\t\t\t\n  int foo(){ }\t\t\t\t\n\t\t\t\t\t\t\t\n  class Y  \t\t\t\t\n}\t\t\t\t\t\t\t\n  int y;\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  class Y {\n    Y() {\n    }\n  }\n  int x;\n  int y;\n  public X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  class Y {\n    Y() {\n      super();\n    }\n  }\n  int x;\n  int y;\n  public X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find <y> as a field in X>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test31() {
        String s = "package a;\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\nimport java.util.*;\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\n\tvoid foo() \t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\n\t\t\t\t\t\t\t\t\t\t\n\tpublic int h;\t\t\t\t\t\t\n\tpublic int[] i = { 0, 1 };\t\t\t\n\t\t\t\t\t\t\t\t\t\t\n\tvoid bar(){\t\t\t\t\t\t\t\n\tvoid truc(){\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i = {0, 1};\n  public X() {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package a;\nimport java.lang.*;\nimport java.util.*;\npublic class X {\n  public int h;\n  public int[] i;\n  public X() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n  void truc() {\n  }\n}\n";
        String testName = "<should recover from partial method header>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test32() {
        String s = "public class WB2 {\t\t\t\t\t\t\t\t\t\t\t\n\tpublic void foo(java.util.Locale, java.util.Vector) {\t\n\t\tint i;\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tif(i instanceof O) {\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\tString s = \"hello\";\t\t\t\t\t\t\t\t\n\t\ts.\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class WB2 {\n  public WB2() {\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class WB2 {\n  public WB2() {\n    super();\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "1.3".equals(this.complianceLevel) || "1.4".equals(this.complianceLevel) ? "public class WB2 {\n  public WB2() {\n    super();\n  }\n  public void foo() {\n    java.util.Locale.java.util.Vector $missing$;\n  }\n}\n" : expectedDietPlusBodyUnitToString;
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should recover from method with missing argument names>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test33() {
        String s = "public class X {\t\t\t\t\n\tvoid hello()\t\t\t\t\n\tpublic X(int i)\t\t\t\t\n\tvoid foo() {\t\t\t\t\n\t\tSystem.out.println();\t\n\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  void hello() {\n  }\n  public X(int i) {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  void hello() {\n  }\n  public X(int i) {\n    super();\n  }\n  void foo() {\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not find message with no argument as a constructor>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test34() {
        String s = "public class X {\t\t\t\t\n\tvoid hello()\t\t\t\t\n\tpublic X(int i)\t\t\t\t\n\tstatic void foo() {\t\t\t\n\t\tX x;\t\t\t\t\t\n\t\tx = new X(23);\t\t\t\n\t\tSystem.out.println();\t\n\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  void hello() {\n  }\n  public X(int i) {\n  }\n  static void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  void hello() {\n  }\n  public X(int i) {\n    super();\n  }\n  static void foo() {\n    X x;\n    x = new X(23);\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not find allocation as a constructor>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test35() {
        String s = "public class X {\t\t\n\tint x\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  int x;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  int x;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<incomplete field header>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test36() {
        String s = "public class X {\t\t\n\tint x, y\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  int x;\n  int y;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  int x;\n  int y;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<incomplete multiple field headers>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test37() {
        String s = "public class X {\t\t\n\tString s = \"\t\t\n";
        String expectedDietUnitToString = "public class X {\n  String s;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  String s;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<field header with started string initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test38() {
        String s = "public class X implements Y, {\t\t\n\tString s = \"\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X implements Y {\n  String s;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X implements Y {\n  String s;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<field header and incomplete superinterface>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test39() {
        String s = "public class X implements \t\t\nint x\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  int x;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  int x;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<field signature behind keyword implements>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test40() {
        String s = "public class X implements Y, \t\t\n\tString s = \"\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X implements Y, String {\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X implements Y, String {\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<field type read as interface>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test41() {
        String s = "public class X public int foo(int bar(static String s";
        String expectedDietUnitToString = "public class X {\n  static String s;\n  public X() {\n  }\n  <clinit>() {\n  }\n  public int foo() {\n  }\n  int bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  static String s;\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n  public int foo() {\n  }\n  int bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<contiguous headers>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test42() {
        String s = "public class X public int foo(int x, int bar public String s;";
        String expectedDietUnitToString = "public class X {\n  public String s;\n  public X() {\n  }\n  public int foo(int x, int bar) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public String s;\n  public X() {\n    super();\n  }\n  public int foo(int x, int bar) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<contiguous headers without comma>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test43() {
        String s = "public class X \t\t\t\n\tpublic int foo(\t\t\t\n\tint bar(\t\t\t\t\n \tstatic String s, int x\t\n";
        String expectedDietUnitToString = "public class X {\n  static String s;\n  int x;\n  public X() {\n  }\n  <clinit>() {\n  }\n  public int foo() {\n  }\n  int bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  static String s;\n  int x;\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n  public int foo() {\n  }\n  int bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<contiguous headers without comma>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test44() {
        String s = "class X {\t\t\t\t\t\n\tString s;\t\t\t\t\n\t\t\t\t\t\t\t\n\tpublic void foo(\t\t\n\t\tstatic int x\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  String s;\n  static int x;\n  X() {\n  }\n  <clinit>() {\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  String s;\n  static int x;\n  X() {\n    super();\n  }\n  <clinit>() {\n  }\n  public void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find static field x>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test45() {
        String s = "public class X {\t\t\t\n\tint foo(){\t\t\t\t\n\t\tString s = \"\t\t\n\t}\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<missing string literal quote inside method>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test46() {
        String s = "class X \t\t\t\t\t\n  String s = \"class y \t\n  class Member \t\t\t\n\tint foo() \t\t\t\t\n        public int x;    \t\n  } \t\t\t\t\t\t\n int bar() \t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  class Member {\n    public int x;\n    Member() {\n    }\n    int foo() {\n    }\n  }\n  String s;\n  X() {\n  }\n  int bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  class Member {\n    public int x;\n    Member() {\n      super();\n    }\n    int foo() {\n    }\n  }\n  String s;\n  X() {\n    super();\n  }\n  int bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<detecting member type closing when missing brackets>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test47() {
        String s = "class X {\t\t\t\t\t\t\t\t\t\n\tint foo(AA a, BB b, IOEx\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  X() {\n  }\n  int foo(AA a, BB b) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  X() {\n    super();\n  }\n  int foo(AA a, BB b) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unterminated method arguments>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test48() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tfinal static int foo(){ \t\t\t\t\n\t\treturn \"1; \t\t\t\t\t\t\n\t} \t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String argv[]){ \n\t\tfoo();\t\t\t\t\t\t\t\t\n\t} \t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  static final int foo() {\n  }\n  public static void main(String[] argv) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  static final int foo() {\n  }\n  public static void main(String[] argv) {\n    foo();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unterminated literal string in method body>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test49() {
        String s = "public class X {\t\t\t\t\t\t\t\n\t{\t\t\t\t\t\t\t\t\t\t\n     int x;\t\t\t\t\t\t\t\t\n\t \t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  {\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  {\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unterminated initializer with local declaration>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test50() {
        String s = "public class X {\t\t\t\t\t\t\t\n   int foo(){\t\t\t\t\t\t\t\t\n\t  if(true){\t\t\t\t\t\t\t\t\n     \tint x;\t\t\t\t\t\t\t\t\n\t \t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  int foo() {\n    if (true)\n        {\n          int x;\n        }\n    else\n        ;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unterminated if statement>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test51() {
        String s = "public class X {\t\t\t\t\t\t\t\n   int foo(){\t\t\t\t\t\t\t\t\n\t  {\t\t\t\t\t\t\t\t\t\t\n     \tint x;\t\t\t\t\t\t\t\t\n\t \t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  int foo() {\n    {\n      int x;\n    }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unterminated nested block with local declaration>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test52() {
        String s = "public class X {\t\t\t\t\t\t\t\n   int foo(){\t\t\t\t\t\t\t\t\n\t  {\t\t\t\t\t\t\t\t\t\t\n     \tpublic int x;\t\t\t\t\t\t\n\t \t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  public int x;\n  public X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public int x;\n  public X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unterminated nested block with field declaration>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test53() {
        String s = "public class X {\t\t\t\t\t\t\t\n\t{\t\t\t\t\t\t\t\t\t\t\n     public int x;\t\t\t\t\t\t\t\n\t \t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  {\n  }\n  public int x;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  {\n  }\n  public int x;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unterminated initializer with field declaration>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test54() {
        String s = "package p;\t\t\t\t\t\t\t\t\npublic class ZPro.Sev.Blo {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nvoid ThisIsADummyMethodThatIsCreatedOnlyForThePurposesOfTheCompletionEngine() {\t\n\tSystem.out.println(this.getClass());\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t// COMMENT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package p;\npublic class ZPro {\n  {\n  }\n  public ZPro() {\n  }\n  void ThisIsADummyMethodThatIsCreatedOnlyForThePurposesOfTheCompletionEngine() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package p;\npublic class ZPro {\n  {\n  }\n  public ZPro() {\n    super();\n  }\n  void ThisIsADummyMethodThatIsCreatedOnlyForThePurposesOfTheCompletionEngine() {\n    System.out.println(this.getClass());\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<Invalid class name>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test55() {
        String s = "public class X {\t\t\t\t\t\t\t\n\tstatic {\t\t\t\t\t\t\t\t\n     public int x;\t\t\t\t\t\t\t\n\t \t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  static {\n  }\n  public int x;\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  static {\n  }\n  public int x;\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unterminated static initializer with field declaration>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test56() {
        String s = "public class X \t\t\t\t\n\tstatic int zz\t\t\t\t\n\t{\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\n\tstatic {\t\t\t\t\t\n   public int x;\t\t\t\t\n\tint[] y = { 0, 1};\t\t\t\n\t{\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  static int zz;\n  {\n  }\n  static {\n  }\n  public int x;\n  int[] y = {0, 1};\n  {\n  }\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  static int zz;\n  {\n  }\n  static {\n  }\n  public int x;\n  int[] y = {0, 1};\n  {\n  }\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  static int zz;\n  {\n  }\n  static {\n  }\n  public int x;\n  int[] y;\n  {\n  }\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String testName = "<multiple initializers combined with array initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test57() {
        String s = "class X\t\t\t\t\t\t\n\tvoid foo(){\t\t\t\t\t\n\t\t{\t\t\t\t\t\t\n\tpublic static int x;\t\t\n\tvoid bar()\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\n\tint y;\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  public static int x;\n  int y;\n  X() {\n  }\n  <clinit>() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  public static int x;\n  int y;\n  X() {\n    super();\n  }\n  <clinit>() {\n  }\n  void foo() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<combination of unterminated methods and fields>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test58() {
        String s = "package p; \n\t\t\t\t\t\t\t\t\t\t\t\t\t\nclass A {\t\t\t\t\t\t\t\t\t\t\t\n\tvoid bar() {\t\t\t\t\t\t\t\t\t\n\t\tString s = \"\\u000D\";\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package p;\nclass A {\n  A() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package p;\nclass A {\n  A() {\n    super();\n  }\n  void bar() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<illegal unicode inside method body>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test59() {
        String s = "public class X extends java.io.IOException IOException  {\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X extends java.io.IOException {\n  {\n  }\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X extends java.io.IOException {\n  {\n  }\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<extra identifier in type signature>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test60() {
        String s = "public class X extends java.io.IOException  {\t\t\n\tint foo() ExtraIdentifier {\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X extends java.io.IOException {\n  public X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X extends java.io.IOException {\n  public X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<extra identifier in method signature>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test61() {
        String s = "public class X extends  {\t\t\t\t\t\t\t\n\tint foo() throws IOException ExtraIdentifier {\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  int foo() throws IOException {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  int foo() throws IOException {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<extra identifier behind thrown exception>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test62() {
        String s = "class X {\t\t\t\t\n class Y \t\t\t\t\n   public String s;\t\n   int foo(){\t\t\t\n\treturn 1;\t\t\t\n   static int y = {;\t\n }\t\t\t\t\t\t\n public int i = 0;\t\t\n \t\t\t\t\t\t\n int baz()\t\t\t\t\n\t\t\t\t\t\t\n}\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  class Y {\n    public String s;\n    static int y;\n    {\n    }\n    public int i = 0;\n    Y() {\n    }\n    <clinit>() {\n    }\n    int foo() {\n    }\n    int baz() {\n    }\n  }\n  X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  class Y {\n    public String s;\n    static int y;\n    {\n      ;\n    }\n    public int i = 0;\n    Y() {\n      super();\n    }\n    <clinit>() {\n    }\n    int foo() {\n      return 1;\n    }\n    int baz() {\n    }\n  }\n  X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "class X {\n  class Y {\n    public String s;\n    static int y;\n    {\n    }\n    public int i;\n    Y() {\n    }\n    <clinit>() {\n    }\n    int foo() {\n    }\n    int baz() {\n    }\n  }\n  X() {\n  }\n}\n";
        String testName = "<unterminated array initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test63() {
        String s = "class X {\t\t\t\t\n int x[] = {0, 1}\t\t\n {\t\t\t\t\t\t\n }\t\t\t\t\t\t\n}\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  int[] x = {0, 1};\n  {\n  }\n  X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  int[] x = {0, 1};\n  {\n  }\n  X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "class X {\n  int[] x;\n  {\n  }\n  X() {\n  }\n}\n";
        String testName = "<initializer behind array initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test64() {
        String s = "public class X \t\t\t\n\tint[] x = { 0, 1};\t\t\n\tstatic int zz\t\t\t\n\t{\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\n\tstatic {\t\t\t\t\n    public int x;\t\t\t\n\t{\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  int[] x = {0, 1};\n  static int zz;\n  {\n  }\n  static {\n  }\n  public int x;\n  {\n  }\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  int[] x = {0, 1};\n  static int zz;\n  {\n  }\n  static {\n  }\n  public int x;\n  {\n  }\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  int[] x;\n  static int zz;\n  {\n  }\n  static {\n  }\n  public int x;\n  {\n  }\n  public X() {\n  }\n  <clinit>() {\n  }\n}\n";
        String testName = "<initializers mixed with fields>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test65() {
        String s = "import java.lang.*;\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class Hanoi {\t\t\t\t\t\t\t\t\t\t\t\t\t\nprivate    Post[] posts;\t\t\t\t\t\t\t\t\t\t\t\t\npublic static void main (String args[]) {\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic void some(){\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nprivate void moveDisk (Post source, Post destination) {\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nprotected void reportMove (Post source, Post destination) {\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nprivate void reset () {\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic void solve () {\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nprivate void solve (int depth, Post start, Post free, Post end) {\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "import java.lang.*;\npublic class Hanoi {\n  private Post[] posts;\n  public Hanoi() {\n  }\n  public static void main(String[] args) {\n  }\n  public void some() {\n  }\n  private void moveDisk(Post source, Post destination) {\n  }\n  protected void reportMove(Post source, Post destination) {\n  }\n  private void reset() {\n  }\n  public void solve() {\n  }\n  private void solve(int depth, Post start, Post free, Post end) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "import java.lang.*;\npublic class Hanoi {\n  private Post[] posts;\n  public Hanoi() {\n    super();\n  }\n  public static void main(String[] args) {\n  }\n  public void some() {\n  }\n  private void moveDisk(Post source, Post destination) {\n  }\n  protected void reportMove(Post source, Post destination) {\n  }\n  private void reset() {\n  }\n  public void solve() {\n  }\n  private void solve(int depth, Post start, Post free, Post end) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find method behind some()>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test66() {
        String s = "class X {\t\t\t\n\tclass Y {\t\t\n\tX(int i){}\t\t\n}\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  class Y {\n    Y() {\n    }\n    X(int i) {\n    }\n  }\n  X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  class Y {\n    Y() {\n      super();\n    }\n    X(int i) {\n    }\n  }\n  X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should detect X(int) as a method with no return type>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test67() {
        String s = "class X {\t\t\t\n\tclass Y {\t\t\n\t}\t\t\t\t\n}\t\t\t\t\t\n\tX(int i){\t\t\n   }\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  class Y {\n    Y() {\n    }\n  }\n  {\n  }\n  X(int i) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  class Y {\n    Y() {\n      super();\n    }\n  }\n  {\n  }\n  X(int i) {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should detect orphan X(int) as a constructor>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test68() {
        String expectedDietUnitToString;
        String s = "";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<empty unit>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test69() {
        String expectedDietUnitToString;
        String s = "\tint foo(){\t\t\t\t\t\n\t\tSystem.out.println();\t\n\t}\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unit reduced to a method declaration>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test70() {
        String expectedDietUnitToString;
        String s = "\tX(){\t\t\t\t\t\t\n\t\tSystem.out.println();\t\n\t}\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unit reduced to a constructor declaration>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test71() {
        String expectedDietUnitToString;
        String s = "\tString str = new String();";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unit reduced to a field declaration>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test72() {
        String expectedDietUnitToString;
        String s = "\tString[] str = { \"hello\" };";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<unit reduced to a field declaration with array initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test73() {
        String s = "\tclass X {\t\t\t\n\t\tX(int i){}\t\t\n\t\tint foo(){\t\t\n\t\t\tnew X(\t\t\n";
        String expectedDietUnitToString = "class X {\n  X(int i) {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  X(int i) {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "class X {\n  X(int i) {\n    super();\n  }\n  int foo() {\n    new X();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not pick-up any constructor with no arg>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test74() {
        String s = "package pack;\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\nclass A extends IOException {\t\t\n\t\t\t\t\t\t\t\t\t\n\tS{\t\t\t\t\t\t\t\t\n\t\tint x;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package pack;\nclass A extends IOException {\n  {\n  }\n  A() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package pack;\nclass A extends IOException {\n  {\n    int x;\n  }\n  A() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not detect any field>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test75() {
        String s = "package ZKentTest;\n\nimport java.awt.color.*;\n\npublic class A {\n\tA foo(int i) { return this; }\n\tint[] ii = {0, 1clone()\n\n\tint bar() {\n\t\tclass Local {\n\t\t\tint hello(){\n\t\t\t\tfo\n\t\t\t}\n\t\t\tint world()\n\t\t\t}\n\tvoid foo() {\n\t\tba\t\t\n";
        String expectedDietUnitToString = "package ZKentTest;\nimport java.awt.color.*;\npublic class A {\n  int[] ii;\n  public A() {\n  }\n  A foo(int i) {\n  }\n  int bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package ZKentTest;\nimport java.awt.color.*;\npublic class A {\n  int[] ii;\n  public A() {\n    super();\n  }\n  A foo(int i) {\n    return this;\n  }\n  int bar() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package ZKentTest;\nimport java.awt.color.*;\npublic class A {\n  int[] ii;\n  public A() {\n    super();\n  }\n  A foo(int i) {\n    return this;\n  }\n  int bar() {\n    class Local {\n      Local() {\n        super();\n      }\n      int hello() {\n        fo = $missing$;\n      }\n      int world() {\n      }\n      void foo() {\n      }\n    }\n    int hello;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package ZKentTest;\nimport java.awt.color.*;\npublic class A {\n  int[] ii;\n  public A() {\n  }\n  A foo(int i) {\n  }\n  clone() {\n  }\n  int bar() {\n  }\n}\n";
        String testName = "<bunch of syntax errors>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test76() {
        String s = "package pack;\t\t\t\t\t\t\t\t\nclass A  {\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String[] argv)\t\n\t\t\tnew Member().f\t\t\t\t\t\n\t\t\t;\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n\tclass Member {\t\t\t\t\t\t\t\n\t\tint foo()\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n};\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package pack;\nclass A {\n  class Member {\n    Member() {\n    }\n    int foo() {\n    }\n  }\n  A() {\n  }\n  public static void main(String[] argv) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package pack;\nclass A {\n  class Member {\n    Member() {\n      super();\n    }\n    int foo() {\n    }\n  }\n  A() {\n    super();\n  }\n  public static void main(String[] argv) {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package pack;\nclass A {\n  class Member {\n    Member() {\n      super();\n    }\n    int foo() {\n    }\n  }\n  A() {\n    super();\n  }\n  public static void main(String[] argv) {\n    new Member().f = $missing$;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find Member as a member type>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test77() {
        String s = "package p;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nimport java.lang.*;\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nclass IncompleteHanoi {\t\t\t\t\t\t\t\t\t\t\t\t\nprivate    Post[] posts;\t\t\t\t\t\t\t\t\t\t\t\t\nprivate    int numberOfDisks;\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic Hanoi (int numberOfDisks) {\t\t\t\t\t\t\t\t\t\t\n this.numberOfDisks = numberOfDisks;\t\t\t\t\t\t\t\t\t\n'' this.posts = new Post[3];\t\t\t\t\t\t\t\t\t\t\t\n String[] postNames = new String[]{\"Left\", \"Middle\", \"Right\"};\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n for (int i = 0; i < 3; ++i)\t\t\t\t\t\t\t\t\t\t\t\n  this.posts[i] = new Post(postNames[i], numberOfDisks);\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\nprivate void solve (int depth, Post start, Post free, Post end) {\t\t\n if (depth == 1)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n  moveDisk(start, end);\t\t\t\t\t\t\t\t\t\t\t\t\n else if (depth > 1) {\t\t\t\t\t\t\t\t\t\t\t\t\t\n  sol\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package p;\nimport java.lang.*;\nclass IncompleteHanoi {\n  private Post[] posts;\n  private int numberOfDisks;\n  IncompleteHanoi() {\n  }\n  public Hanoi(int numberOfDisks) {\n  }\n  private void solve(int depth, Post start, Post free, Post end) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package p;\nimport java.lang.*;\nclass IncompleteHanoi {\n  private Post[] posts;\n  private int numberOfDisks;\n  IncompleteHanoi() {\n    super();\n  }\n  public Hanoi(int numberOfDisks) {\n  }\n  private void solve(int depth, Post start, Post free, Post end) {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "package p;\nimport java.lang.*;\nclass IncompleteHanoi {\n  private Post[] posts;\n  private int numberOfDisks;\n  IncompleteHanoi() {\n    super();\n  }\n  public Hanoi(int numberOfDisks) {\n  }\n  private void solve(int depth, Post start, Post free, Post end) {\n    if ((depth == 1))\n        moveDisk(start, end);\n    else\n        if ((depth > 1))\n            {\n              sol = $missing$;\n            }\n        else\n            ;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not recover duplicate field numberOfDisks>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test78() {
        String s = "class X {\t\t\t\t\t\t\t\t\n\tint foo(){\t\t\t\t\t\t\t\n\t\tVector v = new Vector();\t\t\n\t\ts\t\t\t\t\t\t\t\t\n\t\tv.addElement(\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "class X {\n  X() {\n    super();\n  }\n  int foo() {\n    Vector v = new Vector();\n    s v;\n    addElement();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not detect a field v>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test79() {
        String s = "class X {\t\t\t\t\t\t\t\t\n\tint foo(){\t\t\t\t\t\t\t\n\t\tVector v = new Vector();\t\t\n\t\tpublic s   v.addElement(\t\t\n\t}\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  X() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  X() {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "class X {\n  X() {\n    super();\n  }\n  int foo() {\n    Vector v = new Vector();\n    public s v;\n    addElement();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not detect a field v>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test80() {
        String s = "class X {\t\t\t\t\t\t\t\t\n\tint test(){\t\t\t\t\t\t\t\n\t\tint[] i;\t\t\t\t\t\t\n\t\ti\t\t\t\t\t\t\t\t\n\t\t// some comment\t\t\t\t\t\n\t\tbar(1);\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  X() {\n  }\n  int test() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  X() {\n    super();\n  }\n  int test() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "class X {\n  X() {\n    super();\n  }\n  int test() {\n    int[] i;\n    i bar = 1;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not detect a method bar>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test81() {
        String s = "\tclass X {\t\t\t\t\n\t\tX(int i){}\t\t\t\n\t\tint foo(){\t\t\t\n\t\t\tX(12)\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  X(int i) {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  X(int i) {\n    super();\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "class X {\n  X(int i) {\n    super();\n  }\n  int foo() {\n    X(12);\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not pick-up any constructor with no arg>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test82() {
        String s = "public class A {\t\t\n\t\t\t\t\t\t\n\tvoid foo() \t\t\t\n\t\tif (true) {\t\t\n\t\t} else {\t\t\n\t\t\tBar s; \t\t\n\t\t\ts.fred();\t\n\t\t}\t\t\t\t\n\t}\t\t\t\t\t\n}\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  void foo() {\n    if (true)\n        {\n        }\n    else\n        {\n          Bar s;\n          s.fred();\n        }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not promote message sending as a method>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test83() {
        String s = "public class A {\t\t\t\n\t\t\t\t\t\t\t\n\tvoid foo() if (true) {\t\n\t\t} else {\t\t\t\n\t\t\tBar s; \t\t\t\n\t\t\ts.fred();\t\t\n\t\t}\t\t\t\t\t\n\t}\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class A {\n  public A() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  public A() {\n    super();\n  }\n  void foo() {\n    if (true)\n        {\n        }\n    else\n        {\n          Bar s;\n          s.fred();\n        }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should not promote message sending as a method>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test84() {
        String s = "public class A extends\t\t\t\n\t\t\t\t\t\t\t\t\n\tstatic {\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class A {\n  static {\n  }\n  public A() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  static {\n  }\n  public A() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find a static initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test85() {
        String s = "public class A \t\t\t\n\t\t\t\t\t\t\t\n\tstatic {\t\t\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class A {\n  static {\n  }\n  public A() {\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  static {\n  }\n  public A() {\n    super();\n  }\n  <clinit>() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find a static initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test86() {
        String s = "public class A \t\t\t\n\t\t\t\t\t\t\t\n\tint \t\t\t\t\t\n\t{\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class A {\n  {\n  }\n  public A() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  {\n  }\n  public A() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find an initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test87() {
        String s = "public class A \t\t\t\n\t\t\t\t\t\t\t\n\tint x;\t\t\t\t\t\n  {\t\t\t\t\t\t\n\tint y;\t\t\t\t\t\n}\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class A {\n  int x;\n  {\n  }\n  public A() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  int x;\n  {\n    int y;\n  }\n  public A() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<should find an initializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test88() {
        String s = "package p1;\t\t\t\t\t\n\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\n\tint foo(String s, int x) \t\n\tpublic int y = new X() { \t\n\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "package p1;\npublic class X {\n  public int y;\n  public X() {\n  }\n  int foo(String s, int x) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package p1;\npublic class X {\n  public int y;\n  public X() {\n    super();\n  }\n  int foo(String s, int x) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "package p1;\npublic class X {\n  public int y;\n  public X() {\n  }\n  int foo(String s, int x) {\n  }\n}\n";
        String testName = "<1FVRQG0: ITPCOM:WINNT - NullPointerException in recovery mode>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test89() {
        String s = "import javax.servlet.*;\t\t\t\t\t\t\t\t\t\t\t\nimport javax.servlet.http.*;\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class Servlet1 extends HttpServlet {\t\t\t\t\t\t\n\tprotected (HttpServletRequest req, HttpServletResponse resp) {\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "import javax.servlet.*;\nimport javax.servlet.http.*;\npublic class Servlet1 extends HttpServlet {\n  HttpServletRequest req;\n  HttpServletRequest HttpServletResponse;\n  {\n  }\n  public Servlet1() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "import javax.servlet.*;\nimport javax.servlet.http.*;\npublic class Servlet1 extends HttpServlet {\n  HttpServletRequest req;\n  HttpServletRequest HttpServletResponse;\n  {\n  }\n  public Servlet1() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<1FVRN9V: ITPJCORE:WIN98 - Internal builder error compiling servlet>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test90() {
        String s = "public class Test {\t\n\t\t\t\t\t\t\n\tint x;\t\t\t\t\n\tint foo(\t\t\t\n\tint bar(\t\t\t\n\tbaz(A a\t\t\t\t\n}\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class Test {\n  int x;\n  public Test() {\n  }\n  int foo() {\n  }\n  int bar() {\n  }\n  baz(A a) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class Test {\n  int x;\n  public Test() {\n    super();\n  }\n  int foo() {\n  }\n  int bar() {\n  }\n  baz(A a) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<1FVXQZ4: ITPCOM:WIN98 - Walkback during parsing recovery>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test91() {
        String expectedDietUnitToString;
        String s = "public interface Fred {\t\t\n\tvoid foo();\t\t\t\t\t\n\tvoid bar();\t\t\t\t\t\n\tpublic fred(X x, int y);\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "public interface Fred {\n  void foo();\n  void bar();\n  public fred(X x, int y);\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<1FVXWKI: ITPCOM:WIN98 - Walkback when parsing a bogus interface>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test92() {
        String expectedDietUnitToString;
        String s = "public interface Test {\t\t\n\tvoid foo();\t\t\t\t\t\n\t\t\t\t\t\t\t\t\n\tpublic fred(Fred x, int y);\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "public interface Test {\n  void foo();\n  public fred(Fred x, int y);\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<1FVXWKI: ITPCOM:WIN98 - Walkback when parsing a bogus interface>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test93() {
        String s = "class X{\t\t\t\n\tint foo()\t\t\n\tstatic { }\t\t\n}\t\t\t\t\t\n";
        String expectedDietUnitToString = "class X {\n  static {\n  }\n  X() {\n  }\n  <clinit>() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  static {\n  }\n  X() {\n    super();\n  }\n  <clinit>() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<1FW5A4E: ITPCOM:WIN98 - Walkback reconciling>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test94() {
        String s = "public class X {\t\t\t\t\t\t\n\tint[] array;\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\nvoid foo() {\t\t\t\t\t\t\t\n\tbar(this.array.length, 10, fred(\t\n\t\t\t\t\t\t\t\t\t\t\nint fred(\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietUnitToString = "public class X {\n  int[] array;\n  public X() {\n  }\n  void foo() {\n  }\n  int fred() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  int[] array;\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n  int fred() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  int[] array;\n  public X() {\n    super();\n  }\n  void foo() {\n    bar(this.array.length, 10, fred());\n  }\n  int fred() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<1FW3663: ITPCOM:WIN98 - Outline - does not show method #fred()>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test95() {
        String expectedDietUnitToString;
        String s = "public interface IP {\t\t\t\n\tpublic static toString() {\t\n\t}\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\n";
        String expectedDietPlusBodyUnitToString = expectedDietUnitToString = "public interface IP {\n  public static toString() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<1FW6M5M: ITPJUI:ALL - NPE in SourceElementParser>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test96() {
        String s = "import ;\nclass X {\n\tint foo(){\n\t\tSystem.out.println();\n\t}\n\tstatic {\n\t\tint i = j;\n\t}\n}\n";
        String expectedDietUnitToString = "class X {\n  static {\n  }\n  X() {\n  }\n  <clinit>() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  static {\n    int i = j;\n  }\n  X() {\n    super();\n  }\n  <clinit>() {\n  }\n  int foo() {\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<1FWHXX7: ITPCOM:WINNT - ClassCastException compiling invalid import>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test97() {
        String s = "import ;\nclass X {\n\tint foo(){\n\t\tSystem.out.println();\n\t}\n\tstatic {\n\t}\n}\n";
        String expectedDietUnitToString = "class X {\n  static {\n  }\n  X() {\n  }\n  <clinit>() {\n  }\n  int foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  static {\n  }\n  X() {\n    super();\n  }\n  <clinit>() {\n  }\n  int foo() {\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<variation on 1FWHXX7: ITPCOM:WINNT - ClassCastException compiling invalid import>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test98() {
        String s = "public class A {\t\t                                                \n\tclass Platform {\t\t                                            \n\t\tpublic static void run(Runnable r) {\t\t                    \n\t\t}\t\t                                                        \n\t}\t\t\t                                                        \n\tObject [] array = null;\t\t                                        \n\tfor (int nX = 0; nX < array.length; nX ++) {\t\t                \n\t\tfinal String part = \"\";\t\t                                \n\t\tfinal String sel = \"\";\t\t                                \n\t\tObject l = null;\t\t                                        \n\t\tif ((part != null && sel != null) || l instanceof String) {\t\n\t\t\tPlatform.run(new Runnable() {\t\t                        \n\t\t\t\tpublic void run() {\t\t                                \n\t\t\t\t}\t\t                                                \n\t\t\t\tpublic void handleException(Throwable e) {\t\t        \n\t\t\t\t}\t\t                                                \n\t\t\t});\t\t                                                    \n\t\t}\t\t                                                        \n\t}\t\t                                                            \n}                                                                      \n";
        String expectedDietUnitToString = "public class A {\n  class Platform {\n    Platform() {\n    }\n    public static void run(Runnable r) {\n    }\n  }\n  Object[] array = null;\n  int nX = 0;\n  {\n  }\n  public A() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class A {\n  class Platform {\n    Platform() {\n      super();\n    }\n    public static void run(Runnable r) {\n    }\n  }\n  Object[] array = null;\n  int nX = 0;\n  {\n    final String part = \"\";\n    final String sel = \"\";\n    Object l = null;\n    if ((((part != null) && (sel != null)) || (l instanceof String)))\n        {\n          Platform.run(new Runnable() {\n  public void run() {\n  }\n  public void handleException(Throwable e) {\n  }\n});\n        }\n  }\n  public A() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class A {\n  class Platform {\n    Platform() {\n    }\n    public static void run(Runnable r) {\n    }\n  }\n  Object[] array;\n  int nX;\n  {\n  }\n  public A() {\n  }\n}\n";
        String testName = "<check for null inside RecoveredInitializer>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test99() {
        String s = "import ;\nclass X {\n}\n- public void addThreadFilter(IJavaThread thread) - restricts breakpoint to \ngiven thread and any other previously specified threads\n- public void removeThreadFilter(IJavaThread thread)- removes the given thread \nrestriction (will need to re-create breakpoint request as JDI does not support \nthe removal of thread filters)\n- public IJavaThread[] getThreadFilters() - return the set of threads this \nbreakpoint is currently restricted to\n";
        String expectedDietUnitToString = "class X {\n  {\n  }\n  X() {\n  }\n  public void addThreadFilter(IJavaThread thread) {\n  }\n  public void removeThreadFilter(IJavaThread thread) {\n  }\n  public IJavaThread[] getThreadFilters() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "class X {\n  {\n  }\n  X() {\n    super();\n  }\n  public void addThreadFilter(IJavaThread thread) {\n  }\n  public void removeThreadFilter(IJavaThread thread) {\n  }\n  public IJavaThread[] getThreadFilters() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "class X {\n  {\n  }\n  X() {\n    super();\n  }\n  public void addThreadFilter(IJavaThread thread) {\n    restricts breakpoint;\n    given thread;\n    any other;\n    specified = $missing$;\n  }\n  public void removeThreadFilter(IJavaThread thread) {\n    removes the;\n    thread restriction;\n    will need = (re - create);\n    request as;\n    does not;\n    the removal;\n    thread = $missing$;\n  }\n  public IJavaThread[] getThreadFilters() {\n    return the;\n    of threads;\n    breakpoint is;\n    restricted to;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<9101 - Parse error while typing in Java editor>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test100() {
        String s = "public class Bug {\n\tstatic boolean bold = false;\npublic static void main(String arguments[]) {\n\tShell shell = new Shell(SWT.MENU | SWT.RESIZE | SWT.TITLE | SWT.H_SCROLL);\n\tStyledText text = new StyledText(shell, SWT.WRAP); \n\tshell.addListener(SWT.Resize, new Listener() {\n\t\tpublic void handleEvent(Event e) {\n\t\t\ttext.setBounds(shell.getClientArea());\t\t\t \n\t\t}  \n\t});\t\n\tshell.addListener(SWT.KeyDown, bew Listener () {\n\t\tpublic void handleEvent(Event e) {\n\t\t\tbold = !bold;\n\t\t}\n\t}); \n\ttext.addLineStyleListener(new LineStyleListener() { \n\t\tpublic void lineGetStyle(LineStyleEvent event) {\n\t\t}\n\t});\n}\n}\n";
        String expectedDietUnitToString = "public class Bug {\n  static boolean bold = false;\n  <clinit>() {\n  }\n  public Bug() {\n  }\n  public static void main(String[] arguments) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class Bug {\n  static boolean bold = false;\n  <clinit>() {\n  }\n  public Bug() {\n    super();\n  }\n  public static void main(String[] arguments) {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class Bug {\n  static boolean bold = false;\n  <clinit>() {\n  }\n  public Bug() {\n    super();\n  }\n  public static void main(String[] arguments) {\n    Shell shell = new Shell((((SWT.MENU | SWT.RESIZE) | SWT.TITLE) | SWT.H_SCROLL));\n    StyledText text = new StyledText(shell, SWT.WRAP);\n    shell.addListener(SWT.Resize, new Listener() {\n  public void handleEvent(Event e) {\n    text.setBounds(shell.getClientArea());\n  }\n});\n    shell.addListener(SWT.KeyDown, new Listener() {\n  public void handleEvent(Event e) {\n    bold = (! bold);\n  }\n});\n    text.addLineStyleListener(new LineStyleListener() {\n  public void lineGetStyle(LineStyleEvent event) {\n  }\n});\n  }\n}\n";
        String expectedFullUnitToString = "public class Bug {\n  static boolean bold = false;\n  public Bug() {\n  }\n  <clinit>() {\n  }\n  public static void main(String[] arguments) {\n  }\n  bew Listener() {\n  }\n  public void handleEvent(Event e) {\n  }\n}\n";
        String expectedCompletionDietUnitToString = "public class Bug {\n  static boolean bold;\n  <clinit>() {\n  }\n  public Bug() {\n  }\n  public static void main(String[] arguments) {\n  }\n}\n";
        String testName = "<10616 - local type outside method>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void _test101() {
        String s = "public class X {\t\n    Object foo(Stack<X> s) {\t\n    }\t\n   List<T> bar(int pos, T x1, T x2, List<T> l) {\t\n    }\t\n}\t\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  Object foo() {\n  }\n  bar(int pos, T x1, T x2) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  Object foo() {\n  }\n  bar(int pos, T x1, T x2) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<12387 out of memory with generics>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test102() {
        String s = "void ___eval() {\t\nnew Runnable(){\t\nvoid ___run() throws Throwable {\t\nreturn blah;\t\n}\t\nprivate String blarg;\t\npublic void run (){\t\n\t\tclass Local { \n\t\t\tvoid baz() {\t\n\t\t\t}\t\n\t\t} \t\n}\t\n}\t\n;}\t\npublic class Hello{\t\nprivate static int x;\t\nprivate String blah;\t\npublic static void main (String[] args){\t\n}\t\npublic void hello (){\t\n}\t\npublic boolean blah (){\t\nreturn false;}\t\npublic void foo (){\t\n}\t\n}\t\n";
        String expectedDietUnitToString = "public class Hello {\n  private static int x;\n  private String blah;\n  public Hello() {\n  }\n  <clinit>() {\n  }\n  public static void main(String[] args) {\n  }\n  public void hello() {\n  }\n  public boolean blah() {\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class Hello {\n  private static int x;\n  private String blah;\n  public Hello() {\n    super();\n  }\n  <clinit>() {\n  }\n  public static void main(String[] args) {\n  }\n  public void hello() {\n  }\n  public boolean blah() {\n    return false;\n  }\n  public void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<12454 - handling toplevel anonymous>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test103() {
        String s = "public class X{\t\n   void foo(int x, int y, void z";
        String expectedDietUnitToString = "public class X {\n  void z;\n  public X() {\n  }\n  void foo(int x, int y) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  void z;\n  public X() {\n    super();\n  }\n  void foo(int x, int y) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<14038 - third argument type is void>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test104() {
        String s = "public class P#AField {\n\tpublic void setP#A(String P#A) {\n\t\tthis.P#A = P#A;\n\t}\n}";
        String expectedDietUnitToString = "public class P {\n  {\n  }\n  public void setP;\n  public P() {\n  }\n  A(String P) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class P {\n  {\n  }\n  public void setP;\n  public P() {\n    super();\n  }\n  A(String P) {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "<16126>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test105() {
        String s = "public class X {\n\tstatic int foo(int[] a, int[] b) {\n\t\treturn 0;\n\t}\n\tstatic int B =\n\t\tfoo(\n\t\t\tnew int[]{0, 0},\n\t\t\tnew int[]{0, 0}\n\t\t);\n\t#\n";
        String expectedDietUnitToString = "public class X {\n  static int B = foo(new int[]{0, 0}, new int[]{0, 0});\n  public X() {\n  }\n  <clinit>() {\n  }\n  static int foo(int[] a, int[] b) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  static int B = foo(new int[]{0, 0}, new int[]{0, 0});\n  public X() {\n    super();\n  }\n  <clinit>() {\n  }\n  static int foo(int[] a, int[] b) {\n    return 0;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  static int B;\n  {\n  }\n  {\n  }\n  public X() {\n  }\n  <clinit>() {\n  }\n  static int foo(int[] a, int[] b) {\n  }\n}\n";
        String testName = "";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test106() {
        String expectedDietPlusBodyUnitToString;
        String s = "public class X {\n  clon\n  foo();\n}\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  clon foo();\n}\n";
        String expectedFullUnitToString = expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  clon foo();\n}\n";
        String expectedCompletionDietUnitToString = "public class X {\n  public X() {\n  }\n  clon foo();\n}\n";
        String testName = "";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test107() {
        String s = "public class X {\n\tint[] a = new int[]{0, 0}, b = new int[]{0, 0};\n\t#\n";
        String expectedDietUnitToString = "public class X {\n  int[] a = new int[]{0, 0};\n  int[] b = new int[]{0, 0};\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  int[] a = new int[]{0, 0};\n  int[] b = new int[]{0, 0};\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  int[] a;\n  int[] b;\n  public X() {\n  }\n}\n";
        String testName = "";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test108() {
        String s = "public class X {\n\tint a = new int[]{0, 0}, b = new int[]{0, 0};\n\t#\n";
        String expectedDietUnitToString = "public class X {\n  int a = new int[]{0, 0};\n  int b = new int[]{0, 0};\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  int a = new int[]{0, 0};\n  int b = new int[]{0, 0};\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  int a;\n  {\n  }\n  {\n  }\n  public X() {\n  }\n}\n";
        String testName = "";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test109() {
        String s = "public class X {\n\tObject o = new Object() {\n\t\tvoid foo() {\n\t\t\ttry {\n\t\t\t} catch(Exception e) {\n\t\t\t\te.\n\t\t\t}\n\t\t}\n\t};\n}";
        String expectedDietUnitToString = "public class X {\n  Object o;\n  public X() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  Object o;\n  public X() {\n    super();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  Object o;\n  public X() {\n  }\n}\n";
        String testName = "";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test110() {
        String s = "public class X {\n\tvoid bar(){\n\t\t#\n\t\tclass Inner {\n\t\t\tvoid foo() {\n\t\t\t\ttry {\n\t\t\t\t} catch(Exception e) {\n\t\t\t\t\te.\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void bar() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void bar() {\n    class Inner {\n      Inner() {\n        super();\n      }\n      void foo() {\n        try \n          {\n          }\n        catch (Exception e)           {\n          }\n      }\n    }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = "public class X {\n  public X() {\n  }\n  void bar() {\n  }\n}\n";
        String testName = "";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test111() {
        String s = "public class X {\n\tvoid bar(){\n\t}\n\t}\n\tvoid foo() {\n\t}\n}";
        String expectedDietUnitToString = "public class X {\n  {\n  }\n  public X() {\n  }\n  void bar() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  {\n  }\n  public X() {\n    super();\n  }\n  void bar() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test112() {
        String s = "public class X {\n  public void foo()\n    try {\t\t\t\n    }  catch (Exception e) {\n     bar(\"blabla\");\n      throw new Exception(prefix  \"bloblo\");\n    }\n  }\n}\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  public void foo() {\n    try \n      {\n      }\n    catch (Exception e)       {\n        bar(\"blabla\");\n        throw new Exception(prefix);\n      }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test113() {
        String s = "public class X {\n  public void foo(Object[] tab)\n    for (Object o : tab) {\n\t\to.toString();\n\t }\n  }\n}\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  public void foo(Object[] tab) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  public void foo(Object[] tab) {\n    for (Object o : tab) \n      {\n        o.toString();\n      }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test114() {
        String s = "public class X {\n  public void foo() {\n    int int;\n  }\n}\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  public void foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  public void foo() {\n    int $missing$;\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test115() {
        String s = "public interface Test {\n  public void myMethod()\n}\n";
        String expectedDietUnitToString = "public interface Test {\n  public void myMethod() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public interface Test {\n  public void myMethod() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public interface Test {\n  public void myMethod() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test116() {
        String s = "public interface Test {\n  public void myMethod()\n    System.out.println();\n}\n";
        String expectedDietUnitToString = "public interface Test {\n  public void myMethod() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public interface Test {\n  public void myMethod() {\n    System.out.println();\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public interface Test {\n  public void myMethod() {\n    System.out.println();\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test117() {
        String s = "public class X {\n\tvoid foo1() {\n\t\tclass Y  {\n\t\t}\n\t\tvoid foo2() {\n\t\t}\n\t\tclass Z<T> { \n\t\t}\n\t}\n} \n";
        String expectedDietUnitToString = null;
        String expectedDietPlusBodyUnitToString = null;
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = null;
        String expectedFullUnitToString = null;
        String expectedCompletionDietUnitToString = null;
        if ("1.3".equals(this.complianceLevel) || "1.4".equals(this.complianceLevel)) {
            expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  void foo1() {\n  }\n}\n";
            expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo1() {\n  }\n}\n";
            expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo1() {\n    class Y {\n      Y() {\n        super();\n      }\n    }\n    class Z<T> {\n      Z() {\n        super();\n      }\n    }\n  }\n}\n";
            expectedFullUnitToString = "public class X {\n  class Z<T> {\n    Z() {\n    }\n  }\n  public X() {\n  }\n  void foo1() {\n  }\n  void foo2() {\n  }\n}\n";
            expectedCompletionDietUnitToString = expectedDietUnitToString;
        } else if (this.complianceLevel.compareTo("1.5") >= 0) {
            expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  void foo1() {\n  }\n}\n";
            expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo1() {\n  }\n}\n";
            expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo1() {\n    class Y {\n      Y() {\n        super();\n      }\n    }\n    new foo2() {\n    };\n    class Z<T> {\n      Z() {\n        super();\n      }\n    }\n  }\n}\n";
            expectedFullUnitToString = "public class X {\n  class Z<T> {\n    Z() {\n    }\n  }\n  public X() {\n  }\n  void foo1() {\n  }\n  void foo2() {\n  }\n}\n";
            expectedCompletionDietUnitToString = expectedDietUnitToString;
        }
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test117_2() {
        String s = "public class X {\n\tvoid foo1() {\n\t\tclass Y  {\n\t\t}\n\t\tvoid foo2() {\n\t\t}\n\t\tclass Z { \n\t\t}\n\t}\n} \n";
        String expectedDietUnitToString = null;
        String expectedDietPlusBodyUnitToString = null;
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = null;
        String expectedFullUnitToString = null;
        String expectedCompletionDietUnitToString = null;
        expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  void foo1() {\n  }\n}\n";
        expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo1() {\n  }\n}\n";
        expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo1() {\n    class Y {\n      Y() {\n        super();\n      }\n    }\n    new foo2() {\n    };\n    class Z {\n      Z() {\n        super();\n      }\n    }\n  }\n}\n";
        expectedFullUnitToString = "public class X {\n  class Z {\n    Z() {\n    }\n  }\n  public X() {\n  }\n  void foo1() {\n  }\n  void foo2() {\n  }\n}\n";
        expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test118() {
        String expectedDietPlusBodyUnitToString;
        String s = "interface Irrelevant {}\ninterface I {\n\tObject foo(Number n);\n}\ninterface J extends I {\n\tString foo(Number n);\n}\ninterface K {\n\tObject foo(Number n);\n}\npublic class  {\n\tvoid foo() {\n\n\t}\n} \n";
        String expectedDietUnitToString = "interface Irrelevant {\n}\ninterface I {\n  Object foo(Number n);\n}\ninterface J extends I {\n  String foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = expectedDietPlusBodyUnitToString = "interface Irrelevant {\n}\ninterface I {\n  Object foo(Number n);\n}\ninterface J extends I {\n  String foo(Number n);\n}\ninterface K {\n  Object foo(Number n);\n  void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test119() {
        String expectedDietPlusBodyUnitToString;
        String s = "interface Irrelevant {}\ninterface I {\n\tObject foo(Number n);\n}\ninterface J extends I {\n\tString foo(Number n);\n}\nabstract class K {\n\tabstract Object foo(Number n);\n}\npublic class  {\n\tvoid foo() {\n\n\t}\n} \n";
        String expectedDietUnitToString = "interface Irrelevant {\n}\ninterface I {\n  Object foo(Number n);\n}\ninterface J extends I {\n  String foo(Number n);\n}\nabstract class K {\n  {\n  }\n  K() {\n  }\n  abstract Object foo(Number n);\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = expectedDietPlusBodyUnitToString = "interface Irrelevant {\n}\ninterface I {\n  Object foo(Number n);\n}\ninterface J extends I {\n  String foo(Number n);\n}\nabstract class K {\n  {\n  }\n  K() {\n    super();\n  }\n  abstract Object foo(Number n);\n  void foo() {\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test120() {
        String s = "public class X {\n  void foo() {\n    #\n    try {\n      System.out.println(); \n    } catch (Exception e) {\n    }\n    class Z {}\n }\n}\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    try \n      {\n        System.out.println();\n      }\n    catch (Exception e)       {\n      }\n    class Z {\n      Z() {\n        super();\n      }\n    }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test121() {
        String s = "public class X {\n  void foo() {\n    #\n    try {\n      System.out.println(); \n    } catch (Exception e) {\n      class Z {}\n    }\n }\n}\n";
        String expectedDietUnitToString = "public class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    try \n      {\n        System.out.println();\n      }\n    catch (Exception e)       {\n        class Z {\n          Z() {\n            super();\n          }\n        }\n      }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test122() {
        String s = "public class Test\n{\n  public void func1()\n  {\n    try\n    {\n    catch ( Exception exception)\n    {\n      exception.printStackTrace();\n    }\n  }\n\n  class Clazz\n  {\n  }\n}\n\n";
        String expectedDietUnitToString = "public class Test {\n  public Test() {\n  }\n  public void func1() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class Test {\n  public Test() {\n    super();\n  }\n  public void func1() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class Test {\n  public Test() {\n    super();\n  }\n  public void func1() {\n    try \n      {\n      }\n    catch (Exception exception)       {\n        exception.printStackTrace();\n      }\n    class Clazz {\n      Clazz() {\n        super();\n      }\n    }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test123() {
        String s = "public class SwitchBug {\n       void aMethod() {\n               int i=0;\n               try {\n                        switch( i ) {\n                } catch( Exception ex ) {\n                }\n        }\n        class Nested {\n        }\n}\n";
        String expectedDietUnitToString = "public class SwitchBug {\n  public SwitchBug() {\n  }\n  void aMethod() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class SwitchBug {\n  public SwitchBug() {\n    super();\n  }\n  void aMethod() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "public class SwitchBug {\n  public SwitchBug() {\n    super();\n  }\n  void aMethod() {\n    int i = 0;\n    try \n      {\n        switch (i) {\n        }\n      }\n    catch (Exception ex)       {\n      }\n    class Nested {\n      Nested() {\n        super();\n      }\n    }\n  }\n}\n";
        String expectedFullUnitToString = expectedDietUnitToString;
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test foreach toString";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }

    public void test124() {
        String s = "public class Test {\n\tvoid aMethod() {\n\t\tpublic static void m1()\n\t\t{\n\t\t\tint a;\n\t\t\tint b;\n\t\t}\n\t\tpublic static void m2()\n\t\t{\n\t\t\tint c;\n\t\t\tint d;\n\t\t}\n\t}\n}\n";
        String expectedDietUnitToString = "public class Test {\n  public Test() {\n  }\n  void aMethod() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class Test {\n  public Test() {\n    super();\n  }\n  void aMethod() {\n  }\n}\n";
        String expectedDietPlusBodyPlusStatementsRecoveryUnitToString = null;
        expectedDietPlusBodyPlusStatementsRecoveryUnitToString = "1.3".equals(this.complianceLevel) || "1.4".equals(this.complianceLevel) ? "public class Test {\n  public Test() {\n    super();\n  }\n  void aMethod() {\n    m1();\n    {\n      int a;\n      int b;\n    }\n    m2();\n    {\n      int c;\n      int d;\n    }\n  }\n}\n" : "public class Test {\n  public Test() {\n    super();\n  }\n  void aMethod() {\n    public static @m1() enum $missing$ {\n      public $missing$() {\n        super();\n      }\n      <clinit>() {\n      }\n    }\n  }\n}\n";
        String expectedFullUnitToString = "public class Test {\n  public Test() {\n  }\n  void aMethod() {\n  }\n  public static void m1() {\n  }\n  public static void m2() {\n  }\n}\n";
        String expectedCompletionDietUnitToString = expectedDietUnitToString;
        String testName = "test";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyPlusStatementsRecoveryUnitToString, expectedFullUnitToString, expectedCompletionDietUnitToString, testName);
    }
}

