/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclItemImpl;
import org.eclipse.wst.css.core.internal.document.CSSStyleDeclarationImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;

public abstract class CSSStyleDeclarationFactoryContext {
    protected ICSSDocument fOwnerDocument = null;

    protected void cloneChildNodes(ICSSNode src, ICSSNode dest) {
        if (this.fOwnerDocument == null) {
            return;
        }
        if (!(dest instanceof CSSNodeImpl)) {
            return;
        }
        CSSNodeImpl container = (CSSNodeImpl)dest;
        container.removeChildNodes();
        ICSSNode child = src.getFirstChild();
        while (child != null) {
            ICSSNode cloned;
            if (child instanceof CSSStyleDeclItemImpl) {
                cloned = child.cloneNode(false);
                if (cloned instanceof CSSNodeImpl) {
                    ((CSSNodeImpl)cloned).setOwnerDocument(this.fOwnerDocument);
                    container.appendChild((CSSNodeImpl)cloned);
                    this.cloneChildNodes(child, cloned);
                }
            } else {
                cloned = child.cloneNode(false);
                if (cloned instanceof CSSNodeImpl) {
                    ((CSSNodeImpl)cloned).setOwnerDocument(this.fOwnerDocument);
                    container.appendChild((CSSNodeImpl)cloned);
                    this.cloneChildNodes(child, cloned);
                }
            }
            child = child.getNextSibling();
        }
    }

    public ICSSStyleDeclaration createStyleDeclaration() {
        CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(true);
        decl.setOwnerDocument(decl);
        return decl;
    }
}

