/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.webxml;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.internal.impl.WebAppImpl;
import org.eclipse.jst.jsf.common.webxml.internal.AbstractWebXmlUpdater;
import org.eclipse.jst.jsf.common.webxml.internal.WebXmlUpdaterForJ2EE;
import org.eclipse.jst.jsf.common.webxml.internal.WebXmlUpdaterForJavaEE;

public class WebXmlUpdater {
    private final IProject project;
    private final IProgressMonitor monitor;
    private final AbstractWebXmlUpdater updater;
    private final IModelProvider provider;

    public WebXmlUpdater(IProject project, IProgressMonitor monitor) {
        this.project = project;
        this.monitor = monitor;
        this.provider = ModelProviderManager.getModelProvider((IProject)project);
        this.updater = this.initUpdater();
    }

    public IModelProvider getProvider() {
        return this.provider;
    }

    public boolean isJavaEEWebapp() {
        return this.updater instanceof WebXmlUpdaterForJavaEE;
    }

    public boolean isJ2EEWebapp() {
        return this.updater instanceof WebXmlUpdaterForJ2EE;
    }

    public void addServlet(String servletName, String servletClass, String loadOnStartup) {
        this.updater.addServlet(servletName, servletClass, loadOnStartup);
    }

    public void removeServlet(String servletClassName) {
        this.updater.removeServlet(servletClassName);
    }

    public void addServletMapping(String servletName, String servletClass, String urlPattern) {
        this.updater.addServletMapping(servletName, servletClass, urlPattern);
    }

    public void addFilter(String filterName, String filterClass) {
        this.updater.addFilter(filterName, filterClass);
    }

    public void removeFilter(String filterName) {
        this.updater.removeFilter(filterName);
    }

    public void addFilterMapping(String filterName, String filterClass, String servletName) {
        this.updater.addFilterMapping(filterName, filterClass, servletName);
    }

    public void addContextParam(String paramName, String paramValue, String description) {
        this.updater.addContextParam(paramName, paramValue, description);
    }

    public void addListener(String listenerClass) {
        this.updater.addListener(listenerClass);
    }

    private AbstractWebXmlUpdater initUpdater() {
        Object webAppObj = ModelProviderManager.getModelProvider((IProject)this.project).getModelObject();
        if (webAppObj != null) {
            if (webAppObj instanceof WebAppImpl) {
                return new WebXmlUpdaterForJavaEE(webAppObj, this.project, this.getProvider(), this.monitor);
            }
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.internal.impl.WebAppImpl) {
                return new WebXmlUpdaterForJ2EE(webAppObj, this.project, this.getProvider(), this.monitor);
            }
        }
        throw new IllegalArgumentException("Unable to resolve WebApp object for updating web.xml");
    }
}

