/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.jsf.common.internal.ITestTracker;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ImmutableLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleListener
extends ImmutableLifecycleListener
implements IResourceChangeListener {
    private static boolean ENABLE_TEST_TRACKING = false;
    private static long _seqId;
    private final CopyOnWriteArrayList<IResource> _resources;
    final CopyOnWriteArrayList<IResourceLifecycleListener> _listeners;
    private AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private ITestTracker _testTracker;

    public LifecycleListener() {
        this._resources = new CopyOnWriteArrayList();
        this._listeners = new CopyOnWriteArrayList();
    }

    public LifecycleListener(IResource res) {
        this();
        this._resources.add(res);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public LifecycleListener(List<IResource> resources) {
        this();
        this._resources.addAll(resources);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public final void setTestTracker(ITestTracker testTracker) {
        this._testTracker = testTracker;
    }

    protected final void setEnableTracing(boolean newValue) {
        ENABLE_TEST_TRACKING = newValue;
    }

    @Override
    public void addListener(IResourceLifecycleListener listener) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this._listeners.addIfAbsent(listener);
    }

    @Override
    public void removeListener(IResourceLifecycleListener listener) {
        if (this.isDisposed()) {
            throw new IllegalStateException();
        }
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(IResource res) {
        CopyOnWriteArrayList<IResource> copyOnWriteArrayList = this._resources;
        synchronized (copyOnWriteArrayList) {
            if (this.isDisposed()) {
                return;
            }
            int preSize = this._resources.size();
            if (!this._resources.contains(res)) {
                this._resources.add(res);
            }
            if (preSize == 0 && this._resources.size() > 0) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(IResource res) {
        CopyOnWriteArrayList<IResource> copyOnWriteArrayList = this._resources;
        synchronized (copyOnWriteArrayList) {
            if (this.isDisposed()) {
                return;
            }
            this._resources.remove(res);
            if (this._resources.size() == 0) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            CopyOnWriteArrayList<IResource> copyOnWriteArrayList = this._resources;
            synchronized (copyOnWriteArrayList) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                this._resources.clear();
            }
        }
    }

    public boolean isDisposed() {
        return this._isDisposed.get();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        long seqId = _seqId++;
        if (this._testTracker != null && ENABLE_TEST_TRACKING) {
            this._testTracker.fireEvent(ITestTracker.Event.START_TRACKING, seqId, "trackMethod_resourceChanged");
        }
        assert (!this.isDisposed());
        switch (event.getType()) {
            case 2: {
                IProject proj = (IProject)event.getResource();
                for (IResource res : this._resources) {
                    if (proj != res && proj != res.getProject()) continue;
                    this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED));
                }
                break;
            }
            case 4: {
                IProject proj = (IProject)event.getResource();
                for (IResource res : this._resources) {
                    if (proj == res) {
                        this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED));
                        continue;
                    }
                    if (proj != res.getProject()) continue;
                    this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_DELETED));
                }
                break;
            }
            case 1: {
                for (IResource res : this._resources) {
                    IResourceDelta delta = event.getDelta();
                    if ((delta = delta.findMember(res.getFullPath())) == null) continue;
                    this.visit(delta);
                }
                break;
            }
        }
        if (ENABLE_TEST_TRACKING && this._testTracker != null) {
            this._testTracker.fireEvent(ITestTracker.Event.STOP_TRACKING, seqId, "trackMethod_resourceChanged");
        }
    }

    private void fireLifecycleEvent(ResourceLifecycleEvent event) {
        boolean disposeAfter = false;
        for (IResourceLifecycleListener listener : this._listeners) {
            IResourceLifecycleListener.EventResult result = listener.acceptEvent(event);
            disposeAfter |= result.getDisposeAfterEvent();
        }
        if (disposeAfter) {
            this.dispose();
        }
    }

    private void visit(IResourceDelta delta) {
        assert (!this.isDisposed());
        IResource res = delta.getResource();
        if (res.getType() == 8) {
            this.handleWorkspaceRoot(delta);
        }
        switch (delta.getKind()) {
            case 4: {
                if ((delta.getFlags() & 0x100) == 0) break;
                this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_CHANGED, ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS));
                break;
            }
            case 2: {
                this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED));
            }
        }
    }

    private void handleWorkspaceRoot(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(1);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            IResource res = childDelta.getResource();
            if ((childDelta.getFlags() & 0x4000) != 0 && res.getType() == 4) {
                this.fireLifecycleEvent(new ResourceLifecycleEvent(res, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.PROJECT_OPENED));
            }
            ++n2;
        }
    }
}

