/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyWritablePropertyValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class ReadOnlyWritablePropertyValueModelWrapperTests
extends TestCase {
    private WritablePropertyValueModel<String> objectHolder;
    private PropertyChangeEvent event;
    private WritablePropertyValueModel<String> wrapperObjectHolder;
    private PropertyChangeEvent wrapperEvent;

    public ReadOnlyWritablePropertyValueModelWrapperTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.objectHolder = new SimplePropertyValueModel((Object)"foo");
        this.wrapperObjectHolder = new ReadOnlyWritablePropertyValueModelWrapper(this.objectHolder);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testValue() {
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.wrapperObjectHolder.getValue()));
        this.objectHolder.setValue((Object)"bar");
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"bar", (String)((String)this.wrapperObjectHolder.getValue()));
        this.objectHolder.setValue(null);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertNull((Object)this.objectHolder.getValue());
        ReadOnlyWritablePropertyValueModelWrapperTests.assertNull((Object)this.wrapperObjectHolder.getValue());
        this.objectHolder.setValue((Object)"foo");
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.wrapperObjectHolder.getValue()));
    }

    public void testSetValue() {
        boolean exceptionOccurred = false;
        try {
            this.wrapperObjectHolder.setValue((Object)"bar");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exceptionOccurred = true;
        }
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)exceptionOccurred);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"foo", (String)((String)this.wrapperObjectHolder.getValue()));
    }

    public void testLazyListening() {
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        PropertyChangeListener listener = this.buildWrapperListener();
        this.wrapperObjectHolder.addPropertyChangeListener(listener);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.wrapperObjectHolder.removePropertyChangeListener(listener);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
        this.wrapperObjectHolder.addPropertyChangeListener("value", listener);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasAnyPropertyChangeListeners("value"));
        this.wrapperObjectHolder.removePropertyChangeListener("value", listener);
        ReadOnlyWritablePropertyValueModelWrapperTests.assertTrue((boolean)((AbstractModel)this.objectHolder).hasNoPropertyChangeListeners("value"));
    }

    public void testPropertyChange1() {
        this.objectHolder.addPropertyChangeListener(this.buildListener());
        this.wrapperObjectHolder.addPropertyChangeListener(this.buildWrapperListener());
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        this.objectHolder.addPropertyChangeListener("value", this.buildListener());
        this.wrapperObjectHolder.addPropertyChangeListener("value", this.buildWrapperListener());
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.event = null;
        this.wrapperEvent = null;
        this.objectHolder.setValue((Object)"bar");
        this.verifyEvent(this.event, this.objectHolder, "foo", "bar");
        this.verifyEvent(this.wrapperEvent, this.wrapperObjectHolder, "foo", "bar");
        this.event = null;
        this.wrapperEvent = null;
        this.objectHolder.setValue(null);
        this.verifyEvent(this.event, this.objectHolder, "bar", null);
        this.verifyEvent(this.wrapperEvent, this.wrapperObjectHolder, "bar", null);
        this.event = null;
        this.wrapperEvent = null;
        this.objectHolder.setValue((Object)"foo");
        this.verifyEvent(this.event, this.objectHolder, null, "foo");
        this.verifyEvent(this.wrapperEvent, this.wrapperObjectHolder, null, "foo");
    }

    private PropertyChangeListener buildListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                ReadOnlyWritablePropertyValueModelWrapperTests.this.event = e;
            }
        };
    }

    private PropertyChangeListener buildWrapperListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                ReadOnlyWritablePropertyValueModelWrapperTests.this.wrapperEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent e, Object source, Object oldValue, Object newValue) {
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((Object)source, (Object)e.getSource());
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((String)"value", (String)e.getPropertyName());
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((Object)oldValue, (Object)e.getOldValue());
        ReadOnlyWritablePropertyValueModelWrapperTests.assertEquals((Object)newValue, (Object)e.getNewValue());
    }
}

