/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal2.ORMGenColumn;
import org.eclipse.jpt.gen.internal2.ORMGenCustomizer;
import org.eclipse.jpt.gen.internal2.ORMGenTable;
import org.eclipse.jpt.gen.internal2.util.DTPUtil;
import org.eclipse.jpt.ui.CommonImages;
import org.eclipse.jpt.ui.internal.wizards.gen.ColumnGenPanel;
import org.eclipse.jpt.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.ui.internal.wizards.gen.SWTUtil;
import org.eclipse.jpt.ui.internal.wizards.gen.TableGenPanel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class TablesAndColumnsCustomizationWizardPage
extends NewTypeWizardPage {
    private JpaProject jpaProject;
    private TreeViewer tableColumnTreeViewer;
    private Composite detailPanel;
    private StackLayout detailPanelStatckLayout;
    private Composite tableGenDetatilGroup;
    private ColumnGenPanel columnGenPanel;
    private Composite columnGenDetatilGroup;
    private TableGenPanel tableGenPanel;
    private ORMGenTable selectedTable;
    private ORMGenCustomizer customizer;

    protected TablesAndColumnsCustomizationWizardPage(JpaProject jpaProject) {
        super(true, "TablesAndColumnsCustomizationWizardPage");
        this.jpaProject = jpaProject;
        this.setTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_tablesAndColumnsPage_title);
        this.setMessage(JptUiEntityGenMessages.GenerateEntitiesWizard_tablesAndColumnsPage_desc);
    }

    void init(IStructuredSelection selection) {
        if (this.jpaProject != null) {
            IJavaProject jelem = this.jpaProject.getJavaProject();
            this.initContainerPage((IJavaElement)jelem);
            this.initTypePage((IJavaElement)jelem);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 1;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.dialog_customizeIndividualEntities");
        this.createTableAndColumnsListPanel(composite, 1);
        SWTUtil.createLabel(composite, 1, "");
        SWTUtil.createSeparator(composite, 1);
        this.createGenerateDetailGroup(composite, 1);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    private void createTableAndColumnsListPanel(Composite parent, int columns) {
        Label label = new Label(parent, columns);
        label.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_tablesAndColumnsPage_labelTableAndColumns);
        SWTUtil.fillColumns((Control)label, columns);
        GridData data = new GridData();
        data.horizontalSpan = columns;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 200;
        data.grabExcessVerticalSpace = true;
        this.tableColumnTreeViewer = new TreeViewer(parent);
        this.tableColumnTreeViewer.getTree().setLayoutData((Object)data);
        this.tableColumnTreeViewer.setContentProvider((IContentProvider)new TableColumnTreeContentProvider());
        this.tableColumnTreeViewer.setLabelProvider((IBaseLabelProvider)new TableColumnTreeLabelProvider());
        this.tableColumnTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TablesAndColumnsCustomizationWizardPage.this.updateDetailPanel(event.getSelection());
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ORMGenCustomizer customizer = this.getCustomizer();
            if (this.customizer != customizer) {
                this.customizer = customizer;
                this.tableColumnTreeViewer.setInput((Object)customizer);
            } else {
                this.tableColumnTreeViewer.refresh();
            }
            List tableNames = this.customizer.getTableNames();
            ORMGenTable ormGenTable = this.customizer.getTable((String)tableNames.get(0));
            this.updateTabelGenDetail(ormGenTable);
        }
    }

    private void updateDetailPanel(ISelection selection) {
        TreeSelection ts = (TreeSelection)selection;
        Object selectedObject = ts.getFirstElement();
        if (selectedObject instanceof ORMGenTable) {
            this.updateTabelGenDetail((ORMGenTable)selectedObject);
        } else if (selectedObject instanceof ORMGenColumn) {
            this.updateColumnGenDetail((ORMGenColumn)selectedObject);
        }
    }

    private void updateColumnGenDetail(ORMGenColumn column) {
        if (this.columnGenDetatilGroup == null) {
            this.columnGenDetatilGroup = new Composite(this.detailPanel, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            this.columnGenDetatilGroup.setLayout((Layout)gridLayout);
            this.columnGenPanel = new ColumnGenPanel(this.columnGenDetatilGroup, 4, this.getCustomizer(), (WizardPage)this);
        }
        this.columnGenPanel.setColumn(column);
        this.detailPanelStatckLayout.topControl = this.columnGenDetatilGroup;
        this.detailPanel.layout();
        this.detailPanel.getParent().layout();
    }

    private void updateTabelGenDetail(ORMGenTable table) {
        this.selectedTable = table;
        if (this.tableGenDetatilGroup == null) {
            this.tableGenDetatilGroup = new Composite(this.detailPanel, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            this.tableGenDetatilGroup.setLayout((Layout)gridLayout);
            this.tableGenPanel = new TableGenPanel(this.tableGenDetatilGroup, 4, false, (WizardPage)this);
            this.createDomainJavaClassesPropertiesGroup(this.tableGenDetatilGroup, 4);
        }
        this.tableGenPanel.setORMGenTable(table);
        this.detailPanelStatckLayout.topControl = this.tableGenDetatilGroup;
        this.detailPanel.layout();
        String baseClass = table.getExtends();
        if (baseClass != null) {
            this.setSuperClass(baseClass, true);
        }
        this.setSuperInterfaces(table.getImplements(), true);
        this.detailPanel.getParent().layout();
    }

    protected void createDomainJavaClassesPropertiesGroup(Composite composite, int columns) {
        Group parent = new Group(composite, 0);
        parent.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_domainJavaClass);
        parent.setLayout((Layout)new GridLayout(columns, false));
        SWTUtil.fillColumns((Control)parent, columns);
        this.createSuperClassControls((Composite)parent, columns);
        this.createSuperInterfacesControls((Composite)parent, columns);
        Control[] controls = parent.getChildren();
        if (controls.length > 1 && controls[1] instanceof Text) {
            Text text = (Text)parent.getChildren()[1];
            LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
            LayoutUtil.setHorizontalGrabbing((Control)text);
        }
    }

    protected IStatus superClassChanged() {
        String oldBaseClass;
        IStatus status = super.superClassChanged();
        String baseClass = this.getSuperClass();
        if (baseClass != null && this.selectedTable != null && !(oldBaseClass = this.selectedTable.getExtends()).equals(baseClass)) {
            this.selectedTable.setExtends(baseClass);
        }
        return status;
    }

    public boolean addSuperInterface(String superInterface) {
        super.addSuperInterface(superInterface);
        List interfaces = this.getSuperInterfaces();
        if (this.selectedTable != null) {
            this.selectedTable.setImplements(interfaces);
        }
        return true;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (this.fSuperClassStatus.matches(4)) {
            this.updateStatus(this.fSuperClassStatus);
        } else {
            this.setMessage("", 0);
            this.setErrorMessage(null);
        }
    }

    private ORMGenCustomizer getCustomizer() {
        GenerateEntitiesFromSchemaWizard wizard = (GenerateEntitiesFromSchemaWizard)this.getWizard();
        return wizard.getCustomizer();
    }

    private void createGenerateDetailGroup(Composite parent, int columns) {
        this.detailPanel = new Composite(parent, 0);
        SWTUtil.fillColumns((Control)this.detailPanel, columns);
        this.detailPanelStatckLayout = new StackLayout();
        this.detailPanel.setLayout((Layout)this.detailPanelStatckLayout);
        Composite emptyPanel = new Composite(this.detailPanel, 0);
        emptyPanel.setLayoutData((Object)new GridData());
        this.detailPanelStatckLayout.topControl = emptyPanel;
        this.detailPanel.layout();
    }

    public final void performHelp() {
        this.getHelpSystem().displayHelp("org.eclipse.jpt.ui.GenerateEntitiesFromSchemaWizard");
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    class TableColumnTreeContentProvider
    implements ITreeContentProvider {
        TableColumnTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ORMGenCustomizer) {
                ORMGenCustomizer input = (ORMGenCustomizer)inputElement;
                List tableNameList = input.getGenTableNames();
                ArrayList<ORMGenTable> ret = new ArrayList<ORMGenTable>();
                for (String t : tableNameList) {
                    ORMGenTable ormGenTable = TablesAndColumnsCustomizationWizardPage.this.getCustomizer().getTable(t);
                    ret.add(ormGenTable);
                }
                return ret.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ORMGenTable) {
                ORMGenTable table = (ORMGenTable)parentElement;
                List columns = table.getColumns();
                ArrayList<ORMGenColumn> ret = new ArrayList<ORMGenColumn>();
                boolean isCompositePk = DTPUtil.getPrimaryKeyColumnNames((Table)table.getDbTable()).size() > 1;
                for (ORMGenColumn col : columns) {
                    if (col.isForeignKey()) continue;
                    if (col.isPrimaryKey()) {
                        if (isCompositePk) continue;
                        ret.add(0, col);
                        continue;
                    }
                    ret.add(col);
                }
                return ret.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ORMGenColumn) {
                return null;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ORMGenTable;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class TableColumnTreeLabelProvider
    extends LabelProvider {
        TableColumnTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ORMGenTable) {
                return CommonImages.createImage(CommonImages.TABLE_IMAGE);
            }
            if (element instanceof ORMGenColumn) {
                ORMGenColumn col = (ORMGenColumn)element;
                if (col.isPrimaryKey()) {
                    return CommonImages.createImage(CommonImages.COLUMN_KEY_IMAGE);
                }
                return CommonImages.createImage(CommonImages.COLUMN_IMAGE);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ORMGenTable) {
                return ((ORMGenTable)element).getName();
            }
            if (element instanceof ORMGenColumn) {
                return ((ORMGenColumn)element).getName();
            }
            return super.getText(element);
        }
    }
}

