/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.ConversionValue;
import org.eclipse.jpt.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOrmConversionValue
extends AbstractXmlContextNode
implements ConversionValue {
    private XmlConversionValue resourceConversionValue;
    private String dataValue;
    private String objectValue;

    public EclipseLinkOrmConversionValue(EclipseLinkOrmObjectTypeConverter parent) {
        super((JpaContextNode)parent);
    }

    @Override
    public EclipseLinkOrmObjectTypeConverter getParent() {
        return (EclipseLinkOrmObjectTypeConverter)super.getParent();
    }

    public TextRange getValidationTextRange() {
        return this.resourceConversionValue.getValidationTextRange();
    }

    @Override
    public String getDataValue() {
        return this.dataValue;
    }

    @Override
    public void setDataValue(String newDataValue) {
        String oldDataValue = this.dataValue;
        this.dataValue = newDataValue;
        this.resourceConversionValue.setDataValue(newDataValue);
        this.firePropertyChanged("dataValue", oldDataValue, newDataValue);
    }

    protected void setDataValue_(String newDataValue) {
        String oldDataValue = this.dataValue;
        this.dataValue = newDataValue;
        this.firePropertyChanged("dataValue", oldDataValue, newDataValue);
    }

    @Override
    public String getObjectValue() {
        return this.objectValue;
    }

    @Override
    public void setObjectValue(String newObjectValue) {
        String oldObjectValue = this.objectValue;
        this.objectValue = newObjectValue;
        this.resourceConversionValue.setObjectValue(newObjectValue);
        this.firePropertyChanged("objectValue", oldObjectValue, newObjectValue);
    }

    protected void setObjectValue_(String newObjectValue) {
        String oldObjectValue = this.objectValue;
        this.objectValue = newObjectValue;
        this.firePropertyChanged("objectValue", oldObjectValue, newObjectValue);
    }

    public void initialize(XmlConversionValue resourceConversionValue) {
        this.resourceConversionValue = resourceConversionValue;
        this.dataValue = this.getResourceDataValue();
        this.objectValue = this.getResourceObjectValue();
    }

    public void update(XmlConversionValue resourceConversionValue) {
        this.resourceConversionValue = resourceConversionValue;
        this.setDataValue_(this.getResourceDataValue());
        this.setObjectValue_(this.getResourceObjectValue());
    }

    protected String getResourceDataValue() {
        return this.resourceConversionValue.getDataValue();
    }

    protected String getResourceObjectValue() {
        return this.resourceConversionValue.getObjectValue();
    }

    public TextRange getDataValueTextRange() {
        return this.resourceConversionValue.getDataValueTextRange();
    }

    public TextRange getObjectValueTextRange() {
        return this.resourceConversionValue.getObjectValueTextRange();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateDataValuesUnique(messages);
    }

    protected void validateDataValuesUnique(List<IMessage> messages) {
        ArrayList dataValues = CollectionTools.list(this.getParent().dataValues());
        dataValues.remove(this.dataValue);
        if (dataValues.contains(this.dataValue)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "MULTIPLE_OBJECT_VALUES_FOR_DATA_VALUE", new String[]{this.dataValue}, this, this.getDataValueTextRange()));
        }
    }
}

