/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.binary;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryPersistentAttribute;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryPersistentMember;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.utility.MethodSignature;
import org.eclipse.jpt.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryPersistentType
extends BinaryPersistentMember
implements JavaResourcePersistentType {
    private String name = this.buildName();
    private String qualifiedName = this.buildQualifiedName();
    private String superclassQualifiedName = this.buildSuperclassQualifiedName();
    private boolean abstract_ = this.buildAbstract();
    private final Vector<JavaResourcePersistentAttribute> fields = this.buildFields();
    private final Vector<JavaResourcePersistentAttribute> methods = this.buildMethods();
    private AccessType access = this.buildAccess();
    private static final IField[] EMPTY_FIELD_ARRAY = new IField[0];
    private static final IMethod[] EMPTY_METHOD_ARRAY = new IMethod[0];

    BinaryPersistentType(JavaResourceNode parent, IType type) {
        super(parent, new TypeAdapter(type));
    }

    @Override
    public void update() {
        super.update();
        this.setName(this.buildName());
        this.setQualifiedName(this.buildQualifiedName());
        this.setSuperclassQualifiedName(this.buildSuperclassQualifiedName());
        this.setAbstract(this.buildAbstract());
        this.updateFields();
        this.updateMethods();
        this.setAccess(this.buildAccess());
    }

    private void updateFields() {
        throw new UnsupportedOperationException();
    }

    private void updateMethods() {
        throw new UnsupportedOperationException();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    Annotation buildMappingAnnotation(IAnnotation jdtAnnotation) {
        return this.getAnnotationProvider().buildTypeMappingAnnotation(this, jdtAnnotation);
    }

    @Override
    Annotation buildSupportingAnnotation(IAnnotation jdtAnnotation) {
        return this.getAnnotationProvider().buildTypeSupportingAnnotation(this, jdtAnnotation);
    }

    @Override
    Annotation buildNullSupportingAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeSupportingAnnotation(this, annotationName);
    }

    @Override
    ListIterator<String> validMappingAnnotationNames() {
        return this.getAnnotationProvider().typeMappingAnnotationNames();
    }

    @Override
    ListIterator<String> validSupportingAnnotationNames() {
        return this.getAnnotationProvider().typeSupportingAnnotationNames();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    private String buildName() {
        return this.getMember().getElementName();
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private void setQualifiedName(String qualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = qualifiedName;
        this.firePropertyChanged("qualifiedName", old, qualifiedName);
    }

    private String buildQualifiedName() {
        return this.getMember().getFullyQualifiedName('.');
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private void setSuperclassQualifiedName(String superclassQualifiedName) {
        String old = this.superclassQualifiedName;
        this.superclassQualifiedName = superclassQualifiedName;
        this.firePropertyChanged("superclassQualifiedName", old, superclassQualifiedName);
    }

    private String buildSuperclassQualifiedName() {
        return BinaryPersistentType.convertTypeSignatureToTypeName(this.getSuperclassTypeSignature());
    }

    private String getSuperclassTypeSignature() {
        try {
            return this.getMember().getSuperclassTypeSignature();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private void setAbstract(boolean abstract_) {
        boolean old = this.abstract_;
        this.abstract_ = abstract_;
        this.firePropertyChanged("abstract", old, abstract_);
    }

    private boolean buildAbstract() {
        try {
            return Flags.isAbstract((int)this.getMember().getFlags());
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public AccessType getAccess() {
        return this.access;
    }

    private void setAccess(AccessType access) {
        AccessType old = this.access;
        this.access = access;
        this.firePropertyChanged("access", (Object)old, (Object)access);
    }

    private AccessType buildAccess() {
        return JPTTools.buildAccess(this);
    }

    @Override
    public boolean hasAnyAttributePersistenceAnnotations() {
        Iterator<JavaResourcePersistentAttribute> stream = this.persistableAttributes();
        while (stream.hasNext()) {
            if (!stream.next().hasAnyPersistenceAnnotations()) continue;
            return true;
        }
        return false;
    }

    public IType getMember() {
        return (IType)super.getMember();
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> fields() {
        return new CloneIterator(this.fields);
    }

    private Iterable<JavaResourcePersistentAttribute> getFields() {
        return new CloneIterable(this.fields);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFields() {
        return this.persistableMembers(this.fields());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFieldsWithSpecifiedFieldAccess() {
        return new FilteringIterator<JavaResourcePersistentAttribute, JavaResourcePersistentAttribute>(this.persistableFields()){

            protected boolean accept(JavaResourcePersistentAttribute resourceAttribute) {
                return resourceAttribute.getSpecifiedAccess() == AccessType.FIELD;
            }
        };
    }

    private void addField(JavaResourcePersistentAttribute field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    private JavaResourcePersistentAttribute getField(String fieldName, int occurrence) {
        for (JavaResourcePersistentAttribute field : this.getFields()) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    private void removeFields(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    private Vector<JavaResourcePersistentAttribute> buildFields() {
        IField[] jdtFields = this.getFields(this.getMember());
        Vector<JavaResourcePersistentAttribute> result = new Vector<JavaResourcePersistentAttribute>(jdtFields.length);
        IField[] iFieldArray = jdtFields;
        int n = jdtFields.length;
        int n2 = 0;
        while (n2 < n) {
            IField jdtField = iFieldArray[n2];
            result.add(this.buildField(jdtField));
            ++n2;
        }
        return result;
    }

    private IField[] getFields(IType type) {
        try {
            return type.getFields();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return EMPTY_FIELD_ARRAY;
        }
    }

    private JavaResourcePersistentAttribute buildField(IField jdtField) {
        return new BinaryPersistentAttribute((JavaResourcePersistentType)this, jdtField);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> methods() {
        return new CloneIterator(this.methods);
    }

    private Iterable<JavaResourcePersistentAttribute> getMethods() {
        return new CloneIterable(this.methods);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableProperties() {
        return this.persistableMembers(this.methods());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistablePropertiesWithSpecifiedPropertyAccess() {
        return new FilteringIterator<JavaResourcePersistentAttribute, JavaResourcePersistentAttribute>(this.persistableProperties()){

            protected boolean accept(JavaResourcePersistentAttribute resourceAttribute) {
                return resourceAttribute.getSpecifiedAccess() == AccessType.PROPERTY;
            }
        };
    }

    private JavaResourcePersistentAttribute getMethod(MethodSignature signature, int occurrence) {
        for (JavaResourcePersistentAttribute method : this.getMethods()) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    private void addMethod(JavaResourcePersistentAttribute method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    private void removeMethods(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    private Vector<JavaResourcePersistentAttribute> buildMethods() {
        IMethod[] jdtMethods = this.getMethods(this.getMember());
        Vector<JavaResourcePersistentAttribute> result = new Vector<JavaResourcePersistentAttribute>(jdtMethods.length);
        IMethod[] iMethodArray = jdtMethods;
        int n = jdtMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod jdtMethod = iMethodArray[n2];
            result.add(this.buildMethod(jdtMethod));
            ++n2;
        }
        return result;
    }

    private IMethod[] getMethods(IType type) {
        try {
            return type.getMethods();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return EMPTY_METHOD_ARRAY;
        }
    }

    private JavaResourcePersistentAttribute buildMethod(IMethod jdtMethod) {
        return new BinaryPersistentAttribute((JavaResourcePersistentType)this, jdtMethod);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistableProperties()});
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes(AccessType specifiedAccess) {
        if (specifiedAccess == null) {
            throw new IllegalArgumentException("specified access is null");
        }
        return specifiedAccess == AccessType.FIELD ? this.persistableAttributesForFieldAccessType() : this.persistableAttributesForPropertyAccessType();
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForFieldAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistablePropertiesWithSpecifiedPropertyAccess()});
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForPropertyAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableProperties(), this.persistableFieldsWithSpecifiedFieldAccess()});
    }

    static boolean typeIsPersistable(IType type) {
        return type != null && type.exists() && JPTTools.typeIsPersistable(new JPTToolsAdapter(type));
    }

    @Override
    public Iterator<JavaResourcePersistentType> types() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<JavaResourcePersistentType> allTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistableTypes() {
        throw new UnsupportedOperationException();
    }

    static class JPTToolsAdapter
    implements JPTTools.TypeAdapter {
        private final IType type;

        protected JPTToolsAdapter(IType type) {
            if (type == null) {
                throw new NullPointerException();
            }
            this.type = type;
        }

        public int getModifiers() {
            try {
                return this.type.getFlags();
            }
            catch (JavaModelException ex) {
                JptCorePlugin.log(ex);
                return 0;
            }
        }

        public boolean isAnnotation() {
            try {
                return this.type.isAnnotation();
            }
            catch (JavaModelException ex) {
                JptCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isAnonymous() {
            try {
                return this.type.isAnonymous();
            }
            catch (JavaModelException ex) {
                JptCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isArray() {
            return false;
        }

        public boolean isEnum() {
            try {
                return this.type.isEnum();
            }
            catch (JavaModelException ex) {
                JptCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isInterface() {
            try {
                return this.type.isInterface();
            }
            catch (JavaModelException ex) {
                JptCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isLocal() {
            try {
                return this.type.isLocal();
            }
            catch (JavaModelException ex) {
                JptCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isMember() {
            try {
                return this.type.isMember();
            }
            catch (JavaModelException ex) {
                JptCorePlugin.log(ex);
                return false;
            }
        }

        public boolean isPrimitive() {
            return false;
        }
    }

    static class TypeAdapter
    implements BinaryPersistentMember.Adapter {
        private final IType type;

        TypeAdapter(IType type) {
            this.type = type;
        }

        public IType getMember() {
            return this.type;
        }

        public boolean isPersistable() {
            return true;
        }

        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.type.getAnnotations();
        }
    }
}

