/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.OrmCascade;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmRelationshipMapping<T extends XmlRelationshipMapping>
extends AbstractOrmAttributeMapping<T>
implements OrmRelationshipMapping {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected Entity resolvedTargetEntity;
    protected final OrmRelationshipReference relationshipReference = this.buildRelationshipReference();
    protected final OrmCascade cascade = new OrmCascade(this, (XmlRelationshipMapping)this.resourceAttributeMapping);
    protected FetchType specifiedFetch;

    protected AbstractOrmRelationshipMapping(OrmPersistentAttribute parent, T resourceMapping) {
        super(parent, resourceMapping);
        this.specifiedTargetEntity = this.getResourceTargetEntity();
        this.defaultTargetEntity = this.buildDefaultTargetEntity();
        this.resolvedTargetEntity = this.buildResolvedTargetEntity();
        this.specifiedFetch = this.getResourceFetch();
    }

    protected abstract OrmRelationshipReference buildRelationshipReference();

    @Override
    public OrmPersistentAttribute getParent() {
        return (OrmPersistentAttribute)super.getParent();
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.relationshipReference.isRelationshipOwner();
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return this.relationshipReference.isOwnedBy(mapping);
    }

    @Override
    public char getTargetEntityEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        ((XmlRelationshipMapping)this.resourceAttributeMapping).setTargetEntity(targetEntity);
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    protected void setSpecifiedTargetEntity_(String targetEntity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = targetEntity;
        this.firePropertyChanged("specifiedTargetEntity", old, targetEntity);
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String targetEntity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = targetEntity;
        this.firePropertyChanged("defaultTargetEntity", old, targetEntity);
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    protected void setResolvedTargetEntity(Entity targetEntity) {
        Entity old = this.resolvedTargetEntity;
        this.resolvedTargetEntity = targetEntity;
        this.firePropertyChanged("resolvedTargetEntity", old, targetEntity);
    }

    @Override
    public OrmRelationshipReference getRelationshipReference() {
        return this.relationshipReference;
    }

    @Override
    public OrmCascade getCascade() {
        return this.cascade;
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.getDefaultFetch();
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        ((XmlRelationshipMapping)this.resourceAttributeMapping).setFetch(FetchType.toOrmResourceModel(fetch));
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedTargetEntity_(this.getResourceTargetEntity());
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity());
        this.setResolvedTargetEntity(this.buildResolvedTargetEntity());
        this.relationshipReference.update();
        this.setSpecifiedFetch_(this.getResourceFetch());
        this.cascade.update();
    }

    protected String getResourceTargetEntity() {
        return ((XmlRelationshipMapping)this.resourceAttributeMapping).getTargetEntity();
    }

    protected FetchType getResourceFetch() {
        return FetchType.fromOrmResourceModel(((XmlRelationshipMapping)this.resourceAttributeMapping).getFetch());
    }

    protected String buildDefaultTargetEntity() {
        RelationshipMapping javaMapping = this.getJavaRelationshipMapping();
        if (javaMapping != null && this.getPersistentAttribute().isVirtual() && !this.getTypeMapping().isMetadataComplete()) {
            return javaMapping.getTargetEntity();
        }
        if (this.getJavaPersistentAttribute() != null) {
            return this.getResourceDefaultTargetEntity();
        }
        return null;
    }

    protected RelationshipMapping getJavaRelationshipMapping() {
        if (this.getJavaPersistentAttribute() == null) {
            return null;
        }
        JavaAttributeMapping javaAttributeMapping = this.getJavaPersistentAttribute().getMapping();
        if (javaAttributeMapping instanceof RelationshipMapping) {
            return (RelationshipMapping)((Object)javaAttributeMapping);
        }
        return null;
    }

    protected abstract String getResourceDefaultTargetEntity();

    protected Entity buildResolvedTargetEntity() {
        String targetEntityName = this.getTargetEntity();
        if (targetEntityName == null) {
            return null;
        }
        Entity targetEntity = this.getEntity(targetEntityName);
        if (targetEntity != null) {
            return targetEntity;
        }
        String defaultPackageName = this.getDefaultPackageName();
        if (defaultPackageName == null) {
            return null;
        }
        return this.getEntity(String.valueOf(defaultPackageName) + '.' + targetEntityName);
    }

    protected String getDefaultPackageName() {
        return this.getPersistentAttribute().getPersistentType().getDefaultPackage();
    }

    protected Entity getEntity(String typeName) {
        return this.getPersistenceUnit().getEntity(typeName);
    }

    @Override
    public Entity getEntity() {
        if (this.getTypeMapping() instanceof Entity) {
            return (Entity)this.getTypeMapping();
        }
        return null;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this);
    }

    @Override
    public void initializeFromOrmRelationshipMapping(OrmRelationshipMapping oldMapping) {
        super.initializeFromOrmRelationshipMapping(oldMapping);
        this.setSpecifiedTargetEntity(oldMapping.getSpecifiedTargetEntity());
        this.setSpecifiedFetch(oldMapping.getSpecifiedFetch());
        oldMapping.getRelationshipReference().initializeOn(this.relationshipReference);
        this.cascade.initializeFrom(oldMapping.getCascade());
    }

    @Override
    public Iterator<String> allTargetEntityAttributeNames() {
        Entity targetEntity = this.getResolvedTargetEntity();
        return targetEntity == null ? EmptyIterator.instance() : targetEntity.getPersistentType().allAttributeNames();
    }

    public Iterator<String> candidateMappedByAttributeNames() {
        return this.allTargetEntityAttributeNames();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateTargetEntity(messages);
        this.relationshipReference.validate(messages, reporter);
    }

    protected void validateTargetEntity(List<IMessage> messages) {
        if (this.getTargetEntity() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_NOT_DEFINED", new String[]{this.getName()}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_NOT_DEFINED", new String[]{this.getName()}, this, this.getValidationTextRange()));
            }
        } else if (this.getResolvedTargetEntity() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getName(), this.getTargetEntity()}, this, this.getValidationTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getTargetEntity(), this.getName()}, this, this.getTargetEntityTextRange()));
            }
        }
    }

    protected TextRange getTextRange(TextRange textRange) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    protected TextRange getTargetEntityTextRange() {
        return this.getTextRange(((XmlRelationshipMapping)this.getResourceAttributeMapping()).getTargetEntityTextRange());
    }
}

