/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaVersionMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.GenericJavaNullConverter;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.VersionAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaVersionMapping
extends AbstractJavaAttributeMapping<VersionAnnotation>
implements JavaVersionMapping {
    protected final JavaColumn column = this.createJavaColumn();
    protected final JavaConverter defaultConverter = new GenericJavaNullConverter(this);
    protected JavaConverter specifiedConverter;

    public GenericJavaVersionMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected JavaColumn createJavaColumn() {
        return this.getJpaFactory().buildJavaColumn(this, this);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.column.initialize(this.getResourceColumn());
        this.specifiedConverter = this.buildSpecifiedConverter(this.getResourceConverterType());
    }

    @Override
    public ColumnAnnotation getResourceColumn() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullSupportingAnnotation("javax.persistence.Column");
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Version";
    }

    @Override
    public Iterator<String> supportingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Column", "javax.persistence.Temporal"});
    }

    @Override
    public String getDefaultColumnName() {
        return this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    public JavaConverter getConverter() {
        return this.getSpecifiedConverter() == null ? this.getDefaultConverter() : this.getSpecifiedConverter();
    }

    @Override
    public JavaConverter getDefaultConverter() {
        return this.defaultConverter;
    }

    @Override
    public JavaConverter getSpecifiedConverter() {
        return this.specifiedConverter;
    }

    protected String getSpecifedConverterType() {
        if (this.specifiedConverter == null) {
            return "noConverter";
        }
        return this.specifiedConverter.getType();
    }

    @Override
    public void setSpecifiedConverter(String converterType) {
        if (this.getSpecifedConverterType() == converterType) {
            return;
        }
        JavaConverter oldConverter = this.specifiedConverter;
        JavaConverter newConverter = this.buildSpecifiedConverter(converterType);
        this.specifiedConverter = null;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.specifiedConverter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("specifiedConverter", oldConverter, newConverter);
    }

    protected void setSpecifiedConverter(JavaConverter newConverter) {
        JavaConverter oldConverter = this.specifiedConverter;
        this.specifiedConverter = newConverter;
        this.firePropertyChanged("specifiedConverter", oldConverter, newConverter);
    }

    @Override
    protected void update() {
        super.update();
        this.column.update(this.getResourceColumn());
        if (this.getResourceConverterType() == this.getSpecifedConverterType()) {
            this.getSpecifiedConverter().update(this.resourcePersistentAttribute);
        } else {
            JavaConverter javaConverter = this.buildSpecifiedConverter(this.getResourceConverterType());
            this.setSpecifiedConverter(javaConverter);
        }
    }

    protected JavaConverter buildSpecifiedConverter(String converterType) {
        if (converterType == "temporalConverter") {
            return this.getJpaFactory().buildJavaTemporalConverter(this, this.resourcePersistentAttribute);
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (this.resourcePersistentAttribute.getSupportingAnnotation("javax.persistence.Temporal") != null) {
            return "temporalConverter";
        }
        return null;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.shouldValidateAgainstDatabase()) {
            this.validateColumn(messages, astRoot);
        }
        if (this.specifiedConverter != null) {
            this.specifiedConverter.validate(messages, reporter, astRoot);
        }
    }

    protected void validateColumn(List<IMessage> messages, CompilationUnit astRoot) {
        String tableName = this.column.getTable();
        if (this.getTypeMapping().tableNameIsInvalid(tableName)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{tableName, this.column.getName()}, this.column, this.column.getTableTextRange(astRoot)));
            return;
        }
        if (!this.column.isResolved() && this.column.getDbTable() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.column.getName()}, this.column, this.column.getNameTextRange(astRoot)));
        }
    }
}

