/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.persistence;

import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;

public class PersistenceTests
extends ContextModelTestCase {
    public PersistenceTests(String name) {
        super(name);
    }

    protected Persistence persistence() {
        return this.getRootContextNode().getPersistenceXml().getPersistence();
    }

    public void testUpdateAddPersistenceUnit() throws Exception {
        XmlPersistence xmlPersistence = this.getXmlPersistence();
        Persistence persistence = this.getRootContextNode().getPersistenceXml().getPersistence();
        xmlPersistence.getPersistenceUnits().clear();
        PersistenceTests.assertEquals((int)0, (int)persistence.persistenceUnitsSize());
        XmlPersistenceUnit xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        xmlPersistenceUnit.setName("test");
        xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)1, (int)persistence.persistenceUnitsSize());
        xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        xmlPersistenceUnit.setName("test2");
        xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)1, (int)persistence.persistenceUnitsSize());
    }

    public void testModifyAddPersistencUnit() {
        XmlPersistence xmlPersistence = this.getXmlPersistence();
        Persistence persistence = this.persistence();
        xmlPersistence.getPersistenceUnits().clear();
        PersistenceTests.assertEquals((int)0, (int)persistence.persistenceUnitsSize());
        persistence.addPersistenceUnit();
        PersistenceTests.assertEquals((int)1, (int)persistence.persistenceUnitsSize());
        boolean exception = false;
        try {
            persistence.addPersistenceUnit();
        }
        catch (IllegalStateException illegalStateException) {
            exception = true;
        }
        PersistenceTests.assertTrue((boolean)exception);
    }

    public void testUpdateRemovePersistenceUnit() throws Exception {
        XmlPersistence xmlPersistence = this.getXmlPersistence();
        Persistence persistence = this.getRootContextNode().getPersistenceXml().getPersistence();
        XmlPersistenceUnit xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        xmlPersistenceUnit.setName("test");
        xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)2, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)1, (int)persistence.persistenceUnitsSize());
        xmlPersistenceUnit = (XmlPersistenceUnit)xmlPersistence.getPersistenceUnits().get(0);
        xmlPersistence.getPersistenceUnits().remove((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)1, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)1, (int)persistence.persistenceUnitsSize());
        xmlPersistenceUnit = (XmlPersistenceUnit)xmlPersistence.getPersistenceUnits().get(0);
        xmlPersistence.getPersistenceUnits().remove((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)0, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)0, (int)persistence.persistenceUnitsSize());
    }

    public void testModifyRemovePersistenceUnit() {
        XmlPersistence xmlPersistence = this.getXmlPersistence();
        Persistence persistence = this.persistence();
        XmlPersistenceUnit xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        xmlPersistenceUnit.setName("test");
        xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)2, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)1, (int)persistence.persistenceUnitsSize());
        persistence.removePersistenceUnit(0);
        PersistenceTests.assertEquals((int)1, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)1, (int)persistence.persistenceUnitsSize());
        persistence.removePersistenceUnit(0);
        PersistenceTests.assertEquals((int)0, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)0, (int)persistence.persistenceUnitsSize());
    }
}

