/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import javax.jws.WebService;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractAnnotationValidationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class WebServiceWebServiceProviderCoExistRuleTest
extends AbstractAnnotationValidationTest {
    protected Annotation getAnnotation() {
        return AnnotationsCore.createAnnotation((AST)this.ast, WebService.class, (String)WebService.class.getSimpleName(), null);
    }

    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.xml.transform.Source;\n");
        classContents.append("import javax.xml.ws.Provider;\n");
        classContents.append("import javax.xml.ws.WebServiceProvider;\n\n");
        classContents.append("@WebServiceProvider\n");
        classContents.append("public class MyClass implements Provider<Source> {\n\n");
        classContents.append("\tpublic Source invoke(Source arg0) {\n\t\treturn null;\n\t}\n\n}");
        return classContents.toString();
    }

    protected String getClassName() {
        return "MyClass.java";
    }

    protected String getPackageName() {
        return "com.example";
    }

    public void testWebServiceWebServiceProviderCoExistRule() {
        try {
            WebServiceWebServiceProviderCoExistRuleTest.assertNotNull((Object)this.annotation);
            WebServiceWebServiceProviderCoExistRuleTest.assertEquals((String)WebService.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebService.class, (TextFileChange)this.textFileChange, (boolean)true);
            AnnotationUtils.addAnnotationToType((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IType)this.source.findPrimaryType(), (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            WebServiceWebServiceProviderCoExistRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            WebServiceWebServiceProviderCoExistRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            WebServiceWebServiceProviderCoExistRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            WebServiceWebServiceProviderCoExistRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            WebServiceWebServiceProviderCoExistRuleTest.assertEquals((Object)JAXWSCoreMessages.WEBSERVICE_WEBSERVICEPROVIDER_COMBINATION, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            WebServiceWebServiceProviderCoExistRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            WebServiceWebServiceProviderCoExistRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            WebServiceWebServiceProviderCoExistRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

