/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.consumption.core.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.wsdl.Definition;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.cxf.consumption.core.CXFConsumptionCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.context.WSDL2JavaPersistentContext;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class WSDL2JavaClientDefaultingCommand
extends AbstractDataModelOperation {
    private WSDL2JavaDataModel model;
    private String projectName;
    private String inputURL;

    public WSDL2JavaClientDefaultingCommand(WSDL2JavaDataModel model, String projectName, String inputURL) {
        this.model = model;
        this.projectName = projectName;
        this.inputURL = inputURL;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        WSDL2JavaPersistentContext context = CXFCorePlugin.getDefault().getWSDL2JavaContext();
        this.model.setCxfRuntimeVersion(context.getCxfRuntimeVersion());
        this.model.setCxfRuntimeEdition(context.getCxfRuntimeEdition());
        this.model.setProjectName(this.projectName);
        this.model.setIncludedNamespaces(new HashMap());
        this.model.setExcludedNamespaces(new HashMap());
        this.model.setXjcUseDefaultValues(context.isXjcUseDefaultValues());
        this.model.setXjcToString(context.isXjcToString());
        this.model.setXjcToStringMultiLine(context.isXjcToStringMultiLine());
        this.model.setXjcToStringSimple(context.isXjcToStringSimple());
        this.model.setXjcLocator(context.isXjcLocator());
        this.model.setXjcSyncMethods(context.isXjcSyncMethods());
        this.model.setXjcMarkGenerated(context.isXjcMarkGenerated());
        this.model.setValidate(context.isValidate());
        this.model.setProcessSOAPHeaders(context.isProcessSOAPHeaders());
        this.model.setLoadDefaultExcludesNamepsaceMapping(context.isLoadDefaultExcludesNamepsaceMapping());
        this.model.setLoadDefaultNamespacePackageNameMapping(context.isLoadDefaultNamespacePackageNameMapping());
        this.model.setUseDefaultValues(context.isUseDefaultValues());
        this.model.setNoAddressBinding(context.isNoAddressBinding());
        this.model.setAutoNameResolution(context.isAutoNameResolution());
        this.model.setJavaSourceFolder(JDTUtils.getJavaProjectSourceDirectoryPath((String)this.model.getProjectName()));
        try {
            URL wsdlUrl = new URL(this.inputURL);
            this.model.setWsdlURL(wsdlUrl);
            Definition definition = WSDLUtils.readWSDL((URL)this.model.getWsdlURL());
            if (definition != null) {
                String targetNamespace = definition.getTargetNamespace();
                String packageName = WSDLUtils.getPackageNameFromNamespace((String)targetNamespace);
                this.model.setTargetNamespace(targetNamespace);
                this.model.getIncludedNamespaces().put(targetNamespace, packageName);
                String wsdlLocation = WSDLUtils.getWSDLLocation((Definition)definition);
                if (wsdlLocation != null) {
                    this.model.setWsdlLocation(wsdlLocation);
                }
                this.model.setWsdlDefinition(definition);
            }
        }
        catch (MalformedURLException murle) {
            status = new Status(4, "org.eclipse.jst.ws.cxf.consumption.core", murle.getLocalizedMessage());
            CXFConsumptionCorePlugin.log(status);
        }
        catch (IOException ioe) {
            status = new Status(4, "org.eclipse.jst.ws.cxf.consumption.core", ioe.getLocalizedMessage());
            CXFConsumptionCorePlugin.log(status);
        }
        return status;
    }

    public WSDL2JavaDataModel getWSDL2JavaDataModel() {
        return this.model;
    }
}

