/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.adapters.IBodyInfo;
import org.eclipse.jst.pagedesigner.adapters.internal.BodyInfo;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition2;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.jst.pagedesigner.utils.NodeLocationComparator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BodyHelper {
    public static final int EMPTY_TEXT = 1;
    public static final int COMMENT = 2;
    public static final int HEADER = 3;

    private static boolean isSkippableChild(Node parent, Node child, int flag) {
        if ((flag & 2) != 0 && child.getNodeType() == 8) {
            return true;
        }
        if ((flag & 1) != 0 && child instanceof IDOMText && ((IDOMText)child).isElementContentWhitespace()) {
            return true;
        }
        if ((flag & 3) != 0 && child.getNodeType() == 1) {
            String uri = CMUtil.getElementNamespaceURI((Element)((Element)child));
            IBodyInfo parentInfo = BodyHelper.getBodyInfo((IDOMNode)parent);
            if (parentInfo != null && parentInfo.isBodyHeader((IDOMNode)parent, uri, ((Element)child).getLocalName())) {
                return true;
            }
        }
        return false;
    }

    public static IDOMNode findHeaderContainer(IDOMNode start, String uri, String tag) {
        while (start != null) {
            IBodyInfo designInfo = BodyHelper.getBodyInfo(start);
            if (designInfo != null && designInfo.isBodyContainer(start) && designInfo.isBodyHeader(start, uri, tag)) {
                return start;
            }
            start = (IDOMNode)start.getParentNode();
        }
        return null;
    }

    public static IDOMPosition findBodyInsertLocation(IDOMPosition position) {
        IBodyInfo info;
        Node reference = position.getNextSiblingNode();
        Node container = position.getContainerNode();
        while (reference != null) {
            info = BodyHelper.getBodyInfo((IDOMNode)reference);
            if (info != null && info.isBodyContainer((IDOMNode)reference)) {
                position = new DOMPosition(reference, 0);
                return BodyHelper.findBodyInsertLocation(position);
            }
            if (!BodyHelper.isSkippableChild(container, reference, 3)) break;
            reference = reference.getNextSibling();
        }
        reference = position.getPreviousSiblingNode();
        while (reference != null) {
            info = BodyHelper.getBodyInfo((IDOMNode)reference);
            if (info != null && info.isBodyContainer((IDOMNode)reference)) {
                position = new DOMPosition(reference, reference.getChildNodes().getLength());
                return BodyHelper.findBodyInsertLocation(position);
            }
            if (!BodyHelper.isSkippableChild(container, reference, 3)) break;
            reference = reference.getPreviousSibling();
        }
        return position;
    }

    public static IDOMPosition adjustInsertPosition(String uri, String tag, IDOMPosition position) {
        IDOMNode parent = (IDOMNode)position.getContainerNode();
        IBodyInfo designInfo = BodyHelper.getBodyInfo(parent);
        if (designInfo == null) {
            return position;
        }
        IDOMNode headerContainer = BodyHelper.findHeaderContainer(parent, uri, tag);
        if (headerContainer == null) {
            if (BodyHelper.shouldIgnoreAdjust(uri, tag)) {
                return position;
            }
            if (!designInfo.isBodyContainer(parent)) {
                return position;
            }
            return BodyHelper.findBodyInsertLocation(position);
        }
        Node child = headerContainer.getFirstChild();
        while (child != null) {
            NodeLocationComparator comp = NodeLocationComparator.getInstance();
            if (comp.compare(child, tag) >= 0 && (comp.compare(child, tag) != 0 || !BodyHelper.isSkippableChild((Node)headerContainer, child, 3))) break;
            child = child.getNextSibling();
        }
        if (child != null) {
            return new DOMRefPosition(child, false);
        }
        return new DOMPosition((Node)parent, parent.getChildNodes().getLength());
    }

    public static void findHeaderInsertPosition(String uri, String tag, Node parent, Node[] ref) {
        Node child = parent.getFirstChild();
        while (child != null) {
            NodeLocationComparator comp = NodeLocationComparator.getInstance();
            if (comp.compare(child, tag) >= 0 && (comp.compare(child, tag) != 0 || !BodyHelper.isSkippableChild(parent, child, 3))) break;
            child = child.getNextSibling();
        }
        ref[0] = child;
    }

    public static IDOMPosition insertBody(IDOMPosition position, QName body, String defaultPrefix) {
        Node node;
        IBodyInfo bodyInfo = BodyHelper.getBodyInfo((IDOMNode)position.getContainerNode());
        Node originalContainer = node = position.getContainerNode();
        Node nextSibling = position.getNextSiblingNode();
        Document ownerDoc = node instanceof Document ? (Document)node : node.getOwnerDocument();
        if (ownerDoc == null) {
            return null;
        }
        String prefix = JSPUtil.getOrCreatePrefix(((IDOMNode)node).getModel(), body.getNamespaceURI(), defaultPrefix);
        Element ele = ownerDoc.createElement(String.valueOf(prefix == null ? "" : String.valueOf(prefix) + ":") + body.getLocalPart());
        while (node instanceof IDOMNode) {
            if (bodyInfo.isBodyContainer((IDOMNode)node)) {
                NodeList nl = node.getChildNodes();
                ArrayList<Node> list = new ArrayList<Node>();
                int i = 0;
                while (i < nl.getLength()) {
                    Node child = nl.item(i);
                    if (!BodyHelper.isSkippableChild(node, child, 3)) {
                        list.add(nl.item(i));
                    }
                    ++i;
                }
                i = 0;
                while (i < list.size()) {
                    ele.appendChild((Node)list.get(i));
                    ++i;
                }
                node.appendChild(ele);
                if (node == originalContainer) {
                    if (nextSibling == null) {
                        return new DOMRefPosition2(ele, true);
                    }
                    if (nextSibling.getParentNode() == ele) {
                        return new DOMRefPosition(nextSibling, false);
                    }
                    return new DOMPosition(ele, 0);
                }
                return position;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static boolean shouldIgnoreAdjust(String uri, String tag) {
        return "html".equalsIgnoreCase(uri) && "script".equalsIgnoreCase(tag) || "jsp".equals(uri);
    }

    public static IBodyInfo getBodyInfo(IDOMNode node) {
        return BodyInfo.getInstance();
    }
}

