/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.common.project.facet.JavaProjectFacetCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.jsf.test.util.Activator;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class WebProjectTestEnvironment
extends ProjectTestEnvironment {
    private final IProjectFacetVersion _javaFacetVersion;
    private final IProjectFacetVersion _webFacetVersion;

    public WebProjectTestEnvironment(String projectName) {
        this(projectName, JavaFacetUtils.JAVA_50, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.4"));
    }

    public WebProjectTestEnvironment(String projectName, IProjectFacetVersion javaVersion, IProjectFacetVersion webVersion) {
        super(projectName);
        this._javaFacetVersion = javaVersion;
        this._webFacetVersion = webVersion;
    }

    public WebProjectTestEnvironment(TestCase forCase, IProjectFacetVersion javaVersion, IProjectFacetVersion webVersion) {
        this(String.valueOf(forCase.getClass().getName()) + "_" + forCase.getName(), javaVersion, webVersion);
    }

    public boolean createProject(boolean ignoreProjectExists) {
        boolean doCreate = true;
        try {
            this._project = ResourcesPlugin.getWorkspace().getRoot().getProject(this._projectName);
            if (this._project.isAccessible()) {
                if (ignoreProjectExists) {
                    if (this.hasFacets(this._project)) {
                        doCreate = false;
                    }
                } else {
                    throw new RuntimeException("Project was not expected to exist but does: " + this._project.getName());
                }
            }
            if (doCreate) {
                this._project = this.createWebProject(this._projectName);
            }
            this._projectCreated = true;
            return doCreate;
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    private boolean hasFacets(IProject project) throws CoreException {
        boolean javaInstalled = false;
        boolean webInstalled = false;
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        IProjectFacetVersion version = facetedProject.getInstalledVersion(this._javaFacetVersion.getProjectFacet());
        if (version != null) {
            if (version.compareTo((Object)this._javaFacetVersion) == 0) {
                javaInstalled = true;
            } else {
                throw new RuntimeException("Wrong Java version already installed. Has: " + version.getVersionString() + " but was expecting: " + this._javaFacetVersion.getVersionString());
            }
        }
        if ((version = facetedProject.getInstalledVersion(this._webFacetVersion.getProjectFacet())) != null) {
            if (version.compareTo((Object)this._webFacetVersion) == 0) {
                webInstalled = true;
            } else {
                throw new RuntimeException("Wrong web version already installed. Has: " + version.getVersionString() + " but was expecting: " + this._javaFacetVersion.getVersionString());
            }
        }
        return javaInstalled && webInstalled;
    }

    private IProject createWebProject(String projectName) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!this.isProjectCreated()) {
            if (!project.exists()) {
                project.create(null);
                project.open(null);
                ProjectUtilities.addNatureToProject((IProject)project, (String)"org.eclipse.wst.common.project.facet.core.nature");
            }
            HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
            IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectFacetCreationDataModelProvider());
            dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, this._javaFacetVersion, null));
            dataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
            dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, this._webFacetVersion, null));
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            facetedProject.modify(actions, null);
        }
        return project;
    }

    public IVirtualContainer getWebRoot(boolean create, boolean force) {
        IVirtualFolder webRoot = ComponentCore.createComponent((IProject)this.getTestProject()).getRootFolder();
        if (!webRoot.exists() && create) {
            try {
                webRoot.create(force ? 256 : 0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                Activator.log("Error creating web root", ce);
                ce.printStackTrace();
            }
        }
        return webRoot;
    }

    public IResource loadResourceInWebRoot(Bundle bundle, String srcFileName, String destFileName) throws IOException, CoreException {
        TestFileResource resource = new TestFileResource();
        resource.load(bundle, srcFileName);
        IFile file = this.getWebRoot(true, true).getFile((IPath)new Path(destFileName)).getUnderlyingFile();
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(resource.toBytes()), true, null);
        } else {
            file.setContents((InputStream)new ByteArrayInputStream(resource.toBytes()), true, true, null);
        }
        return file;
    }
}

