/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.ItemListListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.utility.internal.swing.Displayable;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;
import org.eclipse.jpt.utility.tests.internal.model.value.CoordinatedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListListValueModelAdapterTests
extends TestCase {
    private Junk foo;
    private Junk bar;
    private Junk baz;
    private Junk joo;
    private Junk jar;
    private Junk jaz;
    private Junk tom;
    private Junk dick;
    private Junk harry;

    public ItemListListValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.foo = new Junk("foo");
        this.bar = new Junk("bar");
        this.baz = new Junk("baz");
        this.joo = new Junk("joo");
        this.jar = new Junk("jar");
        this.jaz = new Junk("jaz");
        this.tom = new Junk("tom");
        this.dick = new Junk("dick");
        this.harry = new Junk("harry");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testCollectionSynchronization() {
        SimpleCollectionValueModel<Junk> collectionHolder = this.buildCollectionHolder();
        ItemListListValueModelAdapter listValueModel = new ItemListListValueModelAdapter(collectionHolder, new String[]{"stuff"});
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemListListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        collectionHolder.add((Object)this.tom);
        collectionHolder.add((Object)this.dick);
        collectionHolder.add((Object)this.harry);
        ItemListListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        collectionHolder.remove((Object)this.foo);
        collectionHolder.remove((Object)this.jar);
        collectionHolder.remove((Object)this.harry);
        ItemListListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
    }

    public void testListSynchronization() {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemListListValueModelAdapter listValueModel = new ItemListListValueModelAdapter(listHolder, new String[]{"stuff"});
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemListListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        listHolder.add(6, (Object)this.tom);
        listHolder.add(7, (Object)this.dick);
        listHolder.add(8, (Object)this.harry);
        ItemListListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        listHolder.remove(8);
        listHolder.remove(0);
        listHolder.remove(4);
        ItemListListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
    }

    private void compare(ListValueModel<Junk> listValueModel, List<Junk> list) {
        ItemListListValueModelAdapterTests.assertEquals((int)listValueModel.size(), (int)list.size());
        int i = 0;
        while (i < listValueModel.size()) {
            ItemListListValueModelAdapterTests.assertEquals((Object)listValueModel.get(i), (Object)((Object)list.get(i)));
            ++i;
        }
    }

    public void testHasListeners() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemListListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemListListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyListChangeListeners("stuff"));
        ItemListListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyListChangeListeners("stuff"));
        ItemListListValueModelAdapter listValueModel = new ItemListListValueModelAdapter(listHolder, new String[]{"stuff"});
        ItemListListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemListListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyListChangeListeners("stuff"));
        ItemListListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyListChangeListeners("stuff"));
        this.verifyHasNoListeners((ListValueModel<Junk>)listValueModel);
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        ItemListListValueModelAdapterTests.assertTrue((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemListListValueModelAdapterTests.assertTrue((boolean)this.foo.hasAnyListChangeListeners("stuff"));
        ItemListListValueModelAdapterTests.assertTrue((boolean)this.jaz.hasAnyListChangeListeners("stuff"));
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        listValueModel.removeListChangeListener("list values", synchList);
        ItemListListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemListListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyListChangeListeners("stuff"));
        ItemListListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyListChangeListeners("stuff"));
        this.verifyHasNoListeners((ListValueModel<Junk>)listValueModel);
    }

    public void testGetSize() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemListListValueModelAdapter listValueModel = new ItemListListValueModelAdapter(listHolder, new String[]{"stuff"});
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        ItemListListValueModelAdapterTests.assertEquals((int)6, (int)listValueModel.size());
        ItemListListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
    }

    public void testGet() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        SortedListValueModelAdapter listValueModel = new SortedListValueModelAdapter((ListValueModel)new ItemListListValueModelAdapter(listHolder, new String[]{"stuff"}));
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        ItemListListValueModelAdapterTests.assertEquals((Object)((Object)this.bar), (Object)listValueModel.get(0));
        ItemListListValueModelAdapterTests.assertEquals((Object)((Object)this.bar), synchList.get(0));
        this.bar.removeStuff("bar");
        this.bar.addStuff("zzz");
        this.bar.addStuff("bar");
        ItemListListValueModelAdapterTests.assertEquals((Object)((Object)this.bar), (Object)listValueModel.get(5));
        ItemListListValueModelAdapterTests.assertEquals((Object)((Object)this.bar), synchList.get(5));
        this.bar.removeStuff("zzz");
    }

    private void verifyHasNoListeners(ListValueModel<Junk> listValueModel) throws Exception {
        ItemListListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)listValueModel).hasNoListChangeListeners("list values"));
    }

    private void verifyHasListeners(ListValueModel<Junk> listValueModel) throws Exception {
        ItemListListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)listValueModel).hasAnyListChangeListeners("list values"));
    }

    private SimpleCollectionValueModel<Junk> buildCollectionHolder() {
        return new SimpleCollectionValueModel(this.buildCollection());
    }

    private Collection<Junk> buildCollection() {
        HashBag bag = new HashBag();
        this.populateCollection((Collection<Junk>)bag);
        return bag;
    }

    private SimpleListValueModel<Junk> buildListHolder() {
        return new SimpleListValueModel(this.buildList());
    }

    private List<Junk> buildList() {
        ArrayList<Junk> list = new ArrayList<Junk>();
        this.populateCollection(list);
        return list;
    }

    private void populateCollection(Collection<Junk> c) {
        c.add(this.foo);
        c.add(this.bar);
        c.add(this.baz);
        c.add(this.joo);
        c.add(this.jar);
        c.add(this.jaz);
    }

    private class Junk
    extends AbstractModel
    implements Displayable {
        private List<String> stuff = new ArrayList<String>();
        public static final String STUFF_LIST = "stuff";

        public Junk(String stuffItem) {
            this.stuff.add(stuffItem);
        }

        public void addStuff(String stuffItem) {
            this.stuff.add(stuffItem);
            this.fireItemAdded(STUFF_LIST, this.stuff.indexOf(stuffItem), stuffItem);
        }

        public void removeStuff(String stuffItem) {
            int index = this.stuff.indexOf(stuffItem);
            this.stuff.remove(stuffItem);
            this.fireItemRemoved(STUFF_LIST, index, stuffItem);
        }

        public String displayString() {
            return this.toString();
        }

        public Icon icon() {
            return null;
        }

        public int compareTo(Displayable o) {
            return DEFAULT_COMPARATOR.compare(this, o);
        }

        public String toString() {
            return "Junk(" + this.stuff + ")";
        }
    }
}

