/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.listener;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.ReflectiveChangeListener;

public class ReflectiveCollectionChangeListenerTests
extends TestCase {
    public ReflectiveCollectionChangeListenerTests(String name) {
        super(name);
    }

    private CollectionChangeListener buildZeroArgumentListener(Object target) {
        return ReflectiveChangeListener.buildCollectionChangeListener((Object)target, (String)"itemAddedZeroArgument", (String)"itemRemovedZeroArgument", (String)"collectionClearedZeroArgument", (String)"collectionChangedZeroArgument");
    }

    private CollectionChangeListener buildSingleArgumentListener(Object target) {
        return ReflectiveChangeListener.buildCollectionChangeListener((Object)target, (String)"itemAddedSingleArgument", (String)"itemRemovedSingleArgument", (String)"collectionClearedSingleArgument", (String)"collectionChangedSingleArgument");
    }

    public void testItemAddedZeroArgument() {
        TestModel testModel = new TestModel();
        String string = "foo";
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener(this.buildZeroArgumentListener(target));
        testModel.addString(string);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testItemAddedZeroArgumentNamedCollection() {
        TestModel testModel = new TestModel();
        String string = "foo";
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.addString(string);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testItemAddedSingleArgument() {
        TestModel testModel = new TestModel();
        String string = "foo";
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener(this.buildSingleArgumentListener(target));
        testModel.addString(string);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testItemAddedSingleArgumentNamedCollection() {
        TestModel testModel = new TestModel();
        String string = "foo";
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.addString(string);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testItemRemovedZeroArgument() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener(this.buildZeroArgumentListener(target));
        testModel.removeString(string);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testItemRemovedZeroArgumentNamedCollection() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.removeString(string);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testItemRemovedSingleArgument() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener(this.buildSingleArgumentListener(target));
        testModel.removeString(string);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testItemRemovedSingleArgumentNamedCollection() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.removeString(string);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testCollectionClearedZeroArgument() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener(this.buildZeroArgumentListener(target));
        testModel.clearStrings();
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testCollectionClearedZeroArgumentNamedCollection() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.clearStrings();
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testCollectionClearedSingleArgument() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener(this.buildSingleArgumentListener(target));
        testModel.clearStrings();
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testCollectionClearedSingleArgumentNamedCollection() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.clearStrings();
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testCollectionChangedZeroArgument() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener(this.buildZeroArgumentListener(target));
        testModel.replaceStrings(new String[]{"bar", "baz"});
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testCollectionChangedZeroArgumentNamedCollection() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener("strings", this.buildZeroArgumentListener(target));
        testModel.replaceStrings(new String[]{"bar", "baz"});
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testCollectionChangedSingleArgument() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener(this.buildSingleArgumentListener(target));
        testModel.replaceStrings(new String[]{"bar", "baz"});
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testCollectionChangedSingleArgumentNamedCollection() {
        TestModel testModel = new TestModel();
        String string = "foo";
        testModel.addString(string);
        Target target = new Target(testModel, "strings", string);
        testModel.addCollectionChangeListener("strings", this.buildSingleArgumentListener(target));
        testModel.replaceStrings(new String[]{"bar", "baz"});
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemAddedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.itemRemovedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionClearedSingleArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertFalse((boolean)target.collectionChangedZeroArgumentFlag);
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)target.collectionChangedSingleArgumentFlag);
    }

    public void testBogusDoubleArgument1() {
        boolean exCaught;
        block2: {
            TestModel testModel = new TestModel();
            String string = "foo";
            Target target = new Target(testModel, "strings", string);
            exCaught = false;
            try {
                CollectionChangeListener listener = ReflectiveChangeListener.buildCollectionChangeListener((Object)target, (String)"collectionChangedDoubleArgument");
                ReflectiveCollectionChangeListenerTests.fail((String)("bogus listener: " + listener));
            }
            catch (RuntimeException ex) {
                if (ex.getCause().getClass() != NoSuchMethodException.class) break block2;
                exCaught = true;
            }
        }
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)exCaught);
    }

    public void testBogusDoubleArgument2() throws Exception {
        boolean exCaught;
        block2: {
            TestModel testModel = new TestModel();
            String string = "foo";
            Target target = new Target(testModel, "strings", string);
            Method method = ClassTools.method((Object)target, (String)"collectionChangedDoubleArgument", (Class[])new Class[]{CollectionChangeEvent.class, Object.class});
            exCaught = false;
            try {
                CollectionChangeListener listener = ReflectiveChangeListener.buildCollectionChangeListener((Object)target, (Method)method);
                ReflectiveCollectionChangeListenerTests.fail((String)("bogus listener: " + listener));
            }
            catch (RuntimeException ex) {
                if (!ex.getMessage().equals(method.toString())) break block2;
                exCaught = true;
            }
        }
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)exCaught);
    }

    public void testListenerMismatch() {
        TestModel testModel = new TestModel();
        String string = "foo";
        Target target = new Target(testModel, "strings", string);
        CollectionChangeListener listener = ReflectiveChangeListener.buildCollectionChangeListener((Object)target, (String)"itemAddedSingleArgument");
        testModel.addListChangeListener((ListChangeListener)listener);
        boolean exCaught = false;
        try {
            testModel.changeList();
            ReflectiveCollectionChangeListenerTests.fail((String)("listener mismatch: " + listener));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ReflectiveCollectionChangeListenerTests.assertTrue((boolean)exCaught);
    }

    private class Target {
        TestModel testModel;
        String collectionName;
        String string;
        boolean itemAddedZeroArgumentFlag = false;
        boolean itemAddedSingleArgumentFlag = false;
        boolean itemRemovedZeroArgumentFlag = false;
        boolean itemRemovedSingleArgumentFlag = false;
        boolean collectionClearedZeroArgumentFlag = false;
        boolean collectionClearedSingleArgumentFlag = false;
        boolean collectionChangedZeroArgumentFlag = false;
        boolean collectionChangedSingleArgumentFlag = false;

        Target(TestModel testModel, String collectionName, String string) {
            this.testModel = testModel;
            this.collectionName = collectionName;
            this.string = string;
        }

        void itemAddedZeroArgument() {
            this.itemAddedZeroArgumentFlag = true;
        }

        void itemAddedSingleArgument(CollectionChangeEvent e) {
            this.itemAddedSingleArgumentFlag = true;
            ReflectiveCollectionChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveCollectionChangeListenerTests.assertEquals((String)this.collectionName, (String)e.getCollectionName());
            ReflectiveCollectionChangeListenerTests.assertEquals((Object)this.string, e.items().next());
        }

        void itemRemovedZeroArgument() {
            this.itemRemovedZeroArgumentFlag = true;
        }

        void itemRemovedSingleArgument(CollectionChangeEvent e) {
            this.itemRemovedSingleArgumentFlag = true;
            ReflectiveCollectionChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveCollectionChangeListenerTests.assertEquals((String)this.collectionName, (String)e.getCollectionName());
            ReflectiveCollectionChangeListenerTests.assertEquals((Object)this.string, e.items().next());
        }

        void collectionClearedZeroArgument() {
            this.collectionClearedZeroArgumentFlag = true;
        }

        void collectionClearedSingleArgument(CollectionChangeEvent e) {
            this.collectionClearedSingleArgumentFlag = true;
            ReflectiveCollectionChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveCollectionChangeListenerTests.assertEquals((String)this.collectionName, (String)e.getCollectionName());
            ReflectiveCollectionChangeListenerTests.assertFalse((boolean)e.items().hasNext());
        }

        void collectionChangedZeroArgument() {
            this.collectionChangedZeroArgumentFlag = true;
        }

        void collectionChangedSingleArgument(CollectionChangeEvent e) {
            this.collectionChangedSingleArgumentFlag = true;
            ReflectiveCollectionChangeListenerTests.assertSame((Object)((Object)this.testModel), (Object)e.getSource());
            ReflectiveCollectionChangeListenerTests.assertEquals((String)this.collectionName, (String)e.getCollectionName());
            ReflectiveCollectionChangeListenerTests.assertFalse((boolean)e.items().hasNext());
        }

        void collectionChangedDoubleArgument(CollectionChangeEvent e, Object o) {
            ReflectiveCollectionChangeListenerTests.fail((String)("bogus event: " + e));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestModel
    extends AbstractModel {
        private Collection<String> strings = new ArrayList<String>();
        public static final String STRINGS_COLLECTION = "strings";

        TestModel() {
        }

        Iterator<String> strings() {
            return new CloneIterator<String>(this.strings){

                protected void remove(String s) {
                    TestModel.this.removeString(s);
                }
            };
        }

        void addString(String string) {
            this.addItemToCollection(string, this.strings, STRINGS_COLLECTION);
        }

        void removeString(String string) {
            this.removeItemFromCollection(string, this.strings, STRINGS_COLLECTION);
        }

        void clearStrings() {
            this.clearCollection(this.strings, STRINGS_COLLECTION);
        }

        void replaceStrings(String[] newStrings) {
            this.strings.clear();
            CollectionTools.addAll(this.strings, (Object[])newStrings);
            this.fireCollectionChanged(STRINGS_COLLECTION);
        }

        void changeList() {
            this.fireListChanged("bogus list");
        }
    }
}

