/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationIteratorTests
extends TestCase {
    public TransformationIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator<Integer> stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        TransformationIteratorTests.assertEquals((int)8, (int)i);
    }

    public void testHasNextUpcast() {
        int i = 0;
        Iterator<Object> stream = this.buildIteratorUpcast();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        TransformationIteratorTests.assertEquals((int)8, (int)i);
    }

    public void testInnerHasNext() {
        int i = 0;
        Iterator<Integer> stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        TransformationIteratorTests.assertEquals((int)8, (int)i);
    }

    public void testNext() {
        int i = 0;
        Iterator<Integer> stream = this.buildIterator();
        while (stream.hasNext()) {
            TransformationIteratorTests.assertEquals((String)"bogus transformation", (int)(++i), (int)stream.next());
        }
    }

    public void testNextUpcast() {
        int i = 0;
        Iterator<Object> stream = this.buildIteratorUpcast();
        while (stream.hasNext()) {
            TransformationIteratorTests.assertEquals((String)"bogus transformation", (int)(++i), (int)((Integer)stream.next()));
        }
    }

    public void testInnerNext() {
        int i = 0;
        Iterator<Integer> stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            TransformationIteratorTests.assertEquals((String)"bogus transformation", (int)(++i), (int)stream.next());
        }
    }

    public void testRemove() {
        Collection<String> c = this.buildCollection();
        Iterator<Integer> stream = this.buildInnerTransformationIterator(c.iterator());
        while (stream.hasNext()) {
            if (stream.next() != 3) continue;
            stream.remove();
        }
        TransformationIteratorTests.assertEquals((String)"nothing removed", (int)(this.buildCollection().size() - 1), (int)c.size());
        TransformationIteratorTests.assertFalse((String)"element still in collection", (boolean)c.contains("333"));
        TransformationIteratorTests.assertTrue((String)"wrong element removed", (boolean)c.contains("22"));
    }

    public void testInnerRemove() {
        Collection<String> c = this.buildCollection();
        Iterator<Integer> stream = this.buildTransformationIterator(c.iterator(), this.buildTransformer());
        while (stream.hasNext()) {
            if (stream.next() != 3) continue;
            stream.remove();
        }
        TransformationIteratorTests.assertEquals((String)"nothing removed", (int)(this.buildCollection().size() - 1), (int)c.size());
        TransformationIteratorTests.assertFalse((String)"element still in collection", (boolean)c.contains("333"));
        TransformationIteratorTests.assertTrue((String)"wrong element removed", (boolean)c.contains("22"));
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<Integer> stream = this.buildIterator();
        Integer integer = null;
        while (stream.hasNext()) {
            integer = stream.next();
        }
        try {
            integer = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        TransformationIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + integer), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator<Integer> stream = this.buildUnmodifiableIterator();
        while (stream.hasNext()) {
            int i = stream.next();
            if (i != 3) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        TransformationIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testIllegalStateException() {
        boolean exCaught = false;
        try {
            this.buildIterator().remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        TransformationIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
    }

    private Iterator<Integer> buildIterator() {
        return this.buildTransformationIterator(this.buildNestedIterator(), this.buildTransformer());
    }

    private Iterator<Object> buildIteratorUpcast() {
        return this.buildTransformationIteratorUpcast(this.buildNestedIterator(), this.buildTransformerUpcast());
    }

    private Iterator<Integer> buildInnerIterator() {
        return this.buildInnerTransformationIterator(this.buildNestedIterator());
    }

    private Iterator<Integer> buildUnmodifiableIterator() {
        return this.buildTransformationIterator(this.buildUnmodifiableNestedIterator(), this.buildTransformer());
    }

    private Iterator<Integer> buildTransformationIterator(Iterator<String> nestedIterator, Transformer<String, Integer> transformer) {
        return new TransformationIterator(nestedIterator, transformer);
    }

    private Iterator<Object> buildTransformationIteratorUpcast(Iterator<String> nestedIterator, Transformer<Object, Integer> transformer) {
        return new TransformationIterator(nestedIterator, transformer);
    }

    private Transformer<String, Integer> buildTransformer() {
        return new Transformer<String, Integer>(){

            public Integer transform(String next) {
                return new Integer(next.length());
            }
        };
    }

    private Transformer<Object, Integer> buildTransformerUpcast() {
        return new Transformer<Object, Integer>(){

            public Integer transform(Object next) {
                return new Integer(((String)next).length());
            }
        };
    }

    private Iterator<Integer> buildInnerTransformationIterator(Iterator<String> nestedIterator) {
        return new TransformationIterator<String, Integer>(nestedIterator){

            protected Integer transform(String next) {
                return new Integer(next.length());
            }
        };
    }

    private Iterator<String> buildNestedIterator() {
        return this.buildCollection().iterator();
    }

    private Iterator<String> buildUnmodifiableNestedIterator() {
        return this.buildUnmodifiableCollection().iterator();
    }

    private Collection<String> buildCollection() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("1");
        c.add("22");
        c.add("333");
        c.add("4444");
        c.add("55555");
        c.add("666666");
        c.add("7777777");
        c.add("88888888");
        return c;
    }

    private Collection<String> buildUnmodifiableCollection() {
        return Collections.unmodifiableCollection(this.buildCollection());
    }

    public void testInvalidTransformationIterator() {
        TransformationIterator iterator = new TransformationIterator(this.buildCollection().iterator());
        boolean exCaught = false;
        try {
            Integer integer = (Integer)iterator.next();
            TransformationIteratorTests.fail((String)("invalid integer: " + integer));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TransformationIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }
}

