/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTMember;
import org.eclipse.jpt.core.internal.utility.jdt.JPTTools;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.CommandExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTType
extends JDTMember
implements Type {
    public JDTType(TypeDeclaration typeDeclaration, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor) {
        this(typeDeclaration, compilationUnit, modifySharedDocumentCommandExecutor, DefaultAnnotationEditFormatter.instance());
    }

    public JDTType(TypeDeclaration typeDeclaration, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        this(null, typeDeclaration, 1, compilationUnit, modifySharedDocumentCommandExecutor, annotationEditFormatter);
    }

    public JDTType(Type declaringType, TypeDeclaration typeDeclaration, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor) {
        this(declaringType, typeDeclaration, occurrence, compilationUnit, modifySharedDocumentCommandExecutor, (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    public JDTType(Type declaringType, TypeDeclaration typeDeclaration, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        super(declaringType, typeDeclaration.getName().getFullyQualifiedName(), occurrence, compilationUnit, modifySharedDocumentCommandExecutor, annotationEditFormatter);
    }

    public JDTType(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit) {
        super(declaringType, name, occurrence, compilationUnit, CommandExecutor.Default.instance(), DefaultAnnotationEditFormatter.instance());
    }

    @Override
    public ITypeBinding getBinding(CompilationUnit astRoot) {
        TypeDeclaration td = this.getBodyDeclaration(astRoot);
        return td == null ? null : td.resolveBinding();
    }

    @Override
    public TypeDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        Type declaringType = this.getDeclaringType();
        return declaringType == null ? this.getTopLevelTypeDeclaration(astRoot) : this.getNestedTypeDeclaration(declaringType.getBodyDeclaration(astRoot));
    }

    @Override
    public boolean isPersistable(CompilationUnit astRoot) {
        ITypeBinding binding = this.getBinding(astRoot);
        return binding == null ? false : JPTTools.typeIsPersistable(new JPTToolsAdapter(binding));
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return new ASTNodeTextRange((ASTNode)this.getBodyDeclaration(astRoot).getName());
    }

    @Override
    public TypeDeclaration[] getTypes(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).getTypes();
    }

    @Override
    public FieldDeclaration[] getFields(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).getFields();
    }

    @Override
    public MethodDeclaration[] getMethods(CompilationUnit astRoot) {
        return this.getBodyDeclaration(astRoot).getMethods();
    }

    protected TypeDeclaration getTopLevelTypeDeclaration(CompilationUnit astRoot) {
        return this.getTypeDeclaration(JDTType.types(astRoot));
    }

    protected TypeDeclaration getTypeDeclaration(List<AbstractTypeDeclaration> typeDeclarations) {
        return this.getTypeDeclaration(typeDeclarations.toArray(new AbstractTypeDeclaration[typeDeclarations.size()]));
    }

    protected TypeDeclaration getNestedTypeDeclaration(TypeDeclaration declaringTypeDeclaration) {
        return this.getTypeDeclaration((AbstractTypeDeclaration[])declaringTypeDeclaration.getTypes());
    }

    protected TypeDeclaration getTypeDeclaration(AbstractTypeDeclaration[] typeDeclarations) {
        String name = this.getName_();
        int occurrence = this.getOccurrence();
        int count = 0;
        AbstractTypeDeclaration[] abstractTypeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTypeDeclaration typeDeclaration = abstractTypeDeclarationArray[n2];
            if (typeDeclaration.getName().getFullyQualifiedName().equals(name) && ++count == occurrence) {
                return typeDeclaration.getNodeType() == 55 ? (TypeDeclaration)typeDeclaration : null;
            }
            ++n2;
        }
        return null;
    }

    protected static List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }

    protected class JPTToolsAdapter
    implements JPTTools.TypeAdapter {
        private final ITypeBinding typeBinding;

        protected JPTToolsAdapter(ITypeBinding typeBinding) {
            if (typeBinding == null) {
                throw new NullPointerException();
            }
            this.typeBinding = typeBinding;
        }

        public int getModifiers() {
            return this.typeBinding.getModifiers();
        }

        public boolean isAnnotation() {
            return this.typeBinding.isAnnotation();
        }

        public boolean isAnonymous() {
            return this.typeBinding.isAnonymous();
        }

        public boolean isArray() {
            return this.typeBinding.isArray();
        }

        public boolean isEnum() {
            return this.typeBinding.isEnum();
        }

        public boolean isInterface() {
            return this.typeBinding.isInterface();
        }

        public boolean isLocal() {
            return this.typeBinding.isLocal();
        }

        public boolean isMember() {
            return this.typeBinding.isMember();
        }

        public boolean isPrimitive() {
            return this.typeBinding.isPrimitive();
        }
    }
}

