/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.operations;

import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.core.internal.resource.orm.OrmXmlResourceProvider;
import org.eclipse.jpt.core.resource.AbstractXmlResourceProvider;
import org.eclipse.jpt.core.resource.orm.AccessType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class OrmFileCreationOperation
extends AbstractDataModelOperation
implements OrmFileCreationDataModelProperties {
    public OrmFileCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IFolder folder = this.createSourceFolder();
        IFile file = this.createMappingFile(folder);
        this.addMappingFileToPersistenceXml(file);
        return OK_STATUS;
    }

    protected IProject getProject() throws ExecutionException {
        String projectName = (String)this.getDataModel().getProperty("OrmFileCreationDataModelProperties.PROJECT_NAME");
        IProject project = ProjectUtilities.getProject((String)projectName);
        if (project == null) {
            throw new ExecutionException("No project name specified");
        }
        return project;
    }

    protected JpaProject getJpaProject() throws ExecutionException {
        IProject project = this.getProject();
        JpaProject jpaProject = JptCorePlugin.getJpaProject(project);
        if (jpaProject == null) {
            throw new ExecutionException("Project does not have JPA content");
        }
        return jpaProject;
    }

    protected PersistenceUnit getPersistenceUnit() throws ExecutionException {
        String pUnitName = this.getDataModel().getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        JpaProject jpaProject = this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            throw new ExecutionException("Project does not have a persistence.xml file");
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            throw new ExecutionException("persistence.xml does not have a persistence node.");
        }
        ListIterator<PersistenceUnit> stream = persistence.persistenceUnits();
        while (stream.hasNext()) {
            PersistenceUnit pUnit = (PersistenceUnit)stream.next();
            if (!pUnitName.equals(pUnit.getName())) continue;
            return pUnit;
        }
        throw new ExecutionException("persistence.xml does not have persistence unit named '" + pUnitName + "'");
    }

    protected IFolder createSourceFolder() throws ExecutionException {
        String folderPath = this.model.getStringProperty("OrmFileCreationDataModelProperties.SOURCE_FOLDER");
        IProject project = this.getProject();
        IFolder folder = project.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                throw new ExecutionException("Could not create folder", (Throwable)e);
            }
        }
        return folder;
    }

    protected IFile createMappingFile(IFolder folder) {
        JpaXmlResource xmlResource;
        String filePath = this.getDataModel().getStringProperty("OrmFileCreationDataModelProperties.FILE_PATH");
        IFile file = folder.getFile((IPath)new Path(filePath));
        AbstractXmlResourceProvider resourceProvider = this.getXmlResourceProvider(file);
        try {
            xmlResource = resourceProvider.createFileAndResource();
        }
        catch (CoreException e) {
            JptCorePlugin.log(e);
            return null;
        }
        xmlResource.modify(new Runnable(){

            public void run() {
                AccessType defaultAccess = (AccessType)((Object)OrmFileCreationOperation.this.getDataModel().getProperty("OrmFileCreationDataModelProperties.DEFAULT_ACCESS"));
                if (defaultAccess != null) {
                    XmlPersistenceUnitMetadata puMetadata = OrmFileCreationOperation.this.createXmlPersistenceUnitMetadata();
                    ((XmlEntityMappings)xmlResource.getRootObject()).setPersistenceUnitMetadata(puMetadata);
                    XmlPersistenceUnitDefaults puDefaults = OrmFileCreationOperation.this.createXmlPersistenceUnitDefaults();
                    puMetadata.setPersistenceUnitDefaults(puDefaults);
                    puDefaults.setAccess(defaultAccess);
                }
            }
        });
        return file;
    }

    protected XmlPersistenceUnitMetadata createXmlPersistenceUnitMetadata() {
        return OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata();
    }

    protected XmlPersistenceUnitDefaults createXmlPersistenceUnitDefaults() {
        return OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
    }

    protected AbstractXmlResourceProvider getXmlResourceProvider(IFile file) {
        return OrmXmlResourceProvider.getXmlResourceProvider(file);
    }

    protected void addMappingFileToPersistenceXml(IFile file) throws ExecutionException {
        if (!this.getDataModel().getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            return;
        }
        JpaProject jpaProject = JptCorePlugin.getJpaProject(file.getProject());
        JpaXmlResource resource = jpaProject.getPersistenceXmlResource();
        final PersistenceUnit pUnit = this.getPersistenceUnit();
        resource.modify(new Runnable(){

            public void run() {
                String filePath = OrmFileCreationOperation.this.getDataModel().getStringProperty("OrmFileCreationDataModelProperties.FILE_PATH");
                ListIterator<MappingFileRef> stream = pUnit.specifiedMappingFileRefs();
                while (stream.hasNext()) {
                    if (!filePath.equals(((MappingFileRef)stream.next()).getFileName())) continue;
                    return;
                }
                MappingFileRef mfRef = pUnit.addSpecifiedMappingFileRef();
                mfRef.setFileName(new Path(filePath).toPortableString());
            }
        });
    }
}

