/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPrimaryKeyJoinColumn
extends AbstractJavaNamedColumn<PrimaryKeyJoinColumnAnnotation>
implements JavaPrimaryKeyJoinColumn {
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;
    protected PrimaryKeyJoinColumnAnnotation resourcePrimaryKeyJoinColumn;

    public GenericJavaPrimaryKeyJoinColumn(JavaJpaContextNode parent, JavaBaseJoinColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initialize(PrimaryKeyJoinColumnAnnotation column) {
        this.resourcePrimaryKeyJoinColumn = column;
        super.initialize(column);
        this.specifiedReferencedColumnName = this.specifiedReferencedColumnName(column);
        this.defaultReferencedColumnName = this.defaultReferencedColumnName();
    }

    @Override
    public JavaBaseJoinColumn.Owner getOwner() {
        return (JavaBaseJoinColumn.Owner)super.getOwner();
    }

    @Override
    protected PrimaryKeyJoinColumnAnnotation getResourceColumn() {
        return this.resourcePrimaryKeyJoinColumn;
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName == null ? this.defaultReferencedColumnName : this.specifiedReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.getResourceColumn().setReferencedColumnName(newSpecifiedReferencedColumnName);
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    protected void setSpecifiedReferencedColumnName_(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        this.firePropertyChanged("defaultReferencedColumnName", oldDefaultReferencedColumnName, newDefaultReferencedColumnName);
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    protected String getTableName() {
        return this.getOwner().getTypeMapping().getPrimaryTableName();
    }

    @Override
    public Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return this.getOwner().getReferencedColumnDbTable();
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.getResourceColumn().referencedColumnNameTouches(pos, astRoot);
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos, astRoot)) {
            return this.javaCandidateReferencedColumnNames(filter);
        }
        return null;
    }

    private Iterator<String> javaCandidateReferencedColumnNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateReferencedColumnNames(filter));
    }

    private Iterator<String> candidateReferencedColumnNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateReferencedColumnNames(), filter);
    }

    private Iterator<String> candidateReferencedColumnNames() {
        Table table = this.getOwner().getReferencedColumnDbTable();
        return table != null ? table.sortedColumnIdentifiers() : EmptyIterator.instance();
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        return this.getResourceColumn().getReferencedColumnNameTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getResourceColumn().getTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    @Override
    public void update(PrimaryKeyJoinColumnAnnotation resourceColumn) {
        this.resourcePrimaryKeyJoinColumn = resourceColumn;
        super.update(resourceColumn);
        this.setSpecifiedReferencedColumnName_(this.specifiedReferencedColumnName(resourceColumn));
        this.setDefaultReferencedColumnName(this.defaultReferencedColumnName());
    }

    protected String specifiedReferencedColumnName(PrimaryKeyJoinColumnAnnotation resourceColumn) {
        return resourceColumn.getReferencedColumnName();
    }

    protected String defaultReferencedColumnName() {
        return this.buildDefaultName();
    }

    @Override
    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append("=>");
        sb.append(this.getReferencedColumnName());
    }
}

