/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.IJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.InvalidWriteAccessModeException;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ArtifactEditJSFAppConfigProvider
implements IJSFAppConfigProvider {
    protected IFile appConfigFile = null;
    protected FacesConfigArtifactEdit facesConfigArtifactEdit = null;

    public ArtifactEditJSFAppConfigProvider(IFile appConfigFile) {
        this.appConfigFile = appConfigFile;
    }

    public FacesConfigType getFacesConfigModel(boolean forWrite) throws InvalidWriteAccessModeException {
        FacesConfigType facesConfig = null;
        if (this.appConfigFile != null) {
            IProject project = this.appConfigFile.getProject();
            IPath appConfigFilePath = JSFAppConfigUtils.getWebContentFolderRelativePath(this.appConfigFile);
            if (appConfigFilePath != null) {
                if (forWrite) {
                    if (!this.allowsWrite()) {
                        throw new InvalidWriteAccessModeException(Messages.JSFAppConfigManager_InvalidWriteAccess);
                    }
                    this.facesConfigArtifactEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)appConfigFilePath.toString());
                } else {
                    this.facesConfigArtifactEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)appConfigFilePath.toString());
                }
                if (this.facesConfigArtifactEdit != null) {
                    facesConfig = this.facesConfigArtifactEdit.getFacesConfig();
                }
            }
        }
        return facesConfig;
    }

    public void releaseFacesConfigModel() {
        if (this.facesConfigArtifactEdit != null) {
            this.facesConfigArtifactEdit.dispose();
        }
    }

    public boolean allowsWrite() {
        return true;
    }
}

