/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.contentmodel.annotation;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jst.jsf.core.internal.contentmodel.annotation.ICMAnnotationAdvisor;
import org.eclipse.jst.jsf.core.internal.provisional.contentmodel.annotation.CMAnnotationSourceFileLocator;
import org.eclipse.jst.jsf.core.internal.provisional.contentmodel.annotation.ICMAnnotationFileParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CMAnnotationFileParser
implements ICMAnnotationFileParser {
    public static final String TAG_ID_ANNOTATIONS = "grammar-annotations";
    public static final String TAG_ID_ELEMENT = "cm-element";
    public static final String TAG_ID_ATTRIBUTE = "cm-attribute";
    public static final String TAG_ID_PROPERTY = "property";
    public static final String TAG_ID_PROPERTY_VALUE = "value";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(ICMAnnotationAdvisor advisor, InputStream input) throws Exception {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(input), (DefaultHandler)new CMAnnotationMapContentHandler(advisor));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            if (input == null) throw throwable;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            if (input == null) return;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        input.close();
    }

    public void parse(ICMAnnotationAdvisor advisor, CMAnnotationSourceFileLocator locator) throws Exception {
        InputStream inputStream = locator.getAnnotationSourceInputStream();
        this.parse(advisor, inputStream);
    }

    protected class CMAnnotationMapContentHandler
    extends DefaultHandler {
        private ICMAnnotationAdvisor advisor;
        private String elementName;
        private String attributeName;
        private String currentPropertyName;
        private String currentPropertyValue;
        private StringBuffer propertyValueBuffer;
        private boolean isInCMAttribute = false;
        private boolean doCaptureNodeText;

        public CMAnnotationMapContentHandler(ICMAnnotationAdvisor advisor) {
            this.advisor = advisor;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals(CMAnnotationFileParser.TAG_ID_ANNOTATIONS)) {
                int attributesLength = attributes.getLength();
                int i = 0;
                while (i < attributesLength) {
                    String attributeName = attributes.getLocalName(i);
                    String attributeValue = attributes.getValue(i);
                    if (attributeName.equals("caseSensitive") && attributeValue.trim().equals("false")) {
                        this.advisor.setCaseSensitive(false);
                    }
                    ++i;
                }
            } else if (localName.equals(CMAnnotationFileParser.TAG_ID_ELEMENT)) {
                this.isInCMAttribute = false;
                this.elementName = attributes.getValue("name");
            } else if (localName.equals(CMAnnotationFileParser.TAG_ID_ATTRIBUTE)) {
                this.isInCMAttribute = true;
                this.attributeName = attributes.getValue("name");
            } else if (localName.equals(CMAnnotationFileParser.TAG_ID_PROPERTY)) {
                this.currentPropertyName = attributes.getValue("name");
            } else if (localName.equals(CMAnnotationFileParser.TAG_ID_PROPERTY_VALUE)) {
                this.propertyValueBuffer = new StringBuffer();
                this.doCaptureNodeText = true;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.currentPropertyName != null && localName.equals(CMAnnotationFileParser.TAG_ID_PROPERTY_VALUE)) {
                this.doCaptureNodeText = false;
                this.currentPropertyValue = this.propertyValueBuffer.toString();
                if (this.currentPropertyValue != null) {
                    if (this.isInCMAttribute) {
                        this.advisor.addAttributeAnnotation(this.elementName, this.attributeName, this.currentPropertyName, this.currentPropertyValue);
                    } else {
                        this.advisor.addElementAnnotation(this.elementName, this.currentPropertyName, this.currentPropertyValue);
                    }
                }
            }
            if (localName.equals(CMAnnotationFileParser.TAG_ID_ELEMENT)) {
                this.elementName = null;
            } else if (localName.equals(CMAnnotationFileParser.TAG_ID_ATTRIBUTE)) {
                this.isInCMAttribute = false;
                this.attributeName = null;
            } else if (localName.equals(CMAnnotationFileParser.TAG_ID_PROPERTY)) {
                this.currentPropertyName = null;
            } else if (localName.equals(CMAnnotationFileParser.TAG_ID_PROPERTY_VALUE)) {
                this.currentPropertyValue = null;
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.doCaptureNodeText) {
                this.propertyValueBuffer.append(ch, start, length);
            }
        }
    }
}

