/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.Iterator;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.SingleElementListIterator;
import org.eclipse.dali.utility.tests.iterators.SingleElementIteratorTests;

public class SingleElementListIteratorTests
extends SingleElementIteratorTests {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.SingleElementListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.SingleElementListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public SingleElementListIteratorTests(String name) {
        super(name);
    }

    public void testNextIndex() {
        ListIterator stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)0, (int)stream.nextIndex());
            stream.next();
        }
        SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)1, (int)stream.nextIndex());
    }

    public void testHasPrevious() {
        int i = 0;
        ListIterator stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        SingleElementListIteratorTests.assertEquals((int)1, (int)i);
        while (stream.hasPrevious()) {
            stream.previous();
            ++i;
        }
        SingleElementListIteratorTests.assertEquals((int)2, (int)i);
    }

    public void testPrevious() {
        ListIterator stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus element", (Object)this.singleElement(), stream.next());
        }
        while (stream.hasPrevious()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus element", (Object)this.singleElement(), stream.previous());
        }
    }

    public void testPreviousIndex() {
        ListIterator stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)0, (int)stream.nextIndex());
            stream.next();
        }
        while (stream.hasPrevious()) {
            SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)0, (int)stream.previousIndex());
            stream.previous();
        }
        SingleElementListIteratorTests.assertEquals((String)"bogus index", (int)-1, (int)stream.previousIndex());
    }

    public void testAdd() {
        boolean exCaught = false;
        ListIterator stream = this.buildSingleElementListIterator();
        try {
            stream.add(new Object());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        SingleElementListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testSet() {
        boolean exCaught = false;
        ListIterator stream = this.buildSingleElementListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals(this.singleElement())) continue;
            try {
                stream.set(new Object());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        SingleElementListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    protected Iterator buildSingleElementIterator() {
        return new SingleElementListIterator(this.singleElement());
    }

    protected ListIterator buildSingleElementListIterator() {
        return (ListIterator)this.buildSingleElementIterator();
    }
}

